<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CouponSequence StructType
 * Meta information extracted from the WSDL
 * - documentation: The two/three character designator identifying the marketing carrier whose fare is used from a board point to a stopover or connection point. | The from and to airport/city code. | Sequence number, coupon/itinerary sequence nbr, from
 * and to city codes, stopover indicator, and airline designator.
 * @subpackage Structs
 */
class CouponSequence extends AbstractStructBase
{
    /**
     * The SequenceNbr
     * Meta information extracted from the WSDL
     * - documentation: Represents the sequential order of the coupon(s) that apply within a specific fare component of a ticket being issued, e.g. 1 of 5.
     * - use: optional
     * @var string
     */
    public $SequenceNbr;
    /**
     * The CouponItinerarySeqNbr
     * Meta information extracted from the WSDL
     * - documentation: The number representing the order in which this coupon was is to be used.
     * - use: optional
     * @var int
     */
    public $CouponItinerarySeqNbr;
    /**
     * The StopoverInd
     * Meta information extracted from the WSDL
     * - documentation: When true, a stopover is permitted.
     * - use: optional
     * @var bool
     */
    public $StopoverInd;
    /**
     * The ResBookDesigCode
     * Meta information extracted from the WSDL
     * - documentation: The RBD at the time of pricing.
     * - use: optional
     * @var string
     */
    public $ResBookDesigCode;
    /**
     * Constructor method for CouponSequence
     * @uses CouponSequence::setSequenceNbr()
     * @uses CouponSequence::setCouponItinerarySeqNbr()
     * @uses CouponSequence::setStopoverInd()
     * @uses CouponSequence::setResBookDesigCode()
     * @param string $sequenceNbr
     * @param int $couponItinerarySeqNbr
     * @param bool $stopoverInd
     * @param string $resBookDesigCode
     */
    public function __construct($sequenceNbr = null, $couponItinerarySeqNbr = null, $stopoverInd = null, $resBookDesigCode = null)
    {
        $this
            ->setSequenceNbr($sequenceNbr)
            ->setCouponItinerarySeqNbr($couponItinerarySeqNbr)
            ->setStopoverInd($stopoverInd)
            ->setResBookDesigCode($resBookDesigCode);
    }
    /**
     * Get SequenceNbr value
     * @return string|null
     */
    public function getSequenceNbr()
    {
        return $this->SequenceNbr;
    }
    /**
     * Set SequenceNbr value
     * @param string $sequenceNbr
     * @return \StructType\CouponSequence
     */
    public function setSequenceNbr($sequenceNbr = null)
    {
        // validation for constraint: string
        if (!is_null($sequenceNbr) && !is_string($sequenceNbr)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sequenceNbr, true), gettype($sequenceNbr)), __LINE__);
        }
        $this->SequenceNbr = $sequenceNbr;
        return $this;
    }
    /**
     * Get CouponItinerarySeqNbr value
     * @return int|null
     */
    public function getCouponItinerarySeqNbr()
    {
        return $this->CouponItinerarySeqNbr;
    }
    /**
     * Set CouponItinerarySeqNbr value
     * @param int $couponItinerarySeqNbr
     * @return \StructType\CouponSequence
     */
    public function setCouponItinerarySeqNbr($couponItinerarySeqNbr = null)
    {
        // validation for constraint: int
        if (!is_null($couponItinerarySeqNbr) && !(is_int($couponItinerarySeqNbr) || ctype_digit($couponItinerarySeqNbr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($couponItinerarySeqNbr, true), gettype($couponItinerarySeqNbr)), __LINE__);
        }
        $this->CouponItinerarySeqNbr = $couponItinerarySeqNbr;
        return $this;
    }
    /**
     * Get StopoverInd value
     * @return bool|null
     */
    public function getStopoverInd()
    {
        return $this->StopoverInd;
    }
    /**
     * Set StopoverInd value
     * @param bool $stopoverInd
     * @return \StructType\CouponSequence
     */
    public function setStopoverInd($stopoverInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($stopoverInd) && !is_bool($stopoverInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($stopoverInd, true), gettype($stopoverInd)), __LINE__);
        }
        $this->StopoverInd = $stopoverInd;
        return $this;
    }
    /**
     * Get ResBookDesigCode value
     * @return string|null
     */
    public function getResBookDesigCode()
    {
        return $this->ResBookDesigCode;
    }
    /**
     * Set ResBookDesigCode value
     * @param string $resBookDesigCode
     * @return \StructType\CouponSequence
     */
    public function setResBookDesigCode($resBookDesigCode = null)
    {
        // validation for constraint: string
        if (!is_null($resBookDesigCode) && !is_string($resBookDesigCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resBookDesigCode, true), gettype($resBookDesigCode)), __LINE__);
        }
        $this->ResBookDesigCode = $resBookDesigCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CouponSequence
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
