<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CostingItems StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of invoice item lines.
 * @subpackage Structs
 */
class CostingItems extends AbstractStructBase
{
    /**
     * The CostingItem
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var mixed[]
     */
    public $CostingItem;
    /**
     * Constructor method for CostingItems
     * @uses CostingItems::setCostingItem()
     * @param mixed[] $costingItem
     */
    public function __construct(array $costingItem = array())
    {
        $this
            ->setCostingItem($costingItem);
    }
    /**
     * Get CostingItem value
     * @return mixed[]|null
     */
    public function getCostingItem()
    {
        return $this->CostingItem;
    }
    /**
     * This method is responsible for validating the values passed to the setCostingItem method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCostingItem method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCostingItemForArrayConstraintsFromSetCostingItem(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $costingItemsCostingItemItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($costingItemsCostingItemItem) ? get_class($costingItemsCostingItemItem) : sprintf('%s(%s)', gettype($costingItemsCostingItemItem), var_export($costingItemsCostingItemItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CostingItem property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CostingItem value
     * @throws \InvalidArgumentException
     * @param mixed[] $costingItem
     * @return \StructType\CostingItems
     */
    public function setCostingItem(array $costingItem = array())
    {
        // validation for constraint: array
        if ('' !== ($costingItemArrayErrorMessage = self::validateCostingItemForArrayConstraintsFromSetCostingItem($costingItem))) {
            throw new \InvalidArgumentException($costingItemArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($costingItem) && count($costingItem) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($costingItem)), __LINE__);
        }
        $this->CostingItem = $costingItem;
        return $this;
    }
    /**
     * Add item to CostingItem value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CostingItems
     */
    public function addToCostingItem($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The CostingItem property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CostingItem) && count($this->CostingItem) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CostingItem)), __LINE__);
        }
        $this->CostingItem[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CostingItems
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
