<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContactInfosType StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of ContactInfo elements that provides detailed contact information.
 * @subpackage Structs
 */
class ContactInfosType extends AbstractStructBase
{
    /**
     * The ContactInfo
     * Meta information extracted from the WSDL
     * - documentation: Used to define specific contact information such as phone and address.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ContactInfo;
    /**
     * Constructor method for ContactInfosType
     * @uses ContactInfosType::setContactInfo()
     * @param mixed[] $contactInfo
     */
    public function __construct(array $contactInfo = array())
    {
        $this
            ->setContactInfo($contactInfo);
    }
    /**
     * Get ContactInfo value
     * @return mixed[]|null
     */
    public function getContactInfo()
    {
        return $this->ContactInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoForArrayConstraintsFromSetContactInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $contactInfosTypeContactInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($contactInfosTypeContactInfoItem) ? get_class($contactInfosTypeContactInfoItem) : sprintf('%s(%s)', gettype($contactInfosTypeContactInfoItem), var_export($contactInfosTypeContactInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $contactInfo
     * @return \StructType\ContactInfosType
     */
    public function setContactInfo(array $contactInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoArrayErrorMessage = self::validateContactInfoForArrayConstraintsFromSetContactInfo($contactInfo))) {
            throw new \InvalidArgumentException($contactInfoArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($contactInfo) && count($contactInfo) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($contactInfo)), __LINE__);
        }
        $this->ContactInfo = $contactInfo;
        return $this;
    }
    /**
     * Add item to ContactInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ContactInfosType
     */
    public function addToContactInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ContactInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ContactInfo) && count($this->ContactInfo) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ContactInfo)), __LINE__);
        }
        $this->ContactInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContactInfosType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
