<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConstructionPrinciple StructType
 * Meta information extracted from the WSDL
 * - documentation: The from and to airport/city code. | Principle indicator, from and to airport/city code, amount and percent.
 * @subpackage Structs
 */
class ConstructionPrinciple extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: A code identifying a rule used to formulate the fare.
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - documentation: An amount applicable to the fare rule based on the fare component construction principle indicator.
     * - use: optional
     * @var float
     */
    public $Amount;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: A percentage applicable to the fare rule based on the fare component construction principle indicator.
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * Constructor method for ConstructionPrinciple
     * @uses ConstructionPrinciple::setCode()
     * @uses ConstructionPrinciple::setAmount()
     * @uses ConstructionPrinciple::setPercent()
     * @param string $code
     * @param float $amount
     * @param float $percent
     */
    public function __construct($code = null, $amount = null, $percent = null)
    {
        $this
            ->setCode($code)
            ->setAmount($amount)
            ->setPercent($percent);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ConstructionPrinciple
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\ConstructionPrinciple
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\ConstructionPrinciple
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConstructionPrinciple
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
