<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConnectionLocation StructType
 * Meta information extracted from the WSDL
 * - documentation: The preference level for the connection point - only, unacceptable, preferred. | Travel Connection location and other information. | Specifies a connection location, preference level, minimum connection time, and whether the location
 * is allowed for stopping or changing. | Specifies a connection location, preference level, min connection time, and whether the location is allowed for stopping or changing.
 * @subpackage Structs
 */
class ConnectionLocation extends LocationType
{
    /**
     * The Inclusive
     * Meta information extracted from the WSDL
     * - documentation: true | When true, indicates the location is acceptable for a connection. When false the location should not be included for a connection.
     * - use: optional
     * @var bool
     */
    public $Inclusive;
    /**
     * The MinChangeTime
     * Meta information extracted from the WSDL
     * - documentation: Number of minutes between connections.
     * - use: optional
     * @var int
     */
    public $MinChangeTime;
    /**
     * The ConnectionInfo
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConnectionInfo;
    /**
     * The MultiAirportCityInd
     * Meta information extracted from the WSDL
     * - documentation: If true, other airports within this city may be considered (e.g., EWR, JFK when origin location is LGA.)
     * - use: optional
     * @var bool
     */
    public $MultiAirportCityInd;
    /**
     * The ConnectType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $ConnectType;
    /**
     * The MultiCityStationInd
     * Meta information extracted from the WSDL
     * - documentation: If true, multiple train stations within a specified city or location code may be considered.
     * - use: optional
     * @var bool
     */
    public $MultiCityStationInd;
    /**
     * The OperatorPref
     * Meta information extracted from the WSDL
     * - documentation: Describes any preferences in terms of the company operating the train service. Preference may reflect inclusion or exclusion.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $OperatorPref;
    /**
     * Constructor method for ConnectionLocation
     * @uses ConnectionLocation::setInclusive()
     * @uses ConnectionLocation::setMinChangeTime()
     * @uses ConnectionLocation::setConnectionInfo()
     * @uses ConnectionLocation::setMultiAirportCityInd()
     * @uses ConnectionLocation::setConnectType()
     * @uses ConnectionLocation::setMultiCityStationInd()
     * @uses ConnectionLocation::setOperatorPref()
     * @param bool $inclusive
     * @param int $minChangeTime
     * @param string $connectionInfo
     * @param bool $multiAirportCityInd
     * @param string $connectType
     * @param bool $multiCityStationInd
     * @param mixed[] $operatorPref
     */
    public function __construct($inclusive = null, $minChangeTime = null, $connectionInfo = null, $multiAirportCityInd = null, $connectType = null, $multiCityStationInd = null, array $operatorPref = array())
    {
        $this
            ->setInclusive($inclusive)
            ->setMinChangeTime($minChangeTime)
            ->setConnectionInfo($connectionInfo)
            ->setMultiAirportCityInd($multiAirportCityInd)
            ->setConnectType($connectType)
            ->setMultiCityStationInd($multiCityStationInd)
            ->setOperatorPref($operatorPref);
    }
    /**
     * Get Inclusive value
     * @return bool|null
     */
    public function getInclusive()
    {
        return $this->Inclusive;
    }
    /**
     * Set Inclusive value
     * @param bool $inclusive
     * @return \StructType\ConnectionLocation
     */
    public function setInclusive($inclusive = null)
    {
        // validation for constraint: boolean
        if (!is_null($inclusive) && !is_bool($inclusive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($inclusive, true), gettype($inclusive)), __LINE__);
        }
        $this->Inclusive = $inclusive;
        return $this;
    }
    /**
     * Get MinChangeTime value
     * @return int|null
     */
    public function getMinChangeTime()
    {
        return $this->MinChangeTime;
    }
    /**
     * Set MinChangeTime value
     * @param int $minChangeTime
     * @return \StructType\ConnectionLocation
     */
    public function setMinChangeTime($minChangeTime = null)
    {
        // validation for constraint: int
        if (!is_null($minChangeTime) && !(is_int($minChangeTime) || ctype_digit($minChangeTime))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minChangeTime, true), gettype($minChangeTime)), __LINE__);
        }
        $this->MinChangeTime = $minChangeTime;
        return $this;
    }
    /**
     * Get ConnectionInfo value
     * @return string|null
     */
    public function getConnectionInfo()
    {
        return $this->ConnectionInfo;
    }
    /**
     * Set ConnectionInfo value
     * @param string $connectionInfo
     * @return \StructType\ConnectionLocation
     */
    public function setConnectionInfo($connectionInfo = null)
    {
        // validation for constraint: string
        if (!is_null($connectionInfo) && !is_string($connectionInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectionInfo, true), gettype($connectionInfo)), __LINE__);
        }
        $this->ConnectionInfo = $connectionInfo;
        return $this;
    }
    /**
     * Get MultiAirportCityInd value
     * @return bool|null
     */
    public function getMultiAirportCityInd()
    {
        return $this->MultiAirportCityInd;
    }
    /**
     * Set MultiAirportCityInd value
     * @param bool $multiAirportCityInd
     * @return \StructType\ConnectionLocation
     */
    public function setMultiAirportCityInd($multiAirportCityInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiAirportCityInd) && !is_bool($multiAirportCityInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiAirportCityInd, true), gettype($multiAirportCityInd)), __LINE__);
        }
        $this->MultiAirportCityInd = $multiAirportCityInd;
        return $this;
    }
    /**
     * Get ConnectType value
     * @return string|null
     */
    public function getConnectType()
    {
        return $this->ConnectType;
    }
    /**
     * Set ConnectType value
     * @param string $connectType
     * @return \StructType\ConnectionLocation
     */
    public function setConnectType($connectType = null)
    {
        // validation for constraint: string
        if (!is_null($connectType) && !is_string($connectType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($connectType, true), gettype($connectType)), __LINE__);
        }
        $this->ConnectType = $connectType;
        return $this;
    }
    /**
     * Get MultiCityStationInd value
     * @return bool|null
     */
    public function getMultiCityStationInd()
    {
        return $this->MultiCityStationInd;
    }
    /**
     * Set MultiCityStationInd value
     * @param bool $multiCityStationInd
     * @return \StructType\ConnectionLocation
     */
    public function setMultiCityStationInd($multiCityStationInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiCityStationInd) && !is_bool($multiCityStationInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiCityStationInd, true), gettype($multiCityStationInd)), __LINE__);
        }
        $this->MultiCityStationInd = $multiCityStationInd;
        return $this;
    }
    /**
     * Get OperatorPref value
     * @return mixed[]|null
     */
    public function getOperatorPref()
    {
        return $this->OperatorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setOperatorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperatorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperatorPrefForArrayConstraintsFromSetOperatorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $connectionLocationOperatorPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($connectionLocationOperatorPrefItem) ? get_class($connectionLocationOperatorPrefItem) : sprintf('%s(%s)', gettype($connectionLocationOperatorPrefItem), var_export($connectionLocationOperatorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OperatorPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperatorPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $operatorPref
     * @return \StructType\ConnectionLocation
     */
    public function setOperatorPref(array $operatorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($operatorPrefArrayErrorMessage = self::validateOperatorPrefForArrayConstraintsFromSetOperatorPref($operatorPref))) {
            throw new \InvalidArgumentException($operatorPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($operatorPref) && count($operatorPref) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($operatorPref)), __LINE__);
        }
        $this->OperatorPref = $operatorPref;
        return $this;
    }
    /**
     * Add item to OperatorPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ConnectionLocation
     */
    public function addToOperatorPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OperatorPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->OperatorPref) && count($this->OperatorPref) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->OperatorPref)), __LINE__);
        }
        $this->OperatorPref[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConnectionLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
