<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompatibleOffer StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines which other offers this offer may be use in conjuction with.
 * @subpackage Structs
 */
class CompatibleOffer extends AbstractStructBase
{
    /**
     * The OfferRPH
     * Meta information extracted from the WSDL
     * - documentation: References the other offer(s) with which this offer may be used.
     * - use: optional
     * @var list
     */
    public $OfferRPH;
    /**
     * The IncompatibleOfferIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true this offer is incompatible with the OfferRPH. When false this offer is compatible with the OfferRPH.
     * - use: optional
     * @var bool
     */
    public $IncompatibleOfferIndicator;
    /**
     * Constructor method for CompatibleOffer
     * @uses CompatibleOffer::setOfferRPH()
     * @uses CompatibleOffer::setIncompatibleOfferIndicator()
     * @param list $offerRPH
     * @param bool $incompatibleOfferIndicator
     */
    public function __construct(list $offerRPH = null, $incompatibleOfferIndicator = null)
    {
        $this
            ->setOfferRPH($offerRPH)
            ->setIncompatibleOfferIndicator($incompatibleOfferIndicator);
    }
    /**
     * Get OfferRPH value
     * @return list|null
     */
    public function getOfferRPH()
    {
        return $this->OfferRPH;
    }
    /**
     * Set OfferRPH value
     * @param list $offerRPH
     * @return \StructType\CompatibleOffer
     */
    public function setOfferRPH(list $offerRPH = null)
    {
        $this->OfferRPH = $offerRPH;
        return $this;
    }
    /**
     * Get IncompatibleOfferIndicator value
     * @return bool|null
     */
    public function getIncompatibleOfferIndicator()
    {
        return $this->IncompatibleOfferIndicator;
    }
    /**
     * Set IncompatibleOfferIndicator value
     * @param bool $incompatibleOfferIndicator
     * @return \StructType\CompatibleOffer
     */
    public function setIncompatibleOfferIndicator($incompatibleOfferIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($incompatibleOfferIndicator) && !is_bool($incompatibleOfferIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($incompatibleOfferIndicator, true), gettype($incompatibleOfferIndicator)), __LINE__);
        }
        $this->IncompatibleOfferIndicator = $incompatibleOfferIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompatibleOffer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
