<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CompanyInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: The currency used by this company. | Detailed information about a company.
 * @subpackage Structs
 */
class CompanyInfoType extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - documentation: Detailed name information for the company.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $CompanyName;
    /**
     * The AddressInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AddressInfo[]
     */
    public $AddressInfo;
    /**
     * The TelephoneInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TelephoneInfo[]
     */
    public $TelephoneInfo;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Email[]
     */
    public $Email;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: Information on a URL for the company.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $URL;
    /**
     * The BusinessLocale
     * Meta information extracted from the WSDL
     * - documentation: A jurisdiction in which a company is authorized to do business. Uses the Address entity to indicate the location of business using any of the components of the address (e.g., city, state, zip code, country).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $BusinessLocale;
    /**
     * The PaymentForm
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentForm[]
     */
    public $PaymentForm;
    /**
     * The DepositPayment
     * Meta information extracted from the WSDL
     * - documentation: Description: A deposit policy that is associated to this profile.
     * - minOccurs: 0
     * @var mixed
     */
    public $DepositPayment;
    /**
     * The ContactPerson
     * Meta information extracted from the WSDL
     * - documentation: Information on a contact person for the company.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ContactPerson;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - documentation: Information on the organization responsible for arranging travel for the company.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TravelArranger;
    /**
     * The LoyaltyProgram
     * Meta information extracted from the WSDL
     * - documentation: Company's loyalty program information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LoyaltyProgram;
    /**
     * The TripPurpose
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TripPurpose[]
     */
    public $TripPurpose;
    /**
     * Constructor method for CompanyInfoType
     * @uses CompanyInfoType::setCompanyName()
     * @uses CompanyInfoType::setAddressInfo()
     * @uses CompanyInfoType::setTelephoneInfo()
     * @uses CompanyInfoType::setEmail()
     * @uses CompanyInfoType::setURL()
     * @uses CompanyInfoType::setBusinessLocale()
     * @uses CompanyInfoType::setPaymentForm()
     * @uses CompanyInfoType::setDepositPayment()
     * @uses CompanyInfoType::setContactPerson()
     * @uses CompanyInfoType::setTravelArranger()
     * @uses CompanyInfoType::setLoyaltyProgram()
     * @uses CompanyInfoType::setTripPurpose()
     * @param mixed[] $companyName
     * @param \StructType\AddressInfo[] $addressInfo
     * @param \StructType\TelephoneInfo[] $telephoneInfo
     * @param \StructType\Email[] $email
     * @param mixed[] $uRL
     * @param mixed[] $businessLocale
     * @param \StructType\PaymentForm[] $paymentForm
     * @param mixed $depositPayment
     * @param mixed[] $contactPerson
     * @param mixed[] $travelArranger
     * @param mixed[] $loyaltyProgram
     * @param \StructType\TripPurpose[] $tripPurpose
     */
    public function __construct(array $companyName = array(), array $addressInfo = array(), array $telephoneInfo = array(), array $email = array(), array $uRL = array(), array $businessLocale = array(), array $paymentForm = array(), $depositPayment = null, array $contactPerson = array(), array $travelArranger = array(), array $loyaltyProgram = array(), array $tripPurpose = array())
    {
        $this
            ->setCompanyName($companyName)
            ->setAddressInfo($addressInfo)
            ->setTelephoneInfo($telephoneInfo)
            ->setEmail($email)
            ->setURL($uRL)
            ->setBusinessLocale($businessLocale)
            ->setPaymentForm($paymentForm)
            ->setDepositPayment($depositPayment)
            ->setContactPerson($contactPerson)
            ->setTravelArranger($travelArranger)
            ->setLoyaltyProgram($loyaltyProgram)
            ->setTripPurpose($tripPurpose);
    }
    /**
     * Get CompanyName value
     * @return mixed[]|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * This method is responsible for validating the values passed to the setCompanyName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCompanyName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCompanyNameForArrayConstraintsFromSetCompanyName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeCompanyNameItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($companyInfoTypeCompanyNameItem) ? get_class($companyInfoTypeCompanyNameItem) : sprintf('%s(%s)', gettype($companyInfoTypeCompanyNameItem), var_export($companyInfoTypeCompanyNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CompanyName property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CompanyName value
     * @throws \InvalidArgumentException
     * @param mixed[] $companyName
     * @return \StructType\CompanyInfoType
     */
    public function setCompanyName(array $companyName = array())
    {
        // validation for constraint: array
        if ('' !== ($companyNameArrayErrorMessage = self::validateCompanyNameForArrayConstraintsFromSetCompanyName($companyName))) {
            throw new \InvalidArgumentException($companyNameArrayErrorMessage, __LINE__);
        }
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Add item to CompanyName value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CompanyInfoType
     */
    public function addToCompanyName($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The CompanyName property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CompanyName[] = $item;
        return $this;
    }
    /**
     * Get AddressInfo value
     * @return \StructType\AddressInfo[]|null
     */
    public function getAddressInfo()
    {
        return $this->AddressInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressInfoForArrayConstraintsFromSetAddressInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeAddressInfoItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeAddressInfoItem instanceof \StructType\AddressInfo) {
                $invalidValues[] = is_object($companyInfoTypeAddressInfoItem) ? get_class($companyInfoTypeAddressInfoItem) : sprintf('%s(%s)', gettype($companyInfoTypeAddressInfoItem), var_export($companyInfoTypeAddressInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressInfo property can only contain items of type \StructType\AddressInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressInfo[] $addressInfo
     * @return \StructType\CompanyInfoType
     */
    public function setAddressInfo(array $addressInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($addressInfoArrayErrorMessage = self::validateAddressInfoForArrayConstraintsFromSetAddressInfo($addressInfo))) {
            throw new \InvalidArgumentException($addressInfoArrayErrorMessage, __LINE__);
        }
        $this->AddressInfo = $addressInfo;
        return $this;
    }
    /**
     * Add item to AddressInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\AddressInfo $item
     * @return \StructType\CompanyInfoType
     */
    public function addToAddressInfo(\StructType\AddressInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddressInfo) {
            throw new \InvalidArgumentException(sprintf('The AddressInfo property can only contain items of type \StructType\AddressInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressInfo[] = $item;
        return $this;
    }
    /**
     * Get TelephoneInfo value
     * @return \StructType\TelephoneInfo[]|null
     */
    public function getTelephoneInfo()
    {
        return $this->TelephoneInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setTelephoneInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTelephoneInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTelephoneInfoForArrayConstraintsFromSetTelephoneInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeTelephoneInfoItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeTelephoneInfoItem instanceof \StructType\TelephoneInfo) {
                $invalidValues[] = is_object($companyInfoTypeTelephoneInfoItem) ? get_class($companyInfoTypeTelephoneInfoItem) : sprintf('%s(%s)', gettype($companyInfoTypeTelephoneInfoItem), var_export($companyInfoTypeTelephoneInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TelephoneInfo property can only contain items of type \StructType\TelephoneInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TelephoneInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TelephoneInfo[] $telephoneInfo
     * @return \StructType\CompanyInfoType
     */
    public function setTelephoneInfo(array $telephoneInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($telephoneInfoArrayErrorMessage = self::validateTelephoneInfoForArrayConstraintsFromSetTelephoneInfo($telephoneInfo))) {
            throw new \InvalidArgumentException($telephoneInfoArrayErrorMessage, __LINE__);
        }
        $this->TelephoneInfo = $telephoneInfo;
        return $this;
    }
    /**
     * Add item to TelephoneInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\TelephoneInfo $item
     * @return \StructType\CompanyInfoType
     */
    public function addToTelephoneInfo(\StructType\TelephoneInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TelephoneInfo) {
            throw new \InvalidArgumentException(sprintf('The TelephoneInfo property can only contain items of type \StructType\TelephoneInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TelephoneInfo[] = $item;
        return $this;
    }
    /**
     * Get Email value
     * @return \StructType\Email[]|null
     */
    public function getEmail()
    {
        return $this->Email;
    }
    /**
     * This method is responsible for validating the values passed to the setEmail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmailForArrayConstraintsFromSetEmail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeEmailItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeEmailItem instanceof \StructType\Email) {
                $invalidValues[] = is_object($companyInfoTypeEmailItem) ? get_class($companyInfoTypeEmailItem) : sprintf('%s(%s)', gettype($companyInfoTypeEmailItem), var_export($companyInfoTypeEmailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email[] $email
     * @return \StructType\CompanyInfoType
     */
    public function setEmail(array $email = array())
    {
        // validation for constraint: array
        if ('' !== ($emailArrayErrorMessage = self::validateEmailForArrayConstraintsFromSetEmail($email))) {
            throw new \InvalidArgumentException($emailArrayErrorMessage, __LINE__);
        }
        $this->Email = $email;
        return $this;
    }
    /**
     * Add item to Email value
     * @throws \InvalidArgumentException
     * @param \StructType\Email $item
     * @return \StructType\CompanyInfoType
     */
    public function addToEmail(\StructType\Email $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Email) {
            throw new \InvalidArgumentException(sprintf('The Email property can only contain items of type \StructType\Email, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Email[] = $item;
        return $this;
    }
    /**
     * Get URL value
     * @return mixed[]|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * This method is responsible for validating the values passed to the setURL method
     * This method is willingly generated in order to preserve the one-line inline validation within the setURL method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateURLForArrayConstraintsFromSetURL(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeURLItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($companyInfoTypeURLItem) ? get_class($companyInfoTypeURLItem) : sprintf('%s(%s)', gettype($companyInfoTypeURLItem), var_export($companyInfoTypeURLItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The URL property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set URL value
     * @throws \InvalidArgumentException
     * @param mixed[] $uRL
     * @return \StructType\CompanyInfoType
     */
    public function setURL(array $uRL = array())
    {
        // validation for constraint: array
        if ('' !== ($uRLArrayErrorMessage = self::validateURLForArrayConstraintsFromSetURL($uRL))) {
            throw new \InvalidArgumentException($uRLArrayErrorMessage, __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
    /**
     * Add item to URL value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CompanyInfoType
     */
    public function addToURL($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The URL property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->URL[] = $item;
        return $this;
    }
    /**
     * Get BusinessLocale value
     * @return mixed[]|null
     */
    public function getBusinessLocale()
    {
        return $this->BusinessLocale;
    }
    /**
     * This method is responsible for validating the values passed to the setBusinessLocale method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBusinessLocale method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBusinessLocaleForArrayConstraintsFromSetBusinessLocale(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeBusinessLocaleItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($companyInfoTypeBusinessLocaleItem) ? get_class($companyInfoTypeBusinessLocaleItem) : sprintf('%s(%s)', gettype($companyInfoTypeBusinessLocaleItem), var_export($companyInfoTypeBusinessLocaleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BusinessLocale property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BusinessLocale value
     * @throws \InvalidArgumentException
     * @param mixed[] $businessLocale
     * @return \StructType\CompanyInfoType
     */
    public function setBusinessLocale(array $businessLocale = array())
    {
        // validation for constraint: array
        if ('' !== ($businessLocaleArrayErrorMessage = self::validateBusinessLocaleForArrayConstraintsFromSetBusinessLocale($businessLocale))) {
            throw new \InvalidArgumentException($businessLocaleArrayErrorMessage, __LINE__);
        }
        $this->BusinessLocale = $businessLocale;
        return $this;
    }
    /**
     * Add item to BusinessLocale value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CompanyInfoType
     */
    public function addToBusinessLocale($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The BusinessLocale property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BusinessLocale[] = $item;
        return $this;
    }
    /**
     * Get PaymentForm value
     * @return \StructType\PaymentForm[]|null
     */
    public function getPaymentForm()
    {
        return $this->PaymentForm;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormForArrayConstraintsFromSetPaymentForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypePaymentFormItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypePaymentFormItem instanceof \StructType\PaymentForm) {
                $invalidValues[] = is_object($companyInfoTypePaymentFormItem) ? get_class($companyInfoTypePaymentFormItem) : sprintf('%s(%s)', gettype($companyInfoTypePaymentFormItem), var_export($companyInfoTypePaymentFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentForm property can only contain items of type \StructType\PaymentForm, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentForm value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentForm[] $paymentForm
     * @return \StructType\CompanyInfoType
     */
    public function setPaymentForm(array $paymentForm = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormArrayErrorMessage = self::validatePaymentFormForArrayConstraintsFromSetPaymentForm($paymentForm))) {
            throw new \InvalidArgumentException($paymentFormArrayErrorMessage, __LINE__);
        }
        $this->PaymentForm = $paymentForm;
        return $this;
    }
    /**
     * Add item to PaymentForm value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentForm $item
     * @return \StructType\CompanyInfoType
     */
    public function addToPaymentForm(\StructType\PaymentForm $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentForm) {
            throw new \InvalidArgumentException(sprintf('The PaymentForm property can only contain items of type \StructType\PaymentForm, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentForm[] = $item;
        return $this;
    }
    /**
     * Get DepositPayment value
     * @return mixed|null
     */
    public function getDepositPayment()
    {
        return $this->DepositPayment;
    }
    /**
     * Set DepositPayment value
     * @param mixed $depositPayment
     * @return \StructType\CompanyInfoType
     */
    public function setDepositPayment($depositPayment = null)
    {
        $this->DepositPayment = $depositPayment;
        return $this;
    }
    /**
     * Get ContactPerson value
     * @return mixed[]|null
     */
    public function getContactPerson()
    {
        return $this->ContactPerson;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPerson method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPerson method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPersonForArrayConstraintsFromSetContactPerson(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeContactPersonItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($companyInfoTypeContactPersonItem) ? get_class($companyInfoTypeContactPersonItem) : sprintf('%s(%s)', gettype($companyInfoTypeContactPersonItem), var_export($companyInfoTypeContactPersonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPerson property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPerson value
     * @throws \InvalidArgumentException
     * @param mixed[] $contactPerson
     * @return \StructType\CompanyInfoType
     */
    public function setContactPerson(array $contactPerson = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPersonArrayErrorMessage = self::validateContactPersonForArrayConstraintsFromSetContactPerson($contactPerson))) {
            throw new \InvalidArgumentException($contactPersonArrayErrorMessage, __LINE__);
        }
        $this->ContactPerson = $contactPerson;
        return $this;
    }
    /**
     * Add item to ContactPerson value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CompanyInfoType
     */
    public function addToContactPerson($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ContactPerson property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactPerson[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return mixed[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($companyInfoTypeTravelArrangerItem) ? get_class($companyInfoTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($companyInfoTypeTravelArrangerItem), var_export($companyInfoTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param mixed[] $travelArranger
     * @return \StructType\CompanyInfoType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CompanyInfoType
     */
    public function addToTravelArranger($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyProgram value
     * @return mixed[]|null
     */
    public function getLoyaltyProgram()
    {
        return $this->LoyaltyProgram;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyProgram method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyProgram method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeLoyaltyProgramItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($companyInfoTypeLoyaltyProgramItem) ? get_class($companyInfoTypeLoyaltyProgramItem) : sprintf('%s(%s)', gettype($companyInfoTypeLoyaltyProgramItem), var_export($companyInfoTypeLoyaltyProgramItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyProgram property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param mixed[] $loyaltyProgram
     * @return \StructType\CompanyInfoType
     */
    public function setLoyaltyProgram(array $loyaltyProgram = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyProgramArrayErrorMessage = self::validateLoyaltyProgramForArrayConstraintsFromSetLoyaltyProgram($loyaltyProgram))) {
            throw new \InvalidArgumentException($loyaltyProgramArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyProgram = $loyaltyProgram;
        return $this;
    }
    /**
     * Add item to LoyaltyProgram value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CompanyInfoType
     */
    public function addToLoyaltyProgram($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyProgram property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyProgram[] = $item;
        return $this;
    }
    /**
     * Get TripPurpose value
     * @return \StructType\TripPurpose[]|null
     */
    public function getTripPurpose()
    {
        return $this->TripPurpose;
    }
    /**
     * This method is responsible for validating the values passed to the setTripPurpose method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTripPurpose method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTripPurposeForArrayConstraintsFromSetTripPurpose(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $companyInfoTypeTripPurposeItem) {
            // validation for constraint: itemType
            if (!$companyInfoTypeTripPurposeItem instanceof \StructType\TripPurpose) {
                $invalidValues[] = is_object($companyInfoTypeTripPurposeItem) ? get_class($companyInfoTypeTripPurposeItem) : sprintf('%s(%s)', gettype($companyInfoTypeTripPurposeItem), var_export($companyInfoTypeTripPurposeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TripPurpose property can only contain items of type \StructType\TripPurpose, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TripPurpose value
     * @throws \InvalidArgumentException
     * @param \StructType\TripPurpose[] $tripPurpose
     * @return \StructType\CompanyInfoType
     */
    public function setTripPurpose(array $tripPurpose = array())
    {
        // validation for constraint: array
        if ('' !== ($tripPurposeArrayErrorMessage = self::validateTripPurposeForArrayConstraintsFromSetTripPurpose($tripPurpose))) {
            throw new \InvalidArgumentException($tripPurposeArrayErrorMessage, __LINE__);
        }
        $this->TripPurpose = $tripPurpose;
        return $this;
    }
    /**
     * Add item to TripPurpose value
     * @throws \InvalidArgumentException
     * @param \StructType\TripPurpose $item
     * @return \StructType\CompanyInfoType
     */
    public function addToTripPurpose(\StructType\TripPurpose $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TripPurpose) {
            throw new \InvalidArgumentException(sprintf('The TripPurpose property can only contain items of type \StructType\TripPurpose, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TripPurpose[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CompanyInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
