<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CommonPrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to specify the preferred alternate language. | Used to specify the preferred language. | Used to indicate if smoking is preferred. | Allows for control of the sharing of common preferences between parties. | Identifies
 * preferences for common travel needs not associated with a specific travel service.
 * @subpackage Structs
 */
class CommonPrefType extends AbstractStructBase
{
    /**
     * The NamePref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for name information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $NamePref;
    /**
     * The PhonePref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for telephone information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PhonePref;
    /**
     * The AddressPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for address information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AddressPref;
    /**
     * The PaymentFormPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for form of payment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PaymentFormPref;
    /**
     * The InterestPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a traveler's interests.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $InterestPref;
    /**
     * The InsurancePref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for insurance.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $InsurancePref;
    /**
     * The SeatingPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for seating.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SeatingPref;
    /**
     * The TicketDistribPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a method of ticket distribution.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TicketDistribPref;
    /**
     * The MediaEntertainPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for media and entertainment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for pet information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PetInfoPref;
    /**
     * The MealPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for food and beverage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MealPref;
    /**
     * The LoyaltyPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a loyalty program.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LoyaltyPref;
    /**
     * The SpecRequestPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a special request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SpecRequestPref;
    /**
     * The RelatedTravelerPref
     * Meta information extracted from the WSDL
     * - documentation: Enables a preference to be indicated for a related traveler.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $RelatedTravelerPref;
    /**
     * The ContactPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\ContactPref[]
     */
    public $ContactPref;
    /**
     * The EmployeeLevelInfo
     * Meta information extracted from the WSDL
     * - documentation: Defines the category of the traveler and the purpose of the trip for which these preferences apply. Typically used for company profiles.
     * - minOccurs: 0
     * @var mixed
     */
    public $EmployeeLevelInfo;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for CommonPrefType
     * @uses CommonPrefType::setNamePref()
     * @uses CommonPrefType::setPhonePref()
     * @uses CommonPrefType::setAddressPref()
     * @uses CommonPrefType::setPaymentFormPref()
     * @uses CommonPrefType::setInterestPref()
     * @uses CommonPrefType::setInsurancePref()
     * @uses CommonPrefType::setSeatingPref()
     * @uses CommonPrefType::setTicketDistribPref()
     * @uses CommonPrefType::setMediaEntertainPref()
     * @uses CommonPrefType::setPetInfoPref()
     * @uses CommonPrefType::setMealPref()
     * @uses CommonPrefType::setLoyaltyPref()
     * @uses CommonPrefType::setSpecRequestPref()
     * @uses CommonPrefType::setRelatedTravelerPref()
     * @uses CommonPrefType::setContactPref()
     * @uses CommonPrefType::setEmployeeLevelInfo()
     * @uses CommonPrefType::setTPA_Extensions()
     * @param mixed[] $namePref
     * @param mixed[] $phonePref
     * @param mixed[] $addressPref
     * @param mixed[] $paymentFormPref
     * @param mixed[] $interestPref
     * @param mixed[] $insurancePref
     * @param mixed[] $seatingPref
     * @param mixed[] $ticketDistribPref
     * @param mixed[] $mediaEntertainPref
     * @param mixed[] $petInfoPref
     * @param mixed[] $mealPref
     * @param mixed[] $loyaltyPref
     * @param mixed[] $specRequestPref
     * @param mixed[] $relatedTravelerPref
     * @param \StructType\ContactPref[] $contactPref
     * @param mixed $employeeLevelInfo
     * @param mixed $tPA_Extensions
     */
    public function __construct(array $namePref = array(), array $phonePref = array(), array $addressPref = array(), array $paymentFormPref = array(), array $interestPref = array(), array $insurancePref = array(), array $seatingPref = array(), array $ticketDistribPref = array(), array $mediaEntertainPref = array(), array $petInfoPref = array(), array $mealPref = array(), array $loyaltyPref = array(), array $specRequestPref = array(), array $relatedTravelerPref = array(), array $contactPref = array(), $employeeLevelInfo = null, $tPA_Extensions = null)
    {
        $this
            ->setNamePref($namePref)
            ->setPhonePref($phonePref)
            ->setAddressPref($addressPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setInterestPref($interestPref)
            ->setInsurancePref($insurancePref)
            ->setSeatingPref($seatingPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setMealPref($mealPref)
            ->setLoyaltyPref($loyaltyPref)
            ->setSpecRequestPref($specRequestPref)
            ->setRelatedTravelerPref($relatedTravelerPref)
            ->setContactPref($contactPref)
            ->setEmployeeLevelInfo($employeeLevelInfo)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get NamePref value
     * @return mixed[]|null
     */
    public function getNamePref()
    {
        return $this->NamePref;
    }
    /**
     * This method is responsible for validating the values passed to the setNamePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setNamePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateNamePrefForArrayConstraintsFromSetNamePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeNamePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeNamePrefItem) ? get_class($commonPrefTypeNamePrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeNamePrefItem), var_export($commonPrefTypeNamePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The NamePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set NamePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $namePref
     * @return \StructType\CommonPrefType
     */
    public function setNamePref(array $namePref = array())
    {
        // validation for constraint: array
        if ('' !== ($namePrefArrayErrorMessage = self::validateNamePrefForArrayConstraintsFromSetNamePref($namePref))) {
            throw new \InvalidArgumentException($namePrefArrayErrorMessage, __LINE__);
        }
        $this->NamePref = $namePref;
        return $this;
    }
    /**
     * Add item to NamePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToNamePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The NamePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->NamePref[] = $item;
        return $this;
    }
    /**
     * Get PhonePref value
     * @return mixed[]|null
     */
    public function getPhonePref()
    {
        return $this->PhonePref;
    }
    /**
     * This method is responsible for validating the values passed to the setPhonePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPhonePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePhonePrefForArrayConstraintsFromSetPhonePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypePhonePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypePhonePrefItem) ? get_class($commonPrefTypePhonePrefItem) : sprintf('%s(%s)', gettype($commonPrefTypePhonePrefItem), var_export($commonPrefTypePhonePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PhonePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PhonePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $phonePref
     * @return \StructType\CommonPrefType
     */
    public function setPhonePref(array $phonePref = array())
    {
        // validation for constraint: array
        if ('' !== ($phonePrefArrayErrorMessage = self::validatePhonePrefForArrayConstraintsFromSetPhonePref($phonePref))) {
            throw new \InvalidArgumentException($phonePrefArrayErrorMessage, __LINE__);
        }
        $this->PhonePref = $phonePref;
        return $this;
    }
    /**
     * Add item to PhonePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToPhonePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PhonePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PhonePref[] = $item;
        return $this;
    }
    /**
     * Get AddressPref value
     * @return mixed[]|null
     */
    public function getAddressPref()
    {
        return $this->AddressPref;
    }
    /**
     * This method is responsible for validating the values passed to the setAddressPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddressPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddressPrefForArrayConstraintsFromSetAddressPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeAddressPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeAddressPrefItem) ? get_class($commonPrefTypeAddressPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeAddressPrefItem), var_export($commonPrefTypeAddressPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddressPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddressPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $addressPref
     * @return \StructType\CommonPrefType
     */
    public function setAddressPref(array $addressPref = array())
    {
        // validation for constraint: array
        if ('' !== ($addressPrefArrayErrorMessage = self::validateAddressPrefForArrayConstraintsFromSetAddressPref($addressPref))) {
            throw new \InvalidArgumentException($addressPrefArrayErrorMessage, __LINE__);
        }
        $this->AddressPref = $addressPref;
        return $this;
    }
    /**
     * Add item to AddressPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToAddressPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AddressPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddressPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return mixed[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypePaymentFormPrefItem) ? get_class($commonPrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypePaymentFormPrefItem), var_export($commonPrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentFormPref
     * @return \StructType\CommonPrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToPaymentFormPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get InterestPref value
     * @return mixed[]|null
     */
    public function getInterestPref()
    {
        return $this->InterestPref;
    }
    /**
     * This method is responsible for validating the values passed to the setInterestPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInterestPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInterestPrefForArrayConstraintsFromSetInterestPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeInterestPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeInterestPrefItem) ? get_class($commonPrefTypeInterestPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeInterestPrefItem), var_export($commonPrefTypeInterestPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InterestPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InterestPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $interestPref
     * @return \StructType\CommonPrefType
     */
    public function setInterestPref(array $interestPref = array())
    {
        // validation for constraint: array
        if ('' !== ($interestPrefArrayErrorMessage = self::validateInterestPrefForArrayConstraintsFromSetInterestPref($interestPref))) {
            throw new \InvalidArgumentException($interestPrefArrayErrorMessage, __LINE__);
        }
        $this->InterestPref = $interestPref;
        return $this;
    }
    /**
     * Add item to InterestPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToInterestPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The InterestPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InterestPref[] = $item;
        return $this;
    }
    /**
     * Get InsurancePref value
     * @return mixed[]|null
     */
    public function getInsurancePref()
    {
        return $this->InsurancePref;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurancePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurancePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsurancePrefForArrayConstraintsFromSetInsurancePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeInsurancePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeInsurancePrefItem) ? get_class($commonPrefTypeInsurancePrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeInsurancePrefItem), var_export($commonPrefTypeInsurancePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The InsurancePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set InsurancePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $insurancePref
     * @return \StructType\CommonPrefType
     */
    public function setInsurancePref(array $insurancePref = array())
    {
        // validation for constraint: array
        if ('' !== ($insurancePrefArrayErrorMessage = self::validateInsurancePrefForArrayConstraintsFromSetInsurancePref($insurancePref))) {
            throw new \InvalidArgumentException($insurancePrefArrayErrorMessage, __LINE__);
        }
        $this->InsurancePref = $insurancePref;
        return $this;
    }
    /**
     * Add item to InsurancePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToInsurancePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The InsurancePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->InsurancePref[] = $item;
        return $this;
    }
    /**
     * Get SeatingPref value
     * @return mixed[]|null
     */
    public function getSeatingPref()
    {
        return $this->SeatingPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatingPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatingPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatingPrefForArrayConstraintsFromSetSeatingPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeSeatingPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeSeatingPrefItem) ? get_class($commonPrefTypeSeatingPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeSeatingPrefItem), var_export($commonPrefTypeSeatingPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatingPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatingPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $seatingPref
     * @return \StructType\CommonPrefType
     */
    public function setSeatingPref(array $seatingPref = array())
    {
        // validation for constraint: array
        if ('' !== ($seatingPrefArrayErrorMessage = self::validateSeatingPrefForArrayConstraintsFromSetSeatingPref($seatingPref))) {
            throw new \InvalidArgumentException($seatingPrefArrayErrorMessage, __LINE__);
        }
        $this->SeatingPref = $seatingPref;
        return $this;
    }
    /**
     * Add item to SeatingPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToSeatingPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SeatingPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatingPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return mixed[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDistribPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDistribPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeTicketDistribPrefItem) ? get_class($commonPrefTypeTicketDistribPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeTicketDistribPrefItem), var_export($commonPrefTypeTicketDistribPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDistribPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $ticketDistribPref
     * @return \StructType\CommonPrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDistribPrefArrayErrorMessage = self::validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref($ticketDistribPref))) {
            throw new \InvalidArgumentException($ticketDistribPrefArrayErrorMessage, __LINE__);
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToTicketDistribPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return mixed[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaEntertainPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaEntertainPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeMediaEntertainPrefItem) ? get_class($commonPrefTypeMediaEntertainPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeMediaEntertainPrefItem), var_export($commonPrefTypeMediaEntertainPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MediaEntertainPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $mediaEntertainPref
     * @return \StructType\CommonPrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaEntertainPrefArrayErrorMessage = self::validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref($mediaEntertainPref))) {
            throw new \InvalidArgumentException($mediaEntertainPrefArrayErrorMessage, __LINE__);
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToMediaEntertainPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return mixed[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPetInfoPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetInfoPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypePetInfoPrefItem) ? get_class($commonPrefTypePetInfoPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypePetInfoPrefItem), var_export($commonPrefTypePetInfoPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetInfoPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $petInfoPref
     * @return \StructType\CommonPrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        // validation for constraint: array
        if ('' !== ($petInfoPrefArrayErrorMessage = self::validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref($petInfoPref))) {
            throw new \InvalidArgumentException($petInfoPrefArrayErrorMessage, __LINE__);
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToPetInfoPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return mixed[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMealPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMealPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealPrefForArrayConstraintsFromSetMealPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeMealPrefItem) ? get_class($commonPrefTypeMealPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeMealPrefItem), var_export($commonPrefTypeMealPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MealPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $mealPref
     * @return \StructType\CommonPrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mealPrefArrayErrorMessage = self::validateMealPrefForArrayConstraintsFromSetMealPref($mealPref))) {
            throw new \InvalidArgumentException($mealPrefArrayErrorMessage, __LINE__);
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToMealPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyPref value
     * @return mixed[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeLoyaltyPrefItem) ? get_class($commonPrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeLoyaltyPrefItem), var_export($commonPrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $loyaltyPref
     * @return \StructType\CommonPrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToLoyaltyPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return mixed[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecRequestPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecRequestPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeSpecRequestPrefItem) ? get_class($commonPrefTypeSpecRequestPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeSpecRequestPrefItem), var_export($commonPrefTypeSpecRequestPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecRequestPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $specRequestPref
     * @return \StructType\CommonPrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specRequestPrefArrayErrorMessage = self::validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref($specRequestPref))) {
            throw new \InvalidArgumentException($specRequestPrefArrayErrorMessage, __LINE__);
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToSpecRequestPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get RelatedTravelerPref value
     * @return mixed[]|null
     */
    public function getRelatedTravelerPref()
    {
        return $this->RelatedTravelerPref;
    }
    /**
     * This method is responsible for validating the values passed to the setRelatedTravelerPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRelatedTravelerPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRelatedTravelerPrefForArrayConstraintsFromSetRelatedTravelerPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeRelatedTravelerPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commonPrefTypeRelatedTravelerPrefItem) ? get_class($commonPrefTypeRelatedTravelerPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeRelatedTravelerPrefItem), var_export($commonPrefTypeRelatedTravelerPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RelatedTravelerPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RelatedTravelerPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $relatedTravelerPref
     * @return \StructType\CommonPrefType
     */
    public function setRelatedTravelerPref(array $relatedTravelerPref = array())
    {
        // validation for constraint: array
        if ('' !== ($relatedTravelerPrefArrayErrorMessage = self::validateRelatedTravelerPrefForArrayConstraintsFromSetRelatedTravelerPref($relatedTravelerPref))) {
            throw new \InvalidArgumentException($relatedTravelerPrefArrayErrorMessage, __LINE__);
        }
        $this->RelatedTravelerPref = $relatedTravelerPref;
        return $this;
    }
    /**
     * Add item to RelatedTravelerPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CommonPrefType
     */
    public function addToRelatedTravelerPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The RelatedTravelerPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RelatedTravelerPref[] = $item;
        return $this;
    }
    /**
     * Get ContactPref value
     * @return \StructType\ContactPref[]|null
     */
    public function getContactPref()
    {
        return $this->ContactPref;
    }
    /**
     * This method is responsible for validating the values passed to the setContactPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactPrefForArrayConstraintsFromSetContactPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commonPrefTypeContactPrefItem) {
            // validation for constraint: itemType
            if (!$commonPrefTypeContactPrefItem instanceof \StructType\ContactPref) {
                $invalidValues[] = is_object($commonPrefTypeContactPrefItem) ? get_class($commonPrefTypeContactPrefItem) : sprintf('%s(%s)', gettype($commonPrefTypeContactPrefItem), var_export($commonPrefTypeContactPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactPref property can only contain items of type \StructType\ContactPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactPref value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPref[] $contactPref
     * @return \StructType\CommonPrefType
     */
    public function setContactPref(array $contactPref = array())
    {
        // validation for constraint: array
        if ('' !== ($contactPrefArrayErrorMessage = self::validateContactPrefForArrayConstraintsFromSetContactPref($contactPref))) {
            throw new \InvalidArgumentException($contactPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($contactPref) && count($contactPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($contactPref)), __LINE__);
        }
        $this->ContactPref = $contactPref;
        return $this;
    }
    /**
     * Add item to ContactPref value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactPref $item
     * @return \StructType\CommonPrefType
     */
    public function addToContactPref(\StructType\ContactPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactPref) {
            throw new \InvalidArgumentException(sprintf('The ContactPref property can only contain items of type \StructType\ContactPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ContactPref) && count($this->ContactPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ContactPref)), __LINE__);
        }
        $this->ContactPref[] = $item;
        return $this;
    }
    /**
     * Get EmployeeLevelInfo value
     * @return mixed|null
     */
    public function getEmployeeLevelInfo()
    {
        return $this->EmployeeLevelInfo;
    }
    /**
     * Set EmployeeLevelInfo value
     * @param mixed $employeeLevelInfo
     * @return \StructType\CommonPrefType
     */
    public function setEmployeeLevelInfo($employeeLevelInfo = null)
    {
        $this->EmployeeLevelInfo = $employeeLevelInfo;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\CommonPrefType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CommonPrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
