<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Comments StructType
 * Meta information extracted from the WSDL
 * - documentation: Comments related to the profile. | A collection of comments. | Collection of comments used for additional data about the response.
 * @subpackage Structs
 */
class Comments extends AbstractStructBase
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - documentation: Comment information pertaining to the purchase. This may be used to pass a message to be printed on a note card. | Open comments to send additional data about the response.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $Comment;
    /**
     * Constructor method for Comments
     * @uses Comments::setComment()
     * @param mixed[] $comment
     */
    public function __construct(array $comment = array())
    {
        $this
            ->setComment($comment);
    }
    /**
     * Get Comment value
     * @return mixed[]|null
     */
    public function getComment()
    {
        return $this->Comment;
    }
    /**
     * This method is responsible for validating the values passed to the setComment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setComment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommentForArrayConstraintsFromSetComment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $commentsCommentItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($commentsCommentItem) ? get_class($commentsCommentItem) : sprintf('%s(%s)', gettype($commentsCommentItem), var_export($commentsCommentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Comment property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Comment value
     * @throws \InvalidArgumentException
     * @param mixed[] $comment
     * @return \StructType\Comments
     */
    public function setComment(array $comment = array())
    {
        // validation for constraint: array
        if ('' !== ($commentArrayErrorMessage = self::validateCommentForArrayConstraintsFromSetComment($comment))) {
            throw new \InvalidArgumentException($commentArrayErrorMessage, __LINE__);
        }
        $this->Comment = $comment;
        return $this;
    }
    /**
     * Add item to Comment value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\Comments
     */
    public function addToComment($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Comment property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Comment[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Comments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
