<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeListScheduleType StructType
 * Meta information extracted from the WSDL
 * - documentation: Operating or availability schedule associated with a code item.
 * @subpackage Structs
 */
class CodeListScheduleType extends AbstractStructBase
{
    /**
     * The OperationTimes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\OperationTimes
     */
    public $OperationTimes;
    /**
     * The Start
     * Meta information extracted from the WSDL
     * - documentation: Schedule start period.
     * - use: optional
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - documentation: Example: P2D | Period duration.
     * - use: optional
     * @var string
     */
    public $Duration;
    /**
     * The End
     * Meta information extracted from the WSDL
     * - documentation: Schedule end period.
     * - use: optional
     * @var string
     */
    public $End;
    /**
     * The FeeRefRPH
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $FeeRefRPH;
    /**
     * The ScheduleRPH
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $ScheduleRPH;
    /**
     * Constructor method for CodeListScheduleType
     * @uses CodeListScheduleType::setOperationTimes()
     * @uses CodeListScheduleType::setStart()
     * @uses CodeListScheduleType::setDuration()
     * @uses CodeListScheduleType::setEnd()
     * @uses CodeListScheduleType::setFeeRefRPH()
     * @uses CodeListScheduleType::setScheduleRPH()
     * @param \StructType\OperationTimes $operationTimes
     * @param string $start
     * @param string $duration
     * @param string $end
     * @param string $feeRefRPH
     * @param string $scheduleRPH
     */
    public function __construct(\StructType\OperationTimes $operationTimes = null, $start = null, $duration = null, $end = null, $feeRefRPH = null, $scheduleRPH = null)
    {
        $this
            ->setOperationTimes($operationTimes)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end)
            ->setFeeRefRPH($feeRefRPH)
            ->setScheduleRPH($scheduleRPH);
    }
    /**
     * Get OperationTimes value
     * @return \StructType\OperationTimes|null
     */
    public function getOperationTimes()
    {
        return $this->OperationTimes;
    }
    /**
     * Set OperationTimes value
     * @param \StructType\OperationTimes $operationTimes
     * @return \StructType\CodeListScheduleType
     */
    public function setOperationTimes(\StructType\OperationTimes $operationTimes = null)
    {
        $this->OperationTimes = $operationTimes;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\CodeListScheduleType
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\CodeListScheduleType
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\CodeListScheduleType
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get FeeRefRPH value
     * @return string|null
     */
    public function getFeeRefRPH()
    {
        return $this->FeeRefRPH;
    }
    /**
     * Set FeeRefRPH value
     * @param string $feeRefRPH
     * @return \StructType\CodeListScheduleType
     */
    public function setFeeRefRPH($feeRefRPH = null)
    {
        // validation for constraint: string
        if (!is_null($feeRefRPH) && !is_string($feeRefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($feeRefRPH, true), gettype($feeRefRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($feeRefRPH) && !preg_match('/[0-9]{1,8}/', $feeRefRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($feeRefRPH, true)), __LINE__);
        }
        $this->FeeRefRPH = $feeRefRPH;
        return $this;
    }
    /**
     * Get ScheduleRPH value
     * @return string|null
     */
    public function getScheduleRPH()
    {
        return $this->ScheduleRPH;
    }
    /**
     * Set ScheduleRPH value
     * @param string $scheduleRPH
     * @return \StructType\CodeListScheduleType
     */
    public function setScheduleRPH($scheduleRPH = null)
    {
        // validation for constraint: string
        if (!is_null($scheduleRPH) && !is_string($scheduleRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scheduleRPH, true), gettype($scheduleRPH)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($scheduleRPH) && !preg_match('/[0-9]{1,8}/', $scheduleRPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($scheduleRPH, true)), __LINE__);
        }
        $this->ScheduleRPH = $scheduleRPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CodeListScheduleType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
