<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeListExtension StructType
 * Meta information extracted from the WSDL
 * - documentation: Choice between summary and detailed code extension information.
 * @subpackage Structs
 */
class CodeListExtension extends AbstractStructBase
{
    /**
     * The Summary
     * Meta information extracted from the WSDL
     * - documentation: Summary code information.
     * - choice: Summary | Detail
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $Summary;
    /**
     * The Detail
     * Meta information extracted from the WSDL
     * - documentation: Detail code information.
     * - choice: Summary | Detail
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - minOccurs: 0
     * @var mixed
     */
    public $Detail;
    /**
     * The ChargeInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, charge information has been specified and the Detail/Charge element should be parsed. | Example: true | Charge information specified indicator.
     * - use: optional
     * @var bool
     */
    public $ChargeInd;
    /**
     * The ProximityInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, proximity information has been specified and the @Proximity attribute should be parsed. | Example: true | Proximity information specified indicator.
     * - use: optional
     * @var bool
     */
    public $ProximityInd;
    /**
     * The QuantityInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, quantity information has been specified and the @Quantity attribute should be parsed. | Example: true | Quantity information specified indicator.
     * - use: optional
     * @var bool
     */
    public $QuantityInd;
    /**
     * The ScheduleInd
     * Meta information extracted from the WSDL
     * - documentation: Implementer: If true, schedule information has been specified and the Detail/Schedule element should be parsed. | Example: true | Schedule information specified indicator.
     * - use: optional
     * @var bool
     */
    public $ScheduleInd;
    /**
     * Constructor method for CodeListExtension
     * @uses CodeListExtension::setSummary()
     * @uses CodeListExtension::setDetail()
     * @uses CodeListExtension::setChargeInd()
     * @uses CodeListExtension::setProximityInd()
     * @uses CodeListExtension::setQuantityInd()
     * @uses CodeListExtension::setScheduleInd()
     * @param mixed $summary
     * @param mixed $detail
     * @param bool $chargeInd
     * @param bool $proximityInd
     * @param bool $quantityInd
     * @param bool $scheduleInd
     */
    public function __construct($summary = null, $detail = null, $chargeInd = null, $proximityInd = null, $quantityInd = null, $scheduleInd = null)
    {
        $this
            ->setSummary($summary)
            ->setDetail($detail)
            ->setChargeInd($chargeInd)
            ->setProximityInd($proximityInd)
            ->setQuantityInd($quantityInd)
            ->setScheduleInd($scheduleInd);
    }
    /**
     * Get Summary value
     * @return mixed|null
     */
    public function getSummary()
    {
        return isset($this->Summary) ? $this->Summary : null;
    }
    /**
     * This method is responsible for validating the value passed to the setSummary method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSummary method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateSummaryForChoiceConstraintsFromSetSummary($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Detail',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Summary can\'t be set as the property %s is already set. Only one property must be set among these properties: Summary, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Summary value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $summary
     * @return \StructType\CodeListExtension
     */
    public function setSummary($summary = null)
    {
        // validation for constraint: choice(Summary, Detail)
        if ('' !== ($summaryChoiceErrorMessage = self::validateSummaryForChoiceConstraintsFromSetSummary($summary))) {
            throw new \InvalidArgumentException($summaryChoiceErrorMessage, __LINE__);
        }
        if (is_null($summary) || (is_array($summary) && empty($summary))) {
            unset($this->Summary);
        } else {
            $this->Summary = $summary;
        }
        return $this;
    }
    /**
     * Get Detail value
     * @return mixed|null
     */
    public function getDetail()
    {
        return isset($this->Detail) ? $this->Detail : null;
    }
    /**
     * This method is responsible for validating the value passed to the setDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDetail method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateDetailForChoiceConstraintsFromSetDetail($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'Summary',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property Detail can\'t be set as the property %s is already set. Only one property must be set among these properties: Detail, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set Detail value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param mixed $detail
     * @return \StructType\CodeListExtension
     */
    public function setDetail($detail = null)
    {
        // validation for constraint: choice(Summary, Detail)
        if ('' !== ($detailChoiceErrorMessage = self::validateDetailForChoiceConstraintsFromSetDetail($detail))) {
            throw new \InvalidArgumentException($detailChoiceErrorMessage, __LINE__);
        }
        if (is_null($detail) || (is_array($detail) && empty($detail))) {
            unset($this->Detail);
        } else {
            $this->Detail = $detail;
        }
        return $this;
    }
    /**
     * Get ChargeInd value
     * @return bool|null
     */
    public function getChargeInd()
    {
        return $this->ChargeInd;
    }
    /**
     * Set ChargeInd value
     * @param bool $chargeInd
     * @return \StructType\CodeListExtension
     */
    public function setChargeInd($chargeInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargeInd) && !is_bool($chargeInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chargeInd, true), gettype($chargeInd)), __LINE__);
        }
        $this->ChargeInd = $chargeInd;
        return $this;
    }
    /**
     * Get ProximityInd value
     * @return bool|null
     */
    public function getProximityInd()
    {
        return $this->ProximityInd;
    }
    /**
     * Set ProximityInd value
     * @param bool $proximityInd
     * @return \StructType\CodeListExtension
     */
    public function setProximityInd($proximityInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($proximityInd) && !is_bool($proximityInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($proximityInd, true), gettype($proximityInd)), __LINE__);
        }
        $this->ProximityInd = $proximityInd;
        return $this;
    }
    /**
     * Get QuantityInd value
     * @return bool|null
     */
    public function getQuantityInd()
    {
        return $this->QuantityInd;
    }
    /**
     * Set QuantityInd value
     * @param bool $quantityInd
     * @return \StructType\CodeListExtension
     */
    public function setQuantityInd($quantityInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($quantityInd) && !is_bool($quantityInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($quantityInd, true), gettype($quantityInd)), __LINE__);
        }
        $this->QuantityInd = $quantityInd;
        return $this;
    }
    /**
     * Get ScheduleInd value
     * @return bool|null
     */
    public function getScheduleInd()
    {
        return $this->ScheduleInd;
    }
    /**
     * Set ScheduleInd value
     * @param bool $scheduleInd
     * @return \StructType\CodeListExtension
     */
    public function setScheduleInd($scheduleInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($scheduleInd) && !is_bool($scheduleInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($scheduleInd, true), gettype($scheduleInd)), __LINE__);
        }
        $this->ScheduleInd = $scheduleInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CodeListExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
