<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CodeListDetailExtension StructType
 * Meta information extracted from the WSDL
 * - documentation: Detail Code List extension structure that includes all Summary information plus quantity, proximity, charge, schedule and apply to level information.
 * @subpackage Structs
 */
class CodeListDetailExtension extends CodeListSummaryExtension
{
    /**
     * The ApplyToLevel
     * Meta information extracted from the WSDL
     * - documentation: Example: Property | Applicable item level.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $ApplyToLevel;
    /**
     * The Charge
     * Meta information extracted from the WSDL
     * - documentation: Associated charge information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Charge;
    /**
     * The Schedule
     * Meta information extracted from the WSDL
     * - documentation: Associated service schedule information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Schedule;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Example: 2 | Associated quantity for the item.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * The Proximity
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Proximity;
    /**
     * Constructor method for CodeListDetailExtension
     * @uses CodeListDetailExtension::setApplyToLevel()
     * @uses CodeListDetailExtension::setCharge()
     * @uses CodeListDetailExtension::setSchedule()
     * @uses CodeListDetailExtension::setQuantity()
     * @uses CodeListDetailExtension::setProximity()
     * @param mixed[] $applyToLevel
     * @param mixed[] $charge
     * @param mixed[] $schedule
     * @param int $quantity
     * @param string $proximity
     */
    public function __construct(array $applyToLevel = array(), array $charge = array(), array $schedule = array(), $quantity = null, $proximity = null)
    {
        $this
            ->setApplyToLevel($applyToLevel)
            ->setCharge($charge)
            ->setSchedule($schedule)
            ->setQuantity($quantity)
            ->setProximity($proximity);
    }
    /**
     * Get ApplyToLevel value
     * @return mixed[]|null
     */
    public function getApplyToLevel()
    {
        return $this->ApplyToLevel;
    }
    /**
     * This method is responsible for validating the values passed to the setApplyToLevel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setApplyToLevel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateApplyToLevelForArrayConstraintsFromSetApplyToLevel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $codeListDetailExtensionApplyToLevelItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($codeListDetailExtensionApplyToLevelItem) ? get_class($codeListDetailExtensionApplyToLevelItem) : sprintf('%s(%s)', gettype($codeListDetailExtensionApplyToLevelItem), var_export($codeListDetailExtensionApplyToLevelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ApplyToLevel property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ApplyToLevel value
     * @throws \InvalidArgumentException
     * @param mixed[] $applyToLevel
     * @return \StructType\CodeListDetailExtension
     */
    public function setApplyToLevel(array $applyToLevel = array())
    {
        // validation for constraint: array
        if ('' !== ($applyToLevelArrayErrorMessage = self::validateApplyToLevelForArrayConstraintsFromSetApplyToLevel($applyToLevel))) {
            throw new \InvalidArgumentException($applyToLevelArrayErrorMessage, __LINE__);
        }
        $this->ApplyToLevel = $applyToLevel;
        return $this;
    }
    /**
     * Add item to ApplyToLevel value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CodeListDetailExtension
     */
    public function addToApplyToLevel($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ApplyToLevel property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ApplyToLevel[] = $item;
        return $this;
    }
    /**
     * Get Charge value
     * @return mixed[]|null
     */
    public function getCharge()
    {
        return $this->Charge;
    }
    /**
     * This method is responsible for validating the values passed to the setCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChargeForArrayConstraintsFromSetCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $codeListDetailExtensionChargeItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($codeListDetailExtensionChargeItem) ? get_class($codeListDetailExtensionChargeItem) : sprintf('%s(%s)', gettype($codeListDetailExtensionChargeItem), var_export($codeListDetailExtensionChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Charge property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Charge value
     * @throws \InvalidArgumentException
     * @param mixed[] $charge
     * @return \StructType\CodeListDetailExtension
     */
    public function setCharge(array $charge = array())
    {
        // validation for constraint: array
        if ('' !== ($chargeArrayErrorMessage = self::validateChargeForArrayConstraintsFromSetCharge($charge))) {
            throw new \InvalidArgumentException($chargeArrayErrorMessage, __LINE__);
        }
        $this->Charge = $charge;
        return $this;
    }
    /**
     * Add item to Charge value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CodeListDetailExtension
     */
    public function addToCharge($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Charge property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Charge[] = $item;
        return $this;
    }
    /**
     * Get Schedule value
     * @return mixed[]|null
     */
    public function getSchedule()
    {
        return $this->Schedule;
    }
    /**
     * This method is responsible for validating the values passed to the setSchedule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSchedule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateScheduleForArrayConstraintsFromSetSchedule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $codeListDetailExtensionScheduleItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($codeListDetailExtensionScheduleItem) ? get_class($codeListDetailExtensionScheduleItem) : sprintf('%s(%s)', gettype($codeListDetailExtensionScheduleItem), var_export($codeListDetailExtensionScheduleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Schedule property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Schedule value
     * @throws \InvalidArgumentException
     * @param mixed[] $schedule
     * @return \StructType\CodeListDetailExtension
     */
    public function setSchedule(array $schedule = array())
    {
        // validation for constraint: array
        if ('' !== ($scheduleArrayErrorMessage = self::validateScheduleForArrayConstraintsFromSetSchedule($schedule))) {
            throw new \InvalidArgumentException($scheduleArrayErrorMessage, __LINE__);
        }
        $this->Schedule = $schedule;
        return $this;
    }
    /**
     * Add item to Schedule value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CodeListDetailExtension
     */
    public function addToSchedule($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Schedule property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Schedule[] = $item;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\CodeListDetailExtension
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Proximity value
     * @return string|null
     */
    public function getProximity()
    {
        return $this->Proximity;
    }
    /**
     * Set Proximity value
     * @param string $proximity
     * @return \StructType\CodeListDetailExtension
     */
    public function setProximity($proximity = null)
    {
        // validation for constraint: string
        if (!is_null($proximity) && !is_string($proximity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($proximity, true), gettype($proximity)), __LINE__);
        }
        $this->Proximity = $proximity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CodeListDetailExtension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
