<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Code StructType
 * Meta information extracted from the WSDL
 * - documentation: A code that points to a valid baggage type and is known to the trading partner system. Note that these item types should map to ancillary item codes. | Example: IBM | Rate code. | Example: ORD | Code. | Refer to OpenTravel Code List
 * Age Qualifying Code (AQC), Rail Passenger Type Code (PXC), or use StringLength1to8 with CodeContext to use a non-OpenTravel Code.
 * - type: OTA_CodeType
 * - union: StringLength1to8 | OTA_CodeType
 * - use: optional
 * @subpackage Structs
 */
class Code extends AbstractStructBase
{
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * Constructor method for Code
     * @uses Code::setOntologyExtension()
     * @param mixed $ontologyExtension
     */
    public function __construct($ontologyExtension = null)
    {
        $this
            ->setOntologyExtension($ontologyExtension);
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\Code
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Code
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
