<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ClosedSeasons StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of date and time periods when the hotel facility is closed.
 * @subpackage Structs
 */
class ClosedSeasons extends AbstractStructBase
{
    /**
     * The ClosedSeason
     * Meta information extracted from the WSDL
     * - documentation: A date and time period when a hotel facility is closed.
     * - maxOccurs: unbounded
     * @var mixed[]
     */
    public $ClosedSeason;
    /**
     * Constructor method for ClosedSeasons
     * @uses ClosedSeasons::setClosedSeason()
     * @param mixed[] $closedSeason
     */
    public function __construct(array $closedSeason = array())
    {
        $this
            ->setClosedSeason($closedSeason);
    }
    /**
     * Get ClosedSeason value
     * @return mixed[]|null
     */
    public function getClosedSeason()
    {
        return $this->ClosedSeason;
    }
    /**
     * This method is responsible for validating the values passed to the setClosedSeason method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClosedSeason method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClosedSeasonForArrayConstraintsFromSetClosedSeason(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $closedSeasonsClosedSeasonItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($closedSeasonsClosedSeasonItem) ? get_class($closedSeasonsClosedSeasonItem) : sprintf('%s(%s)', gettype($closedSeasonsClosedSeasonItem), var_export($closedSeasonsClosedSeasonItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ClosedSeason property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClosedSeason value
     * @throws \InvalidArgumentException
     * @param mixed[] $closedSeason
     * @return \StructType\ClosedSeasons
     */
    public function setClosedSeason(array $closedSeason = array())
    {
        // validation for constraint: array
        if ('' !== ($closedSeasonArrayErrorMessage = self::validateClosedSeasonForArrayConstraintsFromSetClosedSeason($closedSeason))) {
            throw new \InvalidArgumentException($closedSeasonArrayErrorMessage, __LINE__);
        }
        $this->ClosedSeason = $closedSeason;
        return $this;
    }
    /**
     * Add item to ClosedSeason value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\ClosedSeasons
     */
    public function addToClosedSeason($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The ClosedSeason property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ClosedSeason[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ClosedSeasons
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
