<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckoutCharges StructType
 * Meta information extracted from the WSDL
 * - documentation: Checkout charges and information.
 * @subpackage Structs
 */
class CheckoutCharges extends AbstractStructBase
{
    /**
     * The CheckoutCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * @var \StructType\CheckoutCharge[]
     */
    public $CheckoutCharge;
    /**
     * Constructor method for CheckoutCharges
     * @uses CheckoutCharges::setCheckoutCharge()
     * @param \StructType\CheckoutCharge[] $checkoutCharge
     */
    public function __construct(array $checkoutCharge = array())
    {
        $this
            ->setCheckoutCharge($checkoutCharge);
    }
    /**
     * Get CheckoutCharge value
     * @return \StructType\CheckoutCharge[]|null
     */
    public function getCheckoutCharge()
    {
        return $this->CheckoutCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setCheckoutCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckoutCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCheckoutChargeForArrayConstraintsFromSetCheckoutCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $checkoutChargesCheckoutChargeItem) {
            // validation for constraint: itemType
            if (!$checkoutChargesCheckoutChargeItem instanceof \StructType\CheckoutCharge) {
                $invalidValues[] = is_object($checkoutChargesCheckoutChargeItem) ? get_class($checkoutChargesCheckoutChargeItem) : sprintf('%s(%s)', gettype($checkoutChargesCheckoutChargeItem), var_export($checkoutChargesCheckoutChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CheckoutCharge property can only contain items of type \StructType\CheckoutCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CheckoutCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckoutCharge[] $checkoutCharge
     * @return \StructType\CheckoutCharges
     */
    public function setCheckoutCharge(array $checkoutCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($checkoutChargeArrayErrorMessage = self::validateCheckoutChargeForArrayConstraintsFromSetCheckoutCharge($checkoutCharge))) {
            throw new \InvalidArgumentException($checkoutChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($checkoutCharge) && count($checkoutCharge) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($checkoutCharge)), __LINE__);
        }
        $this->CheckoutCharge = $checkoutCharge;
        return $this;
    }
    /**
     * Add item to CheckoutCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckoutCharge $item
     * @return \StructType\CheckoutCharges
     */
    public function addToCheckoutCharge(\StructType\CheckoutCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CheckoutCharge) {
            throw new \InvalidArgumentException(sprintf('The CheckoutCharge property can only contain items of type \StructType\CheckoutCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->CheckoutCharge) && count($this->CheckoutCharge) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->CheckoutCharge)), __LINE__);
        }
        $this->CheckoutCharge[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckoutCharges
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
