<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CheckoutCharge StructType
 * Meta information extracted from the WSDL
 * - documentation: May be used to give further detail on the enumerated list or to remove an obsolete item. | The charges that may apply to an early or late checkout.
 * @subpackage Structs
 */
class CheckoutCharge extends AbstractStructBase
{
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: A percentage of the total stay amount for an early checkin or late checkout.. | The percentage of the room rate that applies to an early/late checkout.
     * - use: optional
     * @var float
     */
    public $Percent;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Type;
    /**
     * The NmbrOfNights
     * Meta information extracted from the WSDL
     * - documentation: The number of nights used to calculate the fee amount.
     * - use: optional
     * @var int
     */
    public $NmbrOfNights;
    /**
     * The ExistsCode
     * Meta information extracted from the WSDL
     * - documentation: This attribute is used to explicitly define whether the checkout charge applies. Refer to OpenTravel Code list Option Type Code (OTC). This is used in conjunction with Type.
     * - use: optional
     * @var string
     */
    public $ExistsCode;
    /**
     * The BalanceOfStayInd
     * Meta information extracted from the WSDL
     * - documentation: If true the charge for early checkout is the amount that would be charged for the remaining time of the original reservation.
     * - use: optional
     * @var bool
     */
    public $BalanceOfStayInd;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Checkout charges description.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * Constructor method for CheckoutCharge
     * @uses CheckoutCharge::setPercent()
     * @uses CheckoutCharge::setType()
     * @uses CheckoutCharge::setNmbrOfNights()
     * @uses CheckoutCharge::setExistsCode()
     * @uses CheckoutCharge::setBalanceOfStayInd()
     * @uses CheckoutCharge::setDescription()
     * @param float $percent
     * @param string $type
     * @param int $nmbrOfNights
     * @param string $existsCode
     * @param bool $balanceOfStayInd
     * @param mixed[] $description
     */
    public function __construct($percent = null, $type = null, $nmbrOfNights = null, $existsCode = null, $balanceOfStayInd = null, array $description = array())
    {
        $this
            ->setPercent($percent)
            ->setType($type)
            ->setNmbrOfNights($nmbrOfNights)
            ->setExistsCode($existsCode)
            ->setBalanceOfStayInd($balanceOfStayInd)
            ->setDescription($description);
    }
    /**
     * Get Percent value
     * @return float|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param float $percent
     * @return \StructType\CheckoutCharge
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: float
        if (!is_null($percent) && !(is_float($percent) || is_numeric($percent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\CheckoutCharge
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get NmbrOfNights value
     * @return int|null
     */
    public function getNmbrOfNights()
    {
        return $this->NmbrOfNights;
    }
    /**
     * Set NmbrOfNights value
     * @param int $nmbrOfNights
     * @return \StructType\CheckoutCharge
     */
    public function setNmbrOfNights($nmbrOfNights = null)
    {
        // validation for constraint: int
        if (!is_null($nmbrOfNights) && !(is_int($nmbrOfNights) || ctype_digit($nmbrOfNights))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nmbrOfNights, true), gettype($nmbrOfNights)), __LINE__);
        }
        $this->NmbrOfNights = $nmbrOfNights;
        return $this;
    }
    /**
     * Get ExistsCode value
     * @return string|null
     */
    public function getExistsCode()
    {
        return $this->ExistsCode;
    }
    /**
     * Set ExistsCode value
     * @param string $existsCode
     * @return \StructType\CheckoutCharge
     */
    public function setExistsCode($existsCode = null)
    {
        // validation for constraint: string
        if (!is_null($existsCode) && !is_string($existsCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($existsCode, true), gettype($existsCode)), __LINE__);
        }
        $this->ExistsCode = $existsCode;
        return $this;
    }
    /**
     * Get BalanceOfStayInd value
     * @return bool|null
     */
    public function getBalanceOfStayInd()
    {
        return $this->BalanceOfStayInd;
    }
    /**
     * Set BalanceOfStayInd value
     * @param bool $balanceOfStayInd
     * @return \StructType\CheckoutCharge
     */
    public function setBalanceOfStayInd($balanceOfStayInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($balanceOfStayInd) && !is_bool($balanceOfStayInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($balanceOfStayInd, true), gettype($balanceOfStayInd)), __LINE__);
        }
        $this->BalanceOfStayInd = $balanceOfStayInd;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $checkoutChargeDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($checkoutChargeDescriptionItem) ? get_class($checkoutChargeDescriptionItem) : sprintf('%s(%s)', gettype($checkoutChargeDescriptionItem), var_export($checkoutChargeDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\CheckoutCharge
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($description) && count($description) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\CheckoutCharge
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->Description) && count($this->Description) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CheckoutCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
