<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryOptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies category code information. | Specifies the fare code and or group code associated with the category. | Specifies category option information.
 * @subpackage Structs
 */
class CategoryOptionType extends AbstractStructBase
{
    /**
     * The PriceInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PriceInfos
     */
    public $PriceInfos;
    /**
     * The Dining
     * Meta information extracted from the WSDL
     * - maxOccurs: 8
     * - minOccurs: 0
     * @var \StructType\Dining[]
     */
    public $Dining;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Category availability status. Refer to OpenTravel Code table Status (STS).
     * - use: optional
     * @var string
     */
    public $Status;
    /**
     * The HeldIndicator
     * Meta information extracted from the WSDL
     * - documentation: When true, all cabins in this category are currently being held.
     * - use: optional
     * @var bool
     */
    public $HeldIndicator;
    /**
     * The CategoryLocation
     * Meta information extracted from the WSDL
     * - documentation: Category location in the ship: (I) Inside or (O) Outside.
     * - use: optional
     * @var string
     */
    public $CategoryLocation;
    /**
     * The MaxOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Maximum number of guest per cabin.
     * - use: optional
     * @var int
     */
    public $MaxOccupancy;
    /**
     * The ListOfCategoryQualifierCodes
     * Meta information extracted from the WSDL
     * - documentation: Contains additional category information. Refer to OpenTravel Code List Cabin Filters (CBF).
     * - use: optional
     * @var list
     */
    public $ListOfCategoryQualifierCodes;
    /**
     * The AvailableGroupAllocationQty
     * Meta information extracted from the WSDL
     * - documentation: Number of remaining cabins allocated to the group.
     * - use: optional
     * @var int
     */
    public $AvailableGroupAllocationQty;
    /**
     * Constructor method for CategoryOptionType
     * @uses CategoryOptionType::setPriceInfos()
     * @uses CategoryOptionType::setDining()
     * @uses CategoryOptionType::setStatus()
     * @uses CategoryOptionType::setHeldIndicator()
     * @uses CategoryOptionType::setCategoryLocation()
     * @uses CategoryOptionType::setMaxOccupancy()
     * @uses CategoryOptionType::setListOfCategoryQualifierCodes()
     * @uses CategoryOptionType::setAvailableGroupAllocationQty()
     * @param \StructType\PriceInfos $priceInfos
     * @param \StructType\Dining[] $dining
     * @param string $status
     * @param bool $heldIndicator
     * @param string $categoryLocation
     * @param int $maxOccupancy
     * @param list $listOfCategoryQualifierCodes
     * @param int $availableGroupAllocationQty
     */
    public function __construct(\StructType\PriceInfos $priceInfos = null, array $dining = array(), $status = null, $heldIndicator = null, $categoryLocation = null, $maxOccupancy = null, list $listOfCategoryQualifierCodes = null, $availableGroupAllocationQty = null)
    {
        $this
            ->setPriceInfos($priceInfos)
            ->setDining($dining)
            ->setStatus($status)
            ->setHeldIndicator($heldIndicator)
            ->setCategoryLocation($categoryLocation)
            ->setMaxOccupancy($maxOccupancy)
            ->setListOfCategoryQualifierCodes($listOfCategoryQualifierCodes)
            ->setAvailableGroupAllocationQty($availableGroupAllocationQty);
    }
    /**
     * Get PriceInfos value
     * @return \StructType\PriceInfos|null
     */
    public function getPriceInfos()
    {
        return $this->PriceInfos;
    }
    /**
     * Set PriceInfos value
     * @param \StructType\PriceInfos $priceInfos
     * @return \StructType\CategoryOptionType
     */
    public function setPriceInfos(\StructType\PriceInfos $priceInfos = null)
    {
        $this->PriceInfos = $priceInfos;
        return $this;
    }
    /**
     * Get Dining value
     * @return \StructType\Dining[]|null
     */
    public function getDining()
    {
        return $this->Dining;
    }
    /**
     * This method is responsible for validating the values passed to the setDining method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDining method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiningForArrayConstraintsFromSetDining(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryOptionTypeDiningItem) {
            // validation for constraint: itemType
            if (!$categoryOptionTypeDiningItem instanceof \StructType\Dining) {
                $invalidValues[] = is_object($categoryOptionTypeDiningItem) ? get_class($categoryOptionTypeDiningItem) : sprintf('%s(%s)', gettype($categoryOptionTypeDiningItem), var_export($categoryOptionTypeDiningItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Dining property can only contain items of type \StructType\Dining, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Dining value
     * @throws \InvalidArgumentException
     * @param \StructType\Dining[] $dining
     * @return \StructType\CategoryOptionType
     */
    public function setDining(array $dining = array())
    {
        // validation for constraint: array
        if ('' !== ($diningArrayErrorMessage = self::validateDiningForArrayConstraintsFromSetDining($dining))) {
            throw new \InvalidArgumentException($diningArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(8)
        if (is_array($dining) && count($dining) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 8', count($dining)), __LINE__);
        }
        $this->Dining = $dining;
        return $this;
    }
    /**
     * Add item to Dining value
     * @throws \InvalidArgumentException
     * @param \StructType\Dining $item
     * @return \StructType\CategoryOptionType
     */
    public function addToDining(\StructType\Dining $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Dining) {
            throw new \InvalidArgumentException(sprintf('The Dining property can only contain items of type \StructType\Dining, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(8)
        if (is_array($this->Dining) && count($this->Dining) >= 8) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 8', count($this->Dining)), __LINE__);
        }
        $this->Dining[] = $item;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\CategoryOptionType
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get HeldIndicator value
     * @return bool|null
     */
    public function getHeldIndicator()
    {
        return $this->HeldIndicator;
    }
    /**
     * Set HeldIndicator value
     * @param bool $heldIndicator
     * @return \StructType\CategoryOptionType
     */
    public function setHeldIndicator($heldIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($heldIndicator) && !is_bool($heldIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($heldIndicator, true), gettype($heldIndicator)), __LINE__);
        }
        $this->HeldIndicator = $heldIndicator;
        return $this;
    }
    /**
     * Get CategoryLocation value
     * @return string|null
     */
    public function getCategoryLocation()
    {
        return $this->CategoryLocation;
    }
    /**
     * Set CategoryLocation value
     * @uses \EnumType\CategoryLocationType::valueIsValid()
     * @uses \EnumType\CategoryLocationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $categoryLocation
     * @return \StructType\CategoryOptionType
     */
    public function setCategoryLocation($categoryLocation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CategoryLocationType::valueIsValid($categoryLocation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CategoryLocationType', is_array($categoryLocation) ? implode(', ', $categoryLocation) : var_export($categoryLocation, true), implode(', ', \EnumType\CategoryLocationType::getValidValues())), __LINE__);
        }
        $this->CategoryLocation = $categoryLocation;
        return $this;
    }
    /**
     * Get MaxOccupancy value
     * @return int|null
     */
    public function getMaxOccupancy()
    {
        return $this->MaxOccupancy;
    }
    /**
     * Set MaxOccupancy value
     * @param int $maxOccupancy
     * @return \StructType\CategoryOptionType
     */
    public function setMaxOccupancy($maxOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxOccupancy) && !(is_int($maxOccupancy) || ctype_digit($maxOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxOccupancy, true), gettype($maxOccupancy)), __LINE__);
        }
        $this->MaxOccupancy = $maxOccupancy;
        return $this;
    }
    /**
     * Get ListOfCategoryQualifierCodes value
     * @return list|null
     */
    public function getListOfCategoryQualifierCodes()
    {
        return $this->ListOfCategoryQualifierCodes;
    }
    /**
     * Set ListOfCategoryQualifierCodes value
     * @param list $listOfCategoryQualifierCodes
     * @return \StructType\CategoryOptionType
     */
    public function setListOfCategoryQualifierCodes(list $listOfCategoryQualifierCodes = null)
    {
        $this->ListOfCategoryQualifierCodes = $listOfCategoryQualifierCodes;
        return $this;
    }
    /**
     * Get AvailableGroupAllocationQty value
     * @return int|null
     */
    public function getAvailableGroupAllocationQty()
    {
        return $this->AvailableGroupAllocationQty;
    }
    /**
     * Set AvailableGroupAllocationQty value
     * @param int $availableGroupAllocationQty
     * @return \StructType\CategoryOptionType
     */
    public function setAvailableGroupAllocationQty($availableGroupAllocationQty = null)
    {
        // validation for constraint: int
        if (!is_null($availableGroupAllocationQty) && !(is_int($availableGroupAllocationQty) || ctype_digit($availableGroupAllocationQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableGroupAllocationQty, true), gettype($availableGroupAllocationQty)), __LINE__);
        }
        $this->AvailableGroupAllocationQty = $availableGroupAllocationQty;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CategoryOptionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
