<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CategoryCodesType StructType
 * Meta information extracted from the WSDL
 * - documentation: Used to define specific hotel information such as the type, location and architectural style.
 * @subpackage Structs
 */
class CategoryCodesType extends AbstractStructBase
{
    /**
     * The LocationCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LocationCategory[]
     */
    public $LocationCategory;
    /**
     * The SegmentCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SegmentCategory[]
     */
    public $SegmentCategory;
    /**
     * The HotelCategory
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\HotelCategory[]
     */
    public $HotelCategory;
    /**
     * The ArchitecturalStyle
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ArchitecturalStyle[]
     */
    public $ArchitecturalStyle;
    /**
     * The GuestRoomInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\GuestRoomInfo[]
     */
    public $GuestRoomInfo;
    /**
     * Constructor method for CategoryCodesType
     * @uses CategoryCodesType::setLocationCategory()
     * @uses CategoryCodesType::setSegmentCategory()
     * @uses CategoryCodesType::setHotelCategory()
     * @uses CategoryCodesType::setArchitecturalStyle()
     * @uses CategoryCodesType::setGuestRoomInfo()
     * @param \StructType\LocationCategory[] $locationCategory
     * @param \StructType\SegmentCategory[] $segmentCategory
     * @param \StructType\HotelCategory[] $hotelCategory
     * @param \StructType\ArchitecturalStyle[] $architecturalStyle
     * @param \StructType\GuestRoomInfo[] $guestRoomInfo
     */
    public function __construct(array $locationCategory = array(), array $segmentCategory = array(), array $hotelCategory = array(), array $architecturalStyle = array(), array $guestRoomInfo = array())
    {
        $this
            ->setLocationCategory($locationCategory)
            ->setSegmentCategory($segmentCategory)
            ->setHotelCategory($hotelCategory)
            ->setArchitecturalStyle($architecturalStyle)
            ->setGuestRoomInfo($guestRoomInfo);
    }
    /**
     * Get LocationCategory value
     * @return \StructType\LocationCategory[]|null
     */
    public function getLocationCategory()
    {
        return $this->LocationCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setLocationCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLocationCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLocationCategoryForArrayConstraintsFromSetLocationCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryCodesTypeLocationCategoryItem) {
            // validation for constraint: itemType
            if (!$categoryCodesTypeLocationCategoryItem instanceof \StructType\LocationCategory) {
                $invalidValues[] = is_object($categoryCodesTypeLocationCategoryItem) ? get_class($categoryCodesTypeLocationCategoryItem) : sprintf('%s(%s)', gettype($categoryCodesTypeLocationCategoryItem), var_export($categoryCodesTypeLocationCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LocationCategory property can only contain items of type \StructType\LocationCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LocationCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationCategory[] $locationCategory
     * @return \StructType\CategoryCodesType
     */
    public function setLocationCategory(array $locationCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($locationCategoryArrayErrorMessage = self::validateLocationCategoryForArrayConstraintsFromSetLocationCategory($locationCategory))) {
            throw new \InvalidArgumentException($locationCategoryArrayErrorMessage, __LINE__);
        }
        $this->LocationCategory = $locationCategory;
        return $this;
    }
    /**
     * Add item to LocationCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\LocationCategory $item
     * @return \StructType\CategoryCodesType
     */
    public function addToLocationCategory(\StructType\LocationCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LocationCategory) {
            throw new \InvalidArgumentException(sprintf('The LocationCategory property can only contain items of type \StructType\LocationCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LocationCategory[] = $item;
        return $this;
    }
    /**
     * Get SegmentCategory value
     * @return \StructType\SegmentCategory[]|null
     */
    public function getSegmentCategory()
    {
        return $this->SegmentCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setSegmentCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegmentCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentCategoryForArrayConstraintsFromSetSegmentCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryCodesTypeSegmentCategoryItem) {
            // validation for constraint: itemType
            if (!$categoryCodesTypeSegmentCategoryItem instanceof \StructType\SegmentCategory) {
                $invalidValues[] = is_object($categoryCodesTypeSegmentCategoryItem) ? get_class($categoryCodesTypeSegmentCategoryItem) : sprintf('%s(%s)', gettype($categoryCodesTypeSegmentCategoryItem), var_export($categoryCodesTypeSegmentCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SegmentCategory property can only contain items of type \StructType\SegmentCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SegmentCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentCategory[] $segmentCategory
     * @return \StructType\CategoryCodesType
     */
    public function setSegmentCategory(array $segmentCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentCategoryArrayErrorMessage = self::validateSegmentCategoryForArrayConstraintsFromSetSegmentCategory($segmentCategory))) {
            throw new \InvalidArgumentException($segmentCategoryArrayErrorMessage, __LINE__);
        }
        $this->SegmentCategory = $segmentCategory;
        return $this;
    }
    /**
     * Add item to SegmentCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentCategory $item
     * @return \StructType\CategoryCodesType
     */
    public function addToSegmentCategory(\StructType\SegmentCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SegmentCategory) {
            throw new \InvalidArgumentException(sprintf('The SegmentCategory property can only contain items of type \StructType\SegmentCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SegmentCategory[] = $item;
        return $this;
    }
    /**
     * Get HotelCategory value
     * @return \StructType\HotelCategory[]|null
     */
    public function getHotelCategory()
    {
        return $this->HotelCategory;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelCategory method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelCategory method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelCategoryForArrayConstraintsFromSetHotelCategory(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryCodesTypeHotelCategoryItem) {
            // validation for constraint: itemType
            if (!$categoryCodesTypeHotelCategoryItem instanceof \StructType\HotelCategory) {
                $invalidValues[] = is_object($categoryCodesTypeHotelCategoryItem) ? get_class($categoryCodesTypeHotelCategoryItem) : sprintf('%s(%s)', gettype($categoryCodesTypeHotelCategoryItem), var_export($categoryCodesTypeHotelCategoryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelCategory property can only contain items of type \StructType\HotelCategory, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelCategory[] $hotelCategory
     * @return \StructType\CategoryCodesType
     */
    public function setHotelCategory(array $hotelCategory = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelCategoryArrayErrorMessage = self::validateHotelCategoryForArrayConstraintsFromSetHotelCategory($hotelCategory))) {
            throw new \InvalidArgumentException($hotelCategoryArrayErrorMessage, __LINE__);
        }
        $this->HotelCategory = $hotelCategory;
        return $this;
    }
    /**
     * Add item to HotelCategory value
     * @throws \InvalidArgumentException
     * @param \StructType\HotelCategory $item
     * @return \StructType\CategoryCodesType
     */
    public function addToHotelCategory(\StructType\HotelCategory $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\HotelCategory) {
            throw new \InvalidArgumentException(sprintf('The HotelCategory property can only contain items of type \StructType\HotelCategory, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelCategory[] = $item;
        return $this;
    }
    /**
     * Get ArchitecturalStyle value
     * @return \StructType\ArchitecturalStyle[]|null
     */
    public function getArchitecturalStyle()
    {
        return $this->ArchitecturalStyle;
    }
    /**
     * This method is responsible for validating the values passed to the setArchitecturalStyle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArchitecturalStyle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateArchitecturalStyleForArrayConstraintsFromSetArchitecturalStyle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryCodesTypeArchitecturalStyleItem) {
            // validation for constraint: itemType
            if (!$categoryCodesTypeArchitecturalStyleItem instanceof \StructType\ArchitecturalStyle) {
                $invalidValues[] = is_object($categoryCodesTypeArchitecturalStyleItem) ? get_class($categoryCodesTypeArchitecturalStyleItem) : sprintf('%s(%s)', gettype($categoryCodesTypeArchitecturalStyleItem), var_export($categoryCodesTypeArchitecturalStyleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ArchitecturalStyle property can only contain items of type \StructType\ArchitecturalStyle, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ArchitecturalStyle value
     * @throws \InvalidArgumentException
     * @param \StructType\ArchitecturalStyle[] $architecturalStyle
     * @return \StructType\CategoryCodesType
     */
    public function setArchitecturalStyle(array $architecturalStyle = array())
    {
        // validation for constraint: array
        if ('' !== ($architecturalStyleArrayErrorMessage = self::validateArchitecturalStyleForArrayConstraintsFromSetArchitecturalStyle($architecturalStyle))) {
            throw new \InvalidArgumentException($architecturalStyleArrayErrorMessage, __LINE__);
        }
        $this->ArchitecturalStyle = $architecturalStyle;
        return $this;
    }
    /**
     * Add item to ArchitecturalStyle value
     * @throws \InvalidArgumentException
     * @param \StructType\ArchitecturalStyle $item
     * @return \StructType\CategoryCodesType
     */
    public function addToArchitecturalStyle(\StructType\ArchitecturalStyle $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArchitecturalStyle) {
            throw new \InvalidArgumentException(sprintf('The ArchitecturalStyle property can only contain items of type \StructType\ArchitecturalStyle, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ArchitecturalStyle[] = $item;
        return $this;
    }
    /**
     * Get GuestRoomInfo value
     * @return \StructType\GuestRoomInfo[]|null
     */
    public function getGuestRoomInfo()
    {
        return $this->GuestRoomInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setGuestRoomInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGuestRoomInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGuestRoomInfoForArrayConstraintsFromSetGuestRoomInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $categoryCodesTypeGuestRoomInfoItem) {
            // validation for constraint: itemType
            if (!$categoryCodesTypeGuestRoomInfoItem instanceof \StructType\GuestRoomInfo) {
                $invalidValues[] = is_object($categoryCodesTypeGuestRoomInfoItem) ? get_class($categoryCodesTypeGuestRoomInfoItem) : sprintf('%s(%s)', gettype($categoryCodesTypeGuestRoomInfoItem), var_export($categoryCodesTypeGuestRoomInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GuestRoomInfo property can only contain items of type \StructType\GuestRoomInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GuestRoomInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestRoomInfo[] $guestRoomInfo
     * @return \StructType\CategoryCodesType
     */
    public function setGuestRoomInfo(array $guestRoomInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($guestRoomInfoArrayErrorMessage = self::validateGuestRoomInfoForArrayConstraintsFromSetGuestRoomInfo($guestRoomInfo))) {
            throw new \InvalidArgumentException($guestRoomInfoArrayErrorMessage, __LINE__);
        }
        $this->GuestRoomInfo = $guestRoomInfo;
        return $this;
    }
    /**
     * Add item to GuestRoomInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\GuestRoomInfo $item
     * @return \StructType\CategoryCodesType
     */
    public function addToGuestRoomInfo(\StructType\GuestRoomInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\GuestRoomInfo) {
            throw new \InvalidArgumentException(sprintf('The GuestRoomInfo property can only contain items of type \StructType\GuestRoomInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->GuestRoomInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CategoryCodesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
