<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CarrierFeeInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Data for the collection of non-airport/ government fees.
 * @subpackage Structs
 */
class CarrierFeeInfo extends AbstractStructBase
{
    /**
     * The PaymentDetail
     * Meta information extracted from the WSDL
     * - documentation: Form of payment information.
     * - minOccurs: 0
     * @var mixed
     */
    public $PaymentDetail;
    /**
     * The CarrierFee
     * Meta information extracted from the WSDL
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var \StructType\CarrierFee[]
     */
    public $CarrierFee;
    /**
     * The Taxes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Taxes
     */
    public $Taxes;
    /**
     * Constructor method for CarrierFeeInfo
     * @uses CarrierFeeInfo::setPaymentDetail()
     * @uses CarrierFeeInfo::setCarrierFee()
     * @uses CarrierFeeInfo::setTaxes()
     * @param mixed $paymentDetail
     * @param \StructType\CarrierFee[] $carrierFee
     * @param \StructType\Taxes $taxes
     */
    public function __construct($paymentDetail = null, array $carrierFee = array(), \StructType\Taxes $taxes = null)
    {
        $this
            ->setPaymentDetail($paymentDetail)
            ->setCarrierFee($carrierFee)
            ->setTaxes($taxes);
    }
    /**
     * Get PaymentDetail value
     * @return mixed|null
     */
    public function getPaymentDetail()
    {
        return $this->PaymentDetail;
    }
    /**
     * Set PaymentDetail value
     * @param mixed $paymentDetail
     * @return \StructType\CarrierFeeInfo
     */
    public function setPaymentDetail($paymentDetail = null)
    {
        $this->PaymentDetail = $paymentDetail;
        return $this;
    }
    /**
     * Get CarrierFee value
     * @return \StructType\CarrierFee[]|null
     */
    public function getCarrierFee()
    {
        return $this->CarrierFee;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierFee method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierFee method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierFeeForArrayConstraintsFromSetCarrierFee(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $carrierFeeInfoCarrierFeeItem) {
            // validation for constraint: itemType
            if (!$carrierFeeInfoCarrierFeeItem instanceof \StructType\CarrierFee) {
                $invalidValues[] = is_object($carrierFeeInfoCarrierFeeItem) ? get_class($carrierFeeInfoCarrierFeeItem) : sprintf('%s(%s)', gettype($carrierFeeInfoCarrierFeeItem), var_export($carrierFeeInfoCarrierFeeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierFee property can only contain items of type \StructType\CarrierFee, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierFee value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierFee[] $carrierFee
     * @return \StructType\CarrierFeeInfo
     */
    public function setCarrierFee(array $carrierFee = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierFeeArrayErrorMessage = self::validateCarrierFeeForArrayConstraintsFromSetCarrierFee($carrierFee))) {
            throw new \InvalidArgumentException($carrierFeeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($carrierFee) && count($carrierFee) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($carrierFee)), __LINE__);
        }
        $this->CarrierFee = $carrierFee;
        return $this;
    }
    /**
     * Add item to CarrierFee value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierFee $item
     * @return \StructType\CarrierFeeInfo
     */
    public function addToCarrierFee(\StructType\CarrierFee $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarrierFee) {
            throw new \InvalidArgumentException(sprintf('The CarrierFee property can only contain items of type \StructType\CarrierFee, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->CarrierFee) && count($this->CarrierFee) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->CarrierFee)), __LINE__);
        }
        $this->CarrierFee[] = $item;
        return $this;
    }
    /**
     * Get Taxes value
     * @return \StructType\Taxes|null
     */
    public function getTaxes()
    {
        return $this->Taxes;
    }
    /**
     * Set Taxes value
     * @param \StructType\Taxes $taxes
     * @return \StructType\CarrierFeeInfo
     */
    public function setTaxes(\StructType\Taxes $taxes = null)
    {
        $this->Taxes = $taxes;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CarrierFeeInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
