<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CalculationMethod StructType
 * Meta information extracted from the WSDL
 * - documentation: Method used to calculate the earliest start date/ time.
 * @subpackage Structs
 */
class CalculationMethod extends AbstractStructBase
{
    /**
     * The Formula
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Formula
     */
    public $Formula;
    /**
     * The Distance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Distance
     */
    public $Distance;
    /**
     * The Duration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Duration
     */
    public $Duration;
    /**
     * The OntologyExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: OntologyExtension
     * @var mixed
     */
    public $OntologyExtension;
    /**
     * The OtherType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [a-zA-Z0-9]{1,64}
     * - use: optional
     * @var string
     */
    public $OtherType;
    /**
     * The OntologyRefID
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - pattern: [0-9]{1,8}
     * - use: optional
     * @var string
     */
    public $OntologyRefID;
    /**
     * Constructor method for CalculationMethod
     * @uses CalculationMethod::setFormula()
     * @uses CalculationMethod::setDistance()
     * @uses CalculationMethod::setDuration()
     * @uses CalculationMethod::setOntologyExtension()
     * @uses CalculationMethod::setOtherType()
     * @uses CalculationMethod::setOntologyRefID()
     * @param \StructType\Formula $formula
     * @param \StructType\Distance $distance
     * @param \StructType\Duration $duration
     * @param mixed $ontologyExtension
     * @param string $otherType
     * @param string $ontologyRefID
     */
    public function __construct(\StructType\Formula $formula = null, \StructType\Distance $distance = null, \StructType\Duration $duration = null, $ontologyExtension = null, $otherType = null, $ontologyRefID = null)
    {
        $this
            ->setFormula($formula)
            ->setDistance($distance)
            ->setDuration($duration)
            ->setOntologyExtension($ontologyExtension)
            ->setOtherType($otherType)
            ->setOntologyRefID($ontologyRefID);
    }
    /**
     * Get Formula value
     * @return \StructType\Formula|null
     */
    public function getFormula()
    {
        return $this->Formula;
    }
    /**
     * Set Formula value
     * @param \StructType\Formula $formula
     * @return \StructType\CalculationMethod
     */
    public function setFormula(\StructType\Formula $formula = null)
    {
        $this->Formula = $formula;
        return $this;
    }
    /**
     * Get Distance value
     * @return \StructType\Distance|null
     */
    public function getDistance()
    {
        return $this->Distance;
    }
    /**
     * Set Distance value
     * @param \StructType\Distance $distance
     * @return \StructType\CalculationMethod
     */
    public function setDistance(\StructType\Distance $distance = null)
    {
        $this->Distance = $distance;
        return $this;
    }
    /**
     * Get Duration value
     * @return \StructType\Duration|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param \StructType\Duration $duration
     * @return \StructType\CalculationMethod
     */
    public function setDuration(\StructType\Duration $duration = null)
    {
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get OntologyExtension value
     * @return mixed|null
     */
    public function getOntologyExtension()
    {
        return $this->OntologyExtension;
    }
    /**
     * Set OntologyExtension value
     * @param mixed $ontologyExtension
     * @return \StructType\CalculationMethod
     */
    public function setOntologyExtension($ontologyExtension = null)
    {
        $this->OntologyExtension = $ontologyExtension;
        return $this;
    }
    /**
     * Get OtherType value
     * @return string|null
     */
    public function getOtherType()
    {
        return $this->OtherType;
    }
    /**
     * Set OtherType value
     * @param string $otherType
     * @return \StructType\CalculationMethod
     */
    public function setOtherType($otherType = null)
    {
        // validation for constraint: string
        if (!is_null($otherType) && !is_string($otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherType, true), gettype($otherType)), __LINE__);
        }
        // validation for constraint: pattern([a-zA-Z0-9]{1,64})
        if (!is_null($otherType) && !preg_match('/[a-zA-Z0-9]{1,64}/', $otherType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [a-zA-Z0-9]{1,64}', var_export($otherType, true)), __LINE__);
        }
        $this->OtherType = $otherType;
        return $this;
    }
    /**
     * Get OntologyRefID value
     * @return string|null
     */
    public function getOntologyRefID()
    {
        return $this->OntologyRefID;
    }
    /**
     * Set OntologyRefID value
     * @param string $ontologyRefID
     * @return \StructType\CalculationMethod
     */
    public function setOntologyRefID($ontologyRefID = null)
    {
        // validation for constraint: string
        if (!is_null($ontologyRefID) && !is_string($ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ontologyRefID, true), gettype($ontologyRefID)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{1,8})
        if (!is_null($ontologyRefID) && !preg_match('/[0-9]{1,8}/', $ontologyRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{1,8}', var_export($ontologyRefID, true)), __LINE__);
        }
        $this->OntologyRefID = $ontologyRefID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CalculationMethod
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
