<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClassSummaryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary information about a cabin class.
 * @subpackage Structs
 */
class CabinClassSummaryType extends \EnumType\CabinType
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: A name that a particular airline/ CRS may give to the cabin class.
     * - use: required
     * @var string
     */
    public $Name;
    /**
     * The CabinCapacity
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of physical seats in the cabin.
     * - use: optional
     * @var int
     */
    public $CabinCapacity;
    /**
     * The RowQty
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of rows in this cabin class.
     * - use: optional
     * @var int
     */
    public $RowQty;
    /**
     * The StartingRow
     * Meta information extracted from the WSDL
     * - documentation: The starting row number for this cabin class.
     * - use: optional
     * @var int
     */
    public $StartingRow;
    /**
     * The EndingRow
     * Meta information extracted from the WSDL
     * - documentation: The ending row number for this cabin class.
     * - use: optional
     * @var int
     */
    public $EndingRow;
    /**
     * The AvailableSeatQty
     * Meta information extracted from the WSDL
     * - documentation: The total quantity of available seats in the cabin.
     * - use: optional
     * @var int
     */
    public $AvailableSeatQty;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique identifier for this cabin class that may be referenced elsewhere in the message.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for CabinClassSummaryType
     * @uses CabinClassSummaryType::setName()
     * @uses CabinClassSummaryType::setCabinCapacity()
     * @uses CabinClassSummaryType::setRowQty()
     * @uses CabinClassSummaryType::setStartingRow()
     * @uses CabinClassSummaryType::setEndingRow()
     * @uses CabinClassSummaryType::setAvailableSeatQty()
     * @uses CabinClassSummaryType::setRPH()
     * @param string $name
     * @param int $cabinCapacity
     * @param int $rowQty
     * @param int $startingRow
     * @param int $endingRow
     * @param int $availableSeatQty
     * @param string $rPH
     */
    public function __construct($name = null, $cabinCapacity = null, $rowQty = null, $startingRow = null, $endingRow = null, $availableSeatQty = null, $rPH = null)
    {
        $this
            ->setName($name)
            ->setCabinCapacity($cabinCapacity)
            ->setRowQty($rowQty)
            ->setStartingRow($startingRow)
            ->setEndingRow($endingRow)
            ->setAvailableSeatQty($availableSeatQty)
            ->setRPH($rPH);
    }
    /**
     * Get Name value
     * @return string
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CabinClassSummaryType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get CabinCapacity value
     * @return int|null
     */
    public function getCabinCapacity()
    {
        return $this->CabinCapacity;
    }
    /**
     * Set CabinCapacity value
     * @param int $cabinCapacity
     * @return \StructType\CabinClassSummaryType
     */
    public function setCabinCapacity($cabinCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($cabinCapacity) && !(is_int($cabinCapacity) || ctype_digit($cabinCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cabinCapacity, true), gettype($cabinCapacity)), __LINE__);
        }
        $this->CabinCapacity = $cabinCapacity;
        return $this;
    }
    /**
     * Get RowQty value
     * @return int|null
     */
    public function getRowQty()
    {
        return $this->RowQty;
    }
    /**
     * Set RowQty value
     * @param int $rowQty
     * @return \StructType\CabinClassSummaryType
     */
    public function setRowQty($rowQty = null)
    {
        // validation for constraint: int
        if (!is_null($rowQty) && !(is_int($rowQty) || ctype_digit($rowQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowQty, true), gettype($rowQty)), __LINE__);
        }
        $this->RowQty = $rowQty;
        return $this;
    }
    /**
     * Get StartingRow value
     * @return int|null
     */
    public function getStartingRow()
    {
        return $this->StartingRow;
    }
    /**
     * Set StartingRow value
     * @param int $startingRow
     * @return \StructType\CabinClassSummaryType
     */
    public function setStartingRow($startingRow = null)
    {
        // validation for constraint: int
        if (!is_null($startingRow) && !(is_int($startingRow) || ctype_digit($startingRow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startingRow, true), gettype($startingRow)), __LINE__);
        }
        $this->StartingRow = $startingRow;
        return $this;
    }
    /**
     * Get EndingRow value
     * @return int|null
     */
    public function getEndingRow()
    {
        return $this->EndingRow;
    }
    /**
     * Set EndingRow value
     * @param int $endingRow
     * @return \StructType\CabinClassSummaryType
     */
    public function setEndingRow($endingRow = null)
    {
        // validation for constraint: int
        if (!is_null($endingRow) && !(is_int($endingRow) || ctype_digit($endingRow))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($endingRow, true), gettype($endingRow)), __LINE__);
        }
        $this->EndingRow = $endingRow;
        return $this;
    }
    /**
     * Get AvailableSeatQty value
     * @return int|null
     */
    public function getAvailableSeatQty()
    {
        return $this->AvailableSeatQty;
    }
    /**
     * Set AvailableSeatQty value
     * @param int $availableSeatQty
     * @return \StructType\CabinClassSummaryType
     */
    public function setAvailableSeatQty($availableSeatQty = null)
    {
        // validation for constraint: int
        if (!is_null($availableSeatQty) && !(is_int($availableSeatQty) || ctype_digit($availableSeatQty))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availableSeatQty, true), gettype($availableSeatQty)), __LINE__);
        }
        $this->AvailableSeatQty = $availableSeatQty;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\CabinClassSummaryType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinClassSummaryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
