<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinClassQueryType StructType
 * Meta information extracted from the WSDL
 * - documentation: Search criteria information for one or more cabin classes.
 * @subpackage Structs
 */
class CabinClassQueryType extends \EnumType\CabinType
{
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name that a particular airline/ CRS may give to the cabin class.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The IncludeExclude
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $IncludeExclude;
    /**
     * Constructor method for CabinClassQueryType
     * @uses CabinClassQueryType::setName()
     * @uses CabinClassQueryType::setIncludeExclude()
     * @param string $name
     * @param string $includeExclude
     */
    public function __construct($name = null, $includeExclude = null)
    {
        $this
            ->setName($name)
            ->setIncludeExclude($includeExclude);
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\CabinClassQueryType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get IncludeExclude value
     * @return string|null
     */
    public function getIncludeExclude()
    {
        return $this->IncludeExclude;
    }
    /**
     * Set IncludeExclude value
     * @param string $includeExclude
     * @return \StructType\CabinClassQueryType
     */
    public function setIncludeExclude($includeExclude = null)
    {
        // validation for constraint: string
        if (!is_null($includeExclude) && !is_string($includeExclude)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($includeExclude, true), gettype($includeExclude)), __LINE__);
        }
        $this->IncludeExclude = $includeExclude;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinClassQueryType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
