<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabinAttributes StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of cabin attributes. | Collection of category-level cabin attributes.
 * @subpackage Structs
 */
class CabinAttributes extends AbstractStructBase
{
    /**
     * The CabinAttribute
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\CabinAttribute[]
     */
    public $CabinAttribute;
    /**
     * Constructor method for CabinAttributes
     * @uses CabinAttributes::setCabinAttribute()
     * @param \StructType\CabinAttribute[] $cabinAttribute
     */
    public function __construct(array $cabinAttribute = array())
    {
        $this
            ->setCabinAttribute($cabinAttribute);
    }
    /**
     * Get CabinAttribute value
     * @return \StructType\CabinAttribute[]|null
     */
    public function getCabinAttribute()
    {
        return $this->CabinAttribute;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinAttribute method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinAttribute method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinAttributeForArrayConstraintsFromSetCabinAttribute(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $cabinAttributesCabinAttributeItem) {
            // validation for constraint: itemType
            if (!$cabinAttributesCabinAttributeItem instanceof \StructType\CabinAttribute) {
                $invalidValues[] = is_object($cabinAttributesCabinAttributeItem) ? get_class($cabinAttributesCabinAttributeItem) : sprintf('%s(%s)', gettype($cabinAttributesCabinAttributeItem), var_export($cabinAttributesCabinAttributeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinAttribute property can only contain items of type \StructType\CabinAttribute, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinAttribute value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinAttribute[] $cabinAttribute
     * @return \StructType\CabinAttributes
     */
    public function setCabinAttribute(array $cabinAttribute = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinAttributeArrayErrorMessage = self::validateCabinAttributeForArrayConstraintsFromSetCabinAttribute($cabinAttribute))) {
            throw new \InvalidArgumentException($cabinAttributeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($cabinAttribute) && count($cabinAttribute) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($cabinAttribute)), __LINE__);
        }
        $this->CabinAttribute = $cabinAttribute;
        return $this;
    }
    /**
     * Add item to CabinAttribute value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinAttribute $item
     * @return \StructType\CabinAttributes
     */
    public function addToCabinAttribute(\StructType\CabinAttribute $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinAttribute) {
            throw new \InvalidArgumentException(sprintf('The CabinAttribute property can only contain items of type \StructType\CabinAttribute, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->CabinAttribute) && count($this->CabinAttribute) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->CabinAttribute)), __LINE__);
        }
        $this->CabinAttribute[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabinAttributes
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
