<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusSegmentType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines information about a bus segment.
 * @subpackage Structs
 */
class BusSegmentType extends AbstractStructBase
{
    /**
     * The DepartureStation
     * Meta information extracted from the WSDL
     * - documentation: The departure point of the bus segment.
     * @var mixed
     */
    public $DepartureStation;
    /**
     * The ArrivalStation
     * Meta information extracted from the WSDL
     * - documentation: The arrival point of the bus segment.
     * @var mixed
     */
    public $ArrivalStation;
    /**
     * The MarketingCompany
     * Meta information extracted from the WSDL
     * - documentation: The marketing bus company.
     * @var mixed
     */
    public $MarketingCompany;
    /**
     * The OperatingCompany
     * Meta information extracted from the WSDL
     * - documentation: The operating bus company, if different from the Marketing Company.
     * - minOccurs: 0
     * @var mixed
     */
    public $OperatingCompany;
    /**
     * The Equipment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Equipment
     */
    public $Equipment;
    /**
     * The BusInfo
     * Meta information extracted from the WSDL
     * - documentation: Detailed information about the bus.
     * - minOccurs: 0
     * @var mixed
     */
    public $BusInfo;
    /**
     * The DepartureDateTime
     * Meta information extracted from the WSDL
     * - documentation: The departure date and time.
     * - use: optional
     * @var string
     */
    public $DepartureDateTime;
    /**
     * The ArrivalDateTime
     * Meta information extracted from the WSDL
     * - documentation: The arrival date and time.
     * - use: optional
     * @var string
     */
    public $ArrivalDateTime;
    /**
     * The StopQuantity
     * Meta information extracted from the WSDL
     * - documentation: The number of stops the bus makes.
     * - use: optional
     * @var int
     */
    public $StopQuantity;
    /**
     * The JourneyDuration
     * Meta information extracted from the WSDL
     * - documentation: The duration of the bus from departure location to destination location.
     * - use: optional
     * @var string
     */
    public $JourneyDuration;
    /**
     * The CrossBorderInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the bus schedule includes a border crossing.
     * - use: optional
     * @var bool
     */
    public $CrossBorderInd;
    /**
     * Constructor method for BusSegmentType
     * @uses BusSegmentType::setDepartureStation()
     * @uses BusSegmentType::setArrivalStation()
     * @uses BusSegmentType::setMarketingCompany()
     * @uses BusSegmentType::setOperatingCompany()
     * @uses BusSegmentType::setEquipment()
     * @uses BusSegmentType::setBusInfo()
     * @uses BusSegmentType::setDepartureDateTime()
     * @uses BusSegmentType::setArrivalDateTime()
     * @uses BusSegmentType::setStopQuantity()
     * @uses BusSegmentType::setJourneyDuration()
     * @uses BusSegmentType::setCrossBorderInd()
     * @param mixed $departureStation
     * @param mixed $arrivalStation
     * @param mixed $marketingCompany
     * @param mixed $operatingCompany
     * @param \StructType\Equipment $equipment
     * @param mixed $busInfo
     * @param string $departureDateTime
     * @param string $arrivalDateTime
     * @param int $stopQuantity
     * @param string $journeyDuration
     * @param bool $crossBorderInd
     */
    public function __construct($departureStation = null, $arrivalStation = null, $marketingCompany = null, $operatingCompany = null, \StructType\Equipment $equipment = null, $busInfo = null, $departureDateTime = null, $arrivalDateTime = null, $stopQuantity = null, $journeyDuration = null, $crossBorderInd = null)
    {
        $this
            ->setDepartureStation($departureStation)
            ->setArrivalStation($arrivalStation)
            ->setMarketingCompany($marketingCompany)
            ->setOperatingCompany($operatingCompany)
            ->setEquipment($equipment)
            ->setBusInfo($busInfo)
            ->setDepartureDateTime($departureDateTime)
            ->setArrivalDateTime($arrivalDateTime)
            ->setStopQuantity($stopQuantity)
            ->setJourneyDuration($journeyDuration)
            ->setCrossBorderInd($crossBorderInd);
    }
    /**
     * Get DepartureStation value
     * @return mixed|null
     */
    public function getDepartureStation()
    {
        return $this->DepartureStation;
    }
    /**
     * Set DepartureStation value
     * @param mixed $departureStation
     * @return \StructType\BusSegmentType
     */
    public function setDepartureStation($departureStation = null)
    {
        $this->DepartureStation = $departureStation;
        return $this;
    }
    /**
     * Get ArrivalStation value
     * @return mixed|null
     */
    public function getArrivalStation()
    {
        return $this->ArrivalStation;
    }
    /**
     * Set ArrivalStation value
     * @param mixed $arrivalStation
     * @return \StructType\BusSegmentType
     */
    public function setArrivalStation($arrivalStation = null)
    {
        $this->ArrivalStation = $arrivalStation;
        return $this;
    }
    /**
     * Get MarketingCompany value
     * @return mixed|null
     */
    public function getMarketingCompany()
    {
        return $this->MarketingCompany;
    }
    /**
     * Set MarketingCompany value
     * @param mixed $marketingCompany
     * @return \StructType\BusSegmentType
     */
    public function setMarketingCompany($marketingCompany = null)
    {
        $this->MarketingCompany = $marketingCompany;
        return $this;
    }
    /**
     * Get OperatingCompany value
     * @return mixed|null
     */
    public function getOperatingCompany()
    {
        return $this->OperatingCompany;
    }
    /**
     * Set OperatingCompany value
     * @param mixed $operatingCompany
     * @return \StructType\BusSegmentType
     */
    public function setOperatingCompany($operatingCompany = null)
    {
        $this->OperatingCompany = $operatingCompany;
        return $this;
    }
    /**
     * Get Equipment value
     * @return \StructType\Equipment|null
     */
    public function getEquipment()
    {
        return $this->Equipment;
    }
    /**
     * Set Equipment value
     * @param \StructType\Equipment $equipment
     * @return \StructType\BusSegmentType
     */
    public function setEquipment(\StructType\Equipment $equipment = null)
    {
        $this->Equipment = $equipment;
        return $this;
    }
    /**
     * Get BusInfo value
     * @return mixed|null
     */
    public function getBusInfo()
    {
        return $this->BusInfo;
    }
    /**
     * Set BusInfo value
     * @param mixed $busInfo
     * @return \StructType\BusSegmentType
     */
    public function setBusInfo($busInfo = null)
    {
        $this->BusInfo = $busInfo;
        return $this;
    }
    /**
     * Get DepartureDateTime value
     * @return string|null
     */
    public function getDepartureDateTime()
    {
        return $this->DepartureDateTime;
    }
    /**
     * Set DepartureDateTime value
     * @param string $departureDateTime
     * @return \StructType\BusSegmentType
     */
    public function setDepartureDateTime($departureDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($departureDateTime) && !is_string($departureDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDateTime, true), gettype($departureDateTime)), __LINE__);
        }
        $this->DepartureDateTime = $departureDateTime;
        return $this;
    }
    /**
     * Get ArrivalDateTime value
     * @return string|null
     */
    public function getArrivalDateTime()
    {
        return $this->ArrivalDateTime;
    }
    /**
     * Set ArrivalDateTime value
     * @param string $arrivalDateTime
     * @return \StructType\BusSegmentType
     */
    public function setArrivalDateTime($arrivalDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalDateTime) && !is_string($arrivalDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($arrivalDateTime, true), gettype($arrivalDateTime)), __LINE__);
        }
        $this->ArrivalDateTime = $arrivalDateTime;
        return $this;
    }
    /**
     * Get StopQuantity value
     * @return int|null
     */
    public function getStopQuantity()
    {
        return $this->StopQuantity;
    }
    /**
     * Set StopQuantity value
     * @param int $stopQuantity
     * @return \StructType\BusSegmentType
     */
    public function setStopQuantity($stopQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($stopQuantity) && !(is_int($stopQuantity) || ctype_digit($stopQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stopQuantity, true), gettype($stopQuantity)), __LINE__);
        }
        $this->StopQuantity = $stopQuantity;
        return $this;
    }
    /**
     * Get JourneyDuration value
     * @return string|null
     */
    public function getJourneyDuration()
    {
        return $this->JourneyDuration;
    }
    /**
     * Set JourneyDuration value
     * @param string $journeyDuration
     * @return \StructType\BusSegmentType
     */
    public function setJourneyDuration($journeyDuration = null)
    {
        // validation for constraint: string
        if (!is_null($journeyDuration) && !is_string($journeyDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journeyDuration, true), gettype($journeyDuration)), __LINE__);
        }
        $this->JourneyDuration = $journeyDuration;
        return $this;
    }
    /**
     * Get CrossBorderInd value
     * @return bool|null
     */
    public function getCrossBorderInd()
    {
        return $this->CrossBorderInd;
    }
    /**
     * Set CrossBorderInd value
     * @param bool $crossBorderInd
     * @return \StructType\BusSegmentType
     */
    public function setCrossBorderInd($crossBorderInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($crossBorderInd) && !is_bool($crossBorderInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($crossBorderInd, true), gettype($crossBorderInd)), __LINE__);
        }
        $this->CrossBorderInd = $crossBorderInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusSegmentType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
