<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BusIdentificationType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines bus identification information.
 * @subpackage Structs
 */
class BusIdentificationType extends AbstractStructBase
{
    /**
     * The BusNumber
     * Meta information extracted from the WSDL
     * - documentation: The unique number that identifies the bus.
     * - base: xs:string
     * - maxLength: 8
     * - minLength: 1
     * @var string
     */
    public $BusNumber;
    /**
     * The NetworkCode
     * Meta information extracted from the WSDL
     * - documentation: The network code of a bus operator.
     * @var mixed
     */
    public $NetworkCode;
    /**
     * The BusTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The bus type. Use a string value or a value from an OpenTravel code list (to be defined in 2011B specification.)
     * - use: optional
     * @var string
     */
    public $BusTypeCode;
    /**
     * Constructor method for BusIdentificationType
     * @uses BusIdentificationType::setBusNumber()
     * @uses BusIdentificationType::setNetworkCode()
     * @uses BusIdentificationType::setBusTypeCode()
     * @param string $busNumber
     * @param mixed $networkCode
     * @param string $busTypeCode
     */
    public function __construct($busNumber = null, $networkCode = null, $busTypeCode = null)
    {
        $this
            ->setBusNumber($busNumber)
            ->setNetworkCode($networkCode)
            ->setBusTypeCode($busTypeCode);
    }
    /**
     * Get BusNumber value
     * @return string|null
     */
    public function getBusNumber()
    {
        return $this->BusNumber;
    }
    /**
     * Set BusNumber value
     * @param string $busNumber
     * @return \StructType\BusIdentificationType
     */
    public function setBusNumber($busNumber = null)
    {
        // validation for constraint: string
        if (!is_null($busNumber) && !is_string($busNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($busNumber, true), gettype($busNumber)), __LINE__);
        }
        // validation for constraint: maxLength(8)
        if (!is_null($busNumber) && mb_strlen($busNumber) > 8) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 8', mb_strlen($busNumber)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($busNumber) && mb_strlen($busNumber) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($busNumber)), __LINE__);
        }
        $this->BusNumber = $busNumber;
        return $this;
    }
    /**
     * Get NetworkCode value
     * @return mixed|null
     */
    public function getNetworkCode()
    {
        return $this->NetworkCode;
    }
    /**
     * Set NetworkCode value
     * @param mixed $networkCode
     * @return \StructType\BusIdentificationType
     */
    public function setNetworkCode($networkCode = null)
    {
        $this->NetworkCode = $networkCode;
        return $this;
    }
    /**
     * Get BusTypeCode value
     * @return string|null
     */
    public function getBusTypeCode()
    {
        return $this->BusTypeCode;
    }
    /**
     * Set BusTypeCode value
     * @param string $busTypeCode
     * @return \StructType\BusIdentificationType
     */
    public function setBusTypeCode($busTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($busTypeCode) && !is_string($busTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($busTypeCode, true), gettype($busTypeCode)), __LINE__);
        }
        $this->BusTypeCode = $busTypeCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BusIdentificationType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
