<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingRule StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines when block inventory is released back to general inventory. | Used to specify a rate plan code, room type code or rate plan/room type combination code and its associated attributes. | The BookingRule element defines
 * restrictions to rates and stays at the hotel for a given rate plan, room type or rate plan/room type combination.
 * @subpackage Structs
 */
class BookingRule extends AbstractStructBase
{
    /**
     * The AcceptableGuarantees
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AcceptableGuarantees
     */
    public $AcceptableGuarantees;
    /**
     * The CancelPenalties
     * Meta information extracted from the WSDL
     * - documentation: A collection of required payments that are part of the booking restriction.
     * - minOccurs: 0
     * @var mixed
     */
    public $CancelPenalties;
    /**
     * The RequiredPaymts
     * Meta information extracted from the WSDL
     * - documentation: A collection of required payments that are part of the booking restriction.
     * - minOccurs: 0
     * @var mixed
     */
    public $RequiredPaymts;
    /**
     * The LengthsOfStay
     * Meta information extracted from the WSDL
     * - documentation: A collection of lengths of stay.
     * - minOccurs: 0
     * @var mixed
     */
    public $LengthsOfStay;
    /**
     * The DOW_Restrictions
     * Meta information extracted from the WSDL
     * - documentation: A collection of Day Of Week restrictions.
     * - minOccurs: 0
     * @var mixed
     */
    public $DOW_Restrictions;
    /**
     * The RestrictionStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\RestrictionStatus
     */
    public $RestrictionStatus;
    /**
     * The Viewerships
     * Meta information extracted from the WSDL
     * - documentation: A collection of Viewships.
     * - minOccurs: 0
     * @var mixed
     */
    public $Viewerships;
    /**
     * The AddtionalRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AddtionalRules
     */
    public $AddtionalRules;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: General description of booking rule.
     * - maxOccurs: 20
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Description;
    /**
     * The UniqueID
     * Meta information extracted from the WSDL
     * - documentation: The unique identifier element allows the trading partners to uniquely identify each Booking Rule, for transaction tracability.
     * - minOccurs: 0
     * @var mixed
     */
    public $UniqueID;
    /**
     * The CheckoutCharge
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\CheckoutCharge[]
     */
    public $CheckoutCharge;
    /**
     * The MaxAdvancedBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: Maximum days before the arrival date for which this rate plan may be booked.
     * - use: optional
     * @var string
     */
    public $MaxAdvancedBookingOffset;
    /**
     * The MinAdvancedBookingOffset
     * Meta information extracted from the WSDL
     * - documentation: Minimum days before the arrival date for which this rate plan may be booked.
     * - use: optional
     * @var string
     */
    public $MinAdvancedBookingOffset;
    /**
     * The ForceGuaranteeOffset
     * Meta information extracted from the WSDL
     * - documentation: Number of days prior to arrival date at which a guarantee is required.
     * - use: optional
     * @var string
     */
    public $ForceGuaranteeOffset;
    /**
     * The DepositWaiverOffset
     * Meta information extracted from the WSDL
     * - documentation: Number of days prior to arrival date for which a deposit is no longer accepted (because of a too short time delay between reservation and guest arrival).
     * - use: optional
     * @var string
     */
    public $DepositWaiverOffset;
    /**
     * The MinTotalOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Defines the minimum number of total occupants required for a rate plan.
     * - use: optional
     * @var int
     */
    public $MinTotalOccupancy;
    /**
     * The MaxTotalOccupancy
     * Meta information extracted from the WSDL
     * - documentation: Defines the maximum number of total occupants allowed for a rate plan.
     * - use: optional
     * @var int
     */
    public $MaxTotalOccupancy;
    /**
     * The AbsoluteDropTime
     * Meta information extracted from the WSDL
     * - documentation: The fixed time that the booking restriction goes into effect to cancel the non-guaranteed reservation. Either this attribute or the DropTimeOffset element may be used.
     * - use: optional
     * @var string
     */
    public $AbsoluteDropTime;
    /**
     * The GenerallyBookable
     * Meta information extracted from the WSDL
     * - documentation: Indicates whether this rate plan can be booked by those not in the viewership collection. If this attribute is False (0), then the viewerships collection lists those who have view-only or bookable status for this rate plan. If this
     * attribute is True (1), then the viewerships collection lists those who have view-only or not-viewable status for this rate plan.
     * - use: optional
     * @var bool
     */
    public $GenerallyBookable;
    /**
     * The PriceViewable
     * Meta information extracted from the WSDL
     * - documentation: Valid values: 0 = (No) Price Not Viewable, 1 = (Yes) Price Viewable. | Indicates whether the price for this rate plan can be viewed, or whether the guest must contact another entity to obtain price information.
     * - use: optional
     * @var bool
     */
    public $PriceViewable;
    /**
     * The QualifiedRateYN
     * Meta information extracted from the WSDL
     * - documentation: Boolean value indicating whether a specific rate plan must be qualified prior to inclusion in availability response messages.
     * - use: optional
     * @var bool
     */
    public $QualifiedRateYN;
    /**
     * The AddressRequired
     * Meta information extracted from the WSDL
     * - documentation: An address is required to complete the booking.
     * - use: optional
     * @var bool
     */
    public $AddressRequired;
    /**
     * The MaxContiguousBookings
     * Meta information extracted from the WSDL
     * - documentation: The maximum number of times a rate may be booked contiguously within a reservation (often used with packages).
     * - use: optional
     * @var int
     */
    public $MaxContiguousBookings;
    /**
     * Constructor method for BookingRule
     * @uses BookingRule::setAcceptableGuarantees()
     * @uses BookingRule::setCancelPenalties()
     * @uses BookingRule::setRequiredPaymts()
     * @uses BookingRule::setLengthsOfStay()
     * @uses BookingRule::setDOW_Restrictions()
     * @uses BookingRule::setRestrictionStatus()
     * @uses BookingRule::setViewerships()
     * @uses BookingRule::setAddtionalRules()
     * @uses BookingRule::setDescription()
     * @uses BookingRule::setUniqueID()
     * @uses BookingRule::setCheckoutCharge()
     * @uses BookingRule::setMaxAdvancedBookingOffset()
     * @uses BookingRule::setMinAdvancedBookingOffset()
     * @uses BookingRule::setForceGuaranteeOffset()
     * @uses BookingRule::setDepositWaiverOffset()
     * @uses BookingRule::setMinTotalOccupancy()
     * @uses BookingRule::setMaxTotalOccupancy()
     * @uses BookingRule::setAbsoluteDropTime()
     * @uses BookingRule::setGenerallyBookable()
     * @uses BookingRule::setPriceViewable()
     * @uses BookingRule::setQualifiedRateYN()
     * @uses BookingRule::setAddressRequired()
     * @uses BookingRule::setMaxContiguousBookings()
     * @param \StructType\AcceptableGuarantees $acceptableGuarantees
     * @param mixed $cancelPenalties
     * @param mixed $requiredPaymts
     * @param mixed $lengthsOfStay
     * @param mixed $dOW_Restrictions
     * @param \StructType\RestrictionStatus $restrictionStatus
     * @param mixed $viewerships
     * @param \StructType\AddtionalRules $addtionalRules
     * @param mixed[] $description
     * @param mixed $uniqueID
     * @param \StructType\CheckoutCharge[] $checkoutCharge
     * @param string $maxAdvancedBookingOffset
     * @param string $minAdvancedBookingOffset
     * @param string $forceGuaranteeOffset
     * @param string $depositWaiverOffset
     * @param int $minTotalOccupancy
     * @param int $maxTotalOccupancy
     * @param string $absoluteDropTime
     * @param bool $generallyBookable
     * @param bool $priceViewable
     * @param bool $qualifiedRateYN
     * @param bool $addressRequired
     * @param int $maxContiguousBookings
     */
    public function __construct(\StructType\AcceptableGuarantees $acceptableGuarantees = null, $cancelPenalties = null, $requiredPaymts = null, $lengthsOfStay = null, $dOW_Restrictions = null, \StructType\RestrictionStatus $restrictionStatus = null, $viewerships = null, \StructType\AddtionalRules $addtionalRules = null, array $description = array(), $uniqueID = null, array $checkoutCharge = array(), $maxAdvancedBookingOffset = null, $minAdvancedBookingOffset = null, $forceGuaranteeOffset = null, $depositWaiverOffset = null, $minTotalOccupancy = null, $maxTotalOccupancy = null, $absoluteDropTime = null, $generallyBookable = null, $priceViewable = null, $qualifiedRateYN = null, $addressRequired = null, $maxContiguousBookings = null)
    {
        $this
            ->setAcceptableGuarantees($acceptableGuarantees)
            ->setCancelPenalties($cancelPenalties)
            ->setRequiredPaymts($requiredPaymts)
            ->setLengthsOfStay($lengthsOfStay)
            ->setDOW_Restrictions($dOW_Restrictions)
            ->setRestrictionStatus($restrictionStatus)
            ->setViewerships($viewerships)
            ->setAddtionalRules($addtionalRules)
            ->setDescription($description)
            ->setUniqueID($uniqueID)
            ->setCheckoutCharge($checkoutCharge)
            ->setMaxAdvancedBookingOffset($maxAdvancedBookingOffset)
            ->setMinAdvancedBookingOffset($minAdvancedBookingOffset)
            ->setForceGuaranteeOffset($forceGuaranteeOffset)
            ->setDepositWaiverOffset($depositWaiverOffset)
            ->setMinTotalOccupancy($minTotalOccupancy)
            ->setMaxTotalOccupancy($maxTotalOccupancy)
            ->setAbsoluteDropTime($absoluteDropTime)
            ->setGenerallyBookable($generallyBookable)
            ->setPriceViewable($priceViewable)
            ->setQualifiedRateYN($qualifiedRateYN)
            ->setAddressRequired($addressRequired)
            ->setMaxContiguousBookings($maxContiguousBookings);
    }
    /**
     * Get AcceptableGuarantees value
     * @return \StructType\AcceptableGuarantees|null
     */
    public function getAcceptableGuarantees()
    {
        return $this->AcceptableGuarantees;
    }
    /**
     * Set AcceptableGuarantees value
     * @param \StructType\AcceptableGuarantees $acceptableGuarantees
     * @return \StructType\BookingRule
     */
    public function setAcceptableGuarantees(\StructType\AcceptableGuarantees $acceptableGuarantees = null)
    {
        $this->AcceptableGuarantees = $acceptableGuarantees;
        return $this;
    }
    /**
     * Get CancelPenalties value
     * @return mixed|null
     */
    public function getCancelPenalties()
    {
        return $this->CancelPenalties;
    }
    /**
     * Set CancelPenalties value
     * @param mixed $cancelPenalties
     * @return \StructType\BookingRule
     */
    public function setCancelPenalties($cancelPenalties = null)
    {
        $this->CancelPenalties = $cancelPenalties;
        return $this;
    }
    /**
     * Get RequiredPaymts value
     * @return mixed|null
     */
    public function getRequiredPaymts()
    {
        return $this->RequiredPaymts;
    }
    /**
     * Set RequiredPaymts value
     * @param mixed $requiredPaymts
     * @return \StructType\BookingRule
     */
    public function setRequiredPaymts($requiredPaymts = null)
    {
        $this->RequiredPaymts = $requiredPaymts;
        return $this;
    }
    /**
     * Get LengthsOfStay value
     * @return mixed|null
     */
    public function getLengthsOfStay()
    {
        return $this->LengthsOfStay;
    }
    /**
     * Set LengthsOfStay value
     * @param mixed $lengthsOfStay
     * @return \StructType\BookingRule
     */
    public function setLengthsOfStay($lengthsOfStay = null)
    {
        $this->LengthsOfStay = $lengthsOfStay;
        return $this;
    }
    /**
     * Get DOW_Restrictions value
     * @return mixed|null
     */
    public function getDOW_Restrictions()
    {
        return $this->DOW_Restrictions;
    }
    /**
     * Set DOW_Restrictions value
     * @param mixed $dOW_Restrictions
     * @return \StructType\BookingRule
     */
    public function setDOW_Restrictions($dOW_Restrictions = null)
    {
        $this->DOW_Restrictions = $dOW_Restrictions;
        return $this;
    }
    /**
     * Get RestrictionStatus value
     * @return \StructType\RestrictionStatus|null
     */
    public function getRestrictionStatus()
    {
        return $this->RestrictionStatus;
    }
    /**
     * Set RestrictionStatus value
     * @param \StructType\RestrictionStatus $restrictionStatus
     * @return \StructType\BookingRule
     */
    public function setRestrictionStatus(\StructType\RestrictionStatus $restrictionStatus = null)
    {
        $this->RestrictionStatus = $restrictionStatus;
        return $this;
    }
    /**
     * Get Viewerships value
     * @return mixed|null
     */
    public function getViewerships()
    {
        return $this->Viewerships;
    }
    /**
     * Set Viewerships value
     * @param mixed $viewerships
     * @return \StructType\BookingRule
     */
    public function setViewerships($viewerships = null)
    {
        $this->Viewerships = $viewerships;
        return $this;
    }
    /**
     * Get AddtionalRules value
     * @return \StructType\AddtionalRules|null
     */
    public function getAddtionalRules()
    {
        return $this->AddtionalRules;
    }
    /**
     * Set AddtionalRules value
     * @param \StructType\AddtionalRules $addtionalRules
     * @return \StructType\BookingRule
     */
    public function setAddtionalRules(\StructType\AddtionalRules $addtionalRules = null)
    {
        $this->AddtionalRules = $addtionalRules;
        return $this;
    }
    /**
     * Get Description value
     * @return mixed[]|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * This method is responsible for validating the values passed to the setDescription method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDescription method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDescriptionForArrayConstraintsFromSetDescription(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingRuleDescriptionItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($bookingRuleDescriptionItem) ? get_class($bookingRuleDescriptionItem) : sprintf('%s(%s)', gettype($bookingRuleDescriptionItem), var_export($bookingRuleDescriptionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Description property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Description value
     * @throws \InvalidArgumentException
     * @param mixed[] $description
     * @return \StructType\BookingRule
     */
    public function setDescription(array $description = array())
    {
        // validation for constraint: array
        if ('' !== ($descriptionArrayErrorMessage = self::validateDescriptionForArrayConstraintsFromSetDescription($description))) {
            throw new \InvalidArgumentException($descriptionArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($description) && count($description) > 20) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 20', count($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Add item to Description value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\BookingRule
     */
    public function addToDescription($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Description property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(20)
        if (is_array($this->Description) && count($this->Description) >= 20) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 20', count($this->Description)), __LINE__);
        }
        $this->Description[] = $item;
        return $this;
    }
    /**
     * Get UniqueID value
     * @return mixed|null
     */
    public function getUniqueID()
    {
        return $this->UniqueID;
    }
    /**
     * Set UniqueID value
     * @param mixed $uniqueID
     * @return \StructType\BookingRule
     */
    public function setUniqueID($uniqueID = null)
    {
        $this->UniqueID = $uniqueID;
        return $this;
    }
    /**
     * Get CheckoutCharge value
     * @return \StructType\CheckoutCharge[]|null
     */
    public function getCheckoutCharge()
    {
        return $this->CheckoutCharge;
    }
    /**
     * This method is responsible for validating the values passed to the setCheckoutCharge method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCheckoutCharge method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCheckoutChargeForArrayConstraintsFromSetCheckoutCharge(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingRuleCheckoutChargeItem) {
            // validation for constraint: itemType
            if (!$bookingRuleCheckoutChargeItem instanceof \StructType\CheckoutCharge) {
                $invalidValues[] = is_object($bookingRuleCheckoutChargeItem) ? get_class($bookingRuleCheckoutChargeItem) : sprintf('%s(%s)', gettype($bookingRuleCheckoutChargeItem), var_export($bookingRuleCheckoutChargeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CheckoutCharge property can only contain items of type \StructType\CheckoutCharge, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CheckoutCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckoutCharge[] $checkoutCharge
     * @return \StructType\BookingRule
     */
    public function setCheckoutCharge(array $checkoutCharge = array())
    {
        // validation for constraint: array
        if ('' !== ($checkoutChargeArrayErrorMessage = self::validateCheckoutChargeForArrayConstraintsFromSetCheckoutCharge($checkoutCharge))) {
            throw new \InvalidArgumentException($checkoutChargeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($checkoutCharge) && count($checkoutCharge) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($checkoutCharge)), __LINE__);
        }
        $this->CheckoutCharge = $checkoutCharge;
        return $this;
    }
    /**
     * Add item to CheckoutCharge value
     * @throws \InvalidArgumentException
     * @param \StructType\CheckoutCharge $item
     * @return \StructType\BookingRule
     */
    public function addToCheckoutCharge(\StructType\CheckoutCharge $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CheckoutCharge) {
            throw new \InvalidArgumentException(sprintf('The CheckoutCharge property can only contain items of type \StructType\CheckoutCharge, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->CheckoutCharge) && count($this->CheckoutCharge) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->CheckoutCharge)), __LINE__);
        }
        $this->CheckoutCharge[] = $item;
        return $this;
    }
    /**
     * Get MaxAdvancedBookingOffset value
     * @return string|null
     */
    public function getMaxAdvancedBookingOffset()
    {
        return $this->MaxAdvancedBookingOffset;
    }
    /**
     * Set MaxAdvancedBookingOffset value
     * @param string $maxAdvancedBookingOffset
     * @return \StructType\BookingRule
     */
    public function setMaxAdvancedBookingOffset($maxAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($maxAdvancedBookingOffset) && !is_string($maxAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maxAdvancedBookingOffset, true), gettype($maxAdvancedBookingOffset)), __LINE__);
        }
        $this->MaxAdvancedBookingOffset = $maxAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get MinAdvancedBookingOffset value
     * @return string|null
     */
    public function getMinAdvancedBookingOffset()
    {
        return $this->MinAdvancedBookingOffset;
    }
    /**
     * Set MinAdvancedBookingOffset value
     * @param string $minAdvancedBookingOffset
     * @return \StructType\BookingRule
     */
    public function setMinAdvancedBookingOffset($minAdvancedBookingOffset = null)
    {
        // validation for constraint: string
        if (!is_null($minAdvancedBookingOffset) && !is_string($minAdvancedBookingOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($minAdvancedBookingOffset, true), gettype($minAdvancedBookingOffset)), __LINE__);
        }
        $this->MinAdvancedBookingOffset = $minAdvancedBookingOffset;
        return $this;
    }
    /**
     * Get ForceGuaranteeOffset value
     * @return string|null
     */
    public function getForceGuaranteeOffset()
    {
        return $this->ForceGuaranteeOffset;
    }
    /**
     * Set ForceGuaranteeOffset value
     * @param string $forceGuaranteeOffset
     * @return \StructType\BookingRule
     */
    public function setForceGuaranteeOffset($forceGuaranteeOffset = null)
    {
        // validation for constraint: string
        if (!is_null($forceGuaranteeOffset) && !is_string($forceGuaranteeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forceGuaranteeOffset, true), gettype($forceGuaranteeOffset)), __LINE__);
        }
        $this->ForceGuaranteeOffset = $forceGuaranteeOffset;
        return $this;
    }
    /**
     * Get DepositWaiverOffset value
     * @return string|null
     */
    public function getDepositWaiverOffset()
    {
        return $this->DepositWaiverOffset;
    }
    /**
     * Set DepositWaiverOffset value
     * @param string $depositWaiverOffset
     * @return \StructType\BookingRule
     */
    public function setDepositWaiverOffset($depositWaiverOffset = null)
    {
        // validation for constraint: string
        if (!is_null($depositWaiverOffset) && !is_string($depositWaiverOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositWaiverOffset, true), gettype($depositWaiverOffset)), __LINE__);
        }
        $this->DepositWaiverOffset = $depositWaiverOffset;
        return $this;
    }
    /**
     * Get MinTotalOccupancy value
     * @return int|null
     */
    public function getMinTotalOccupancy()
    {
        return $this->MinTotalOccupancy;
    }
    /**
     * Set MinTotalOccupancy value
     * @param int $minTotalOccupancy
     * @return \StructType\BookingRule
     */
    public function setMinTotalOccupancy($minTotalOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($minTotalOccupancy) && !(is_int($minTotalOccupancy) || ctype_digit($minTotalOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minTotalOccupancy, true), gettype($minTotalOccupancy)), __LINE__);
        }
        $this->MinTotalOccupancy = $minTotalOccupancy;
        return $this;
    }
    /**
     * Get MaxTotalOccupancy value
     * @return int|null
     */
    public function getMaxTotalOccupancy()
    {
        return $this->MaxTotalOccupancy;
    }
    /**
     * Set MaxTotalOccupancy value
     * @param int $maxTotalOccupancy
     * @return \StructType\BookingRule
     */
    public function setMaxTotalOccupancy($maxTotalOccupancy = null)
    {
        // validation for constraint: int
        if (!is_null($maxTotalOccupancy) && !(is_int($maxTotalOccupancy) || ctype_digit($maxTotalOccupancy))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTotalOccupancy, true), gettype($maxTotalOccupancy)), __LINE__);
        }
        $this->MaxTotalOccupancy = $maxTotalOccupancy;
        return $this;
    }
    /**
     * Get AbsoluteDropTime value
     * @return string|null
     */
    public function getAbsoluteDropTime()
    {
        return $this->AbsoluteDropTime;
    }
    /**
     * Set AbsoluteDropTime value
     * @param string $absoluteDropTime
     * @return \StructType\BookingRule
     */
    public function setAbsoluteDropTime($absoluteDropTime = null)
    {
        // validation for constraint: string
        if (!is_null($absoluteDropTime) && !is_string($absoluteDropTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($absoluteDropTime, true), gettype($absoluteDropTime)), __LINE__);
        }
        $this->AbsoluteDropTime = $absoluteDropTime;
        return $this;
    }
    /**
     * Get GenerallyBookable value
     * @return bool|null
     */
    public function getGenerallyBookable()
    {
        return $this->GenerallyBookable;
    }
    /**
     * Set GenerallyBookable value
     * @param bool $generallyBookable
     * @return \StructType\BookingRule
     */
    public function setGenerallyBookable($generallyBookable = null)
    {
        // validation for constraint: boolean
        if (!is_null($generallyBookable) && !is_bool($generallyBookable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generallyBookable, true), gettype($generallyBookable)), __LINE__);
        }
        $this->GenerallyBookable = $generallyBookable;
        return $this;
    }
    /**
     * Get PriceViewable value
     * @return bool|null
     */
    public function getPriceViewable()
    {
        return $this->PriceViewable;
    }
    /**
     * Set PriceViewable value
     * @param bool $priceViewable
     * @return \StructType\BookingRule
     */
    public function setPriceViewable($priceViewable = null)
    {
        // validation for constraint: boolean
        if (!is_null($priceViewable) && !is_bool($priceViewable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($priceViewable, true), gettype($priceViewable)), __LINE__);
        }
        $this->PriceViewable = $priceViewable;
        return $this;
    }
    /**
     * Get QualifiedRateYN value
     * @return bool|null
     */
    public function getQualifiedRateYN()
    {
        return $this->QualifiedRateYN;
    }
    /**
     * Set QualifiedRateYN value
     * @param bool $qualifiedRateYN
     * @return \StructType\BookingRule
     */
    public function setQualifiedRateYN($qualifiedRateYN = null)
    {
        // validation for constraint: boolean
        if (!is_null($qualifiedRateYN) && !is_bool($qualifiedRateYN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($qualifiedRateYN, true), gettype($qualifiedRateYN)), __LINE__);
        }
        $this->QualifiedRateYN = $qualifiedRateYN;
        return $this;
    }
    /**
     * Get AddressRequired value
     * @return bool|null
     */
    public function getAddressRequired()
    {
        return $this->AddressRequired;
    }
    /**
     * Set AddressRequired value
     * @param bool $addressRequired
     * @return \StructType\BookingRule
     */
    public function setAddressRequired($addressRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($addressRequired) && !is_bool($addressRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($addressRequired, true), gettype($addressRequired)), __LINE__);
        }
        $this->AddressRequired = $addressRequired;
        return $this;
    }
    /**
     * Get MaxContiguousBookings value
     * @return int|null
     */
    public function getMaxContiguousBookings()
    {
        return $this->MaxContiguousBookings;
    }
    /**
     * Set MaxContiguousBookings value
     * @param int $maxContiguousBookings
     * @return \StructType\BookingRule
     */
    public function setMaxContiguousBookings($maxContiguousBookings = null)
    {
        // validation for constraint: int
        if (!is_null($maxContiguousBookings) && !(is_int($maxContiguousBookings) || ctype_digit($maxContiguousBookings))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxContiguousBookings, true), gettype($maxContiguousBookings)), __LINE__);
        }
        $this->MaxContiguousBookings = $maxContiguousBookings;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
