<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BookingPrices StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies the booking prices for the booking.
 * @subpackage Structs
 */
class BookingPrices extends AbstractStructBase
{
    /**
     * The BookingPrice
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\BookingPrice[]
     */
    public $BookingPrice;
    /**
     * Constructor method for BookingPrices
     * @uses BookingPrices::setBookingPrice()
     * @param \StructType\BookingPrice[] $bookingPrice
     */
    public function __construct(array $bookingPrice = array())
    {
        $this
            ->setBookingPrice($bookingPrice);
    }
    /**
     * Get BookingPrice value
     * @return \StructType\BookingPrice[]|null
     */
    public function getBookingPrice()
    {
        return $this->BookingPrice;
    }
    /**
     * This method is responsible for validating the values passed to the setBookingPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBookingPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBookingPriceForArrayConstraintsFromSetBookingPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bookingPricesBookingPriceItem) {
            // validation for constraint: itemType
            if (!$bookingPricesBookingPriceItem instanceof \StructType\BookingPrice) {
                $invalidValues[] = is_object($bookingPricesBookingPriceItem) ? get_class($bookingPricesBookingPriceItem) : sprintf('%s(%s)', gettype($bookingPricesBookingPriceItem), var_export($bookingPricesBookingPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BookingPrice property can only contain items of type \StructType\BookingPrice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BookingPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingPrice[] $bookingPrice
     * @return \StructType\BookingPrices
     */
    public function setBookingPrice(array $bookingPrice = array())
    {
        // validation for constraint: array
        if ('' !== ($bookingPriceArrayErrorMessage = self::validateBookingPriceForArrayConstraintsFromSetBookingPrice($bookingPrice))) {
            throw new \InvalidArgumentException($bookingPriceArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($bookingPrice) && count($bookingPrice) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($bookingPrice)), __LINE__);
        }
        $this->BookingPrice = $bookingPrice;
        return $this;
    }
    /**
     * Add item to BookingPrice value
     * @throws \InvalidArgumentException
     * @param \StructType\BookingPrice $item
     * @return \StructType\BookingPrices
     */
    public function addToBookingPrice(\StructType\BookingPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BookingPrice) {
            throw new \InvalidArgumentException(sprintf('The BookingPrice property can only contain items of type \StructType\BookingPrice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->BookingPrice) && count($this->BookingPrice) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->BookingPrice)), __LINE__);
        }
        $this->BookingPrice[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BookingPrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
