<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingInstructionType StructType
 * Meta information extracted from the WSDL
 * - documentation: Date and time for which the billing instruction applies. | Hotel billing instructions definition.
 * @subpackage Structs
 */
class BillingInstructionType extends AbstractStructBase
{
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the individual billing code that applies to a set of instructions that are routed to a designated folio. | Example: FOODBEV21 | Billing code.
     * - use: required
     * @var string
     */
    public $Code;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Note: This is a string list of enumerations with an "Other_" literal to support an open enumeration list. Use the "Other_" value in combination with the @extension attribute to exchange a literal that is not in the list and is known
     * to your trading partners. | Example: Corporate | Billing code type.
     * - minOccurs: 0
     * @var mixed
     */
    public $Type;
    /**
     * The AuthorizationCode
     * Meta information extracted from the WSDL
     * - documentation: Note: This is an authorization code that is associated with the billing code. | Example: AC201301 | Associated authorization code.
     * - use: optional
     * @var string
     */
    public $AuthorizationCode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - documentation: Note: This short description may describe the billing code or billing instructions. | Example: Food/Beverage | Short description.
     * - use: optional
     * @var string
     */
    public $Description;
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - documentation: Example: IBM2099 | Charge routing account number.
     * - use: optional
     * @var string
     */
    public $AccountNumber;
    /**
     * Constructor method for BillingInstructionType
     * @uses BillingInstructionType::setCode()
     * @uses BillingInstructionType::setType()
     * @uses BillingInstructionType::setAuthorizationCode()
     * @uses BillingInstructionType::setDescription()
     * @uses BillingInstructionType::setAccountNumber()
     * @param string $code
     * @param mixed $type
     * @param string $authorizationCode
     * @param string $description
     * @param string $accountNumber
     */
    public function __construct($code = null, $type = null, $authorizationCode = null, $description = null, $accountNumber = null)
    {
        $this
            ->setCode($code)
            ->setType($type)
            ->setAuthorizationCode($authorizationCode)
            ->setDescription($description)
            ->setAccountNumber($accountNumber);
    }
    /**
     * Get Code value
     * @return string
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\BillingInstructionType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Type value
     * @return mixed|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param mixed $type
     * @return \StructType\BillingInstructionType
     */
    public function setType($type = null)
    {
        $this->Type = $type;
        return $this;
    }
    /**
     * Get AuthorizationCode value
     * @return string|null
     */
    public function getAuthorizationCode()
    {
        return $this->AuthorizationCode;
    }
    /**
     * Set AuthorizationCode value
     * @param string $authorizationCode
     * @return \StructType\BillingInstructionType
     */
    public function setAuthorizationCode($authorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationCode) && !is_string($authorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationCode, true), gettype($authorizationCode)), __LINE__);
        }
        $this->AuthorizationCode = $authorizationCode;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\BillingInstructionType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\BillingInstructionType
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingInstructionType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
