<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingAccountName StructType
 * Meta information extracted from the WSDL
 * - documentation: The name of the Billing Account for which the voucher has been issued.
 * @subpackage Structs
 */
class BillingAccountName extends CompanyNameType
{
    /**
     * The ContactName
     * Meta information extracted from the WSDL
     * - documentation: This may be used to pass the name of the contact at the company for which the voucher has been issued.
     * @var string
     */
    public $ContactName;
    /**
     * Constructor method for BillingAccountName
     * @uses BillingAccountName::setContactName()
     * @param string $contactName
     */
    public function __construct($contactName = null)
    {
        $this
            ->setContactName($contactName);
    }
    /**
     * Get ContactName value
     * @return string|null
     */
    public function getContactName()
    {
        return $this->ContactName;
    }
    /**
     * Set ContactName value
     * @param string $contactName
     * @return \StructType\BillingAccountName
     */
    public function setContactName($contactName = null)
    {
        // validation for constraint: string
        if (!is_null($contactName) && !is_string($contactName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactName, true), gettype($contactName)), __LINE__);
        }
        $this->ContactName = $contactName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingAccountName
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
