<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseFare StructType
 * Meta information extracted from the WSDL
 * - documentation: Price of the inventory excluding taxes and fees. | Used to specify the base, base net, or base sell fare. | Used to specify the base fare, the base fare net and the base fare sell amounts.
 * @subpackage Structs
 */
class BaseFare extends AbstractStructBase
{
    /**
     * The Purpose
     * Meta information extracted from the WSDL
     * - documentation: Used to specify if just base or base fare net or base fare sell.
     * - use: optional
     * @var string
     */
    public $Purpose;
    /**
     * The FareAmountType
     * Meta information extracted from the WSDL
     * - documentation: Used to specify if ticket amount is bulk, IT, or NOADC. | Used to specify if ticket fare is bulk ticket, inclusive tour, or no additional charge.
     * - use: optional
     * @var string
     */
    public $FareAmountType;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * Constructor method for BaseFare
     * @uses BaseFare::setPurpose()
     * @uses BaseFare::setFareAmountType()
     * @uses BaseFare::setOperation()
     * @param string $purpose
     * @param string $fareAmountType
     * @param string $operation
     */
    public function __construct($purpose = null, $fareAmountType = null, $operation = null)
    {
        $this
            ->setPurpose($purpose)
            ->setFareAmountType($fareAmountType)
            ->setOperation($operation);
    }
    /**
     * Get Purpose value
     * @return string|null
     */
    public function getPurpose()
    {
        return $this->Purpose;
    }
    /**
     * Set Purpose value
     * @uses \EnumType\PurposeType::valueIsValid()
     * @uses \EnumType\PurposeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $purpose
     * @return \StructType\BaseFare
     */
    public function setPurpose($purpose = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PurposeType::valueIsValid($purpose)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PurposeType', is_array($purpose) ? implode(', ', $purpose) : var_export($purpose, true), implode(', ', \EnumType\PurposeType::getValidValues())), __LINE__);
        }
        $this->Purpose = $purpose;
        return $this;
    }
    /**
     * Get FareAmountType value
     * @return string|null
     */
    public function getFareAmountType()
    {
        return $this->FareAmountType;
    }
    /**
     * Set FareAmountType value
     * @uses \EnumType\FareAmountType::valueIsValid()
     * @uses \EnumType\FareAmountType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fareAmountType
     * @return \StructType\BaseFare
     */
    public function setFareAmountType($fareAmountType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FareAmountType::valueIsValid($fareAmountType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FareAmountType', is_array($fareAmountType) ? implode(', ', $fareAmountType) : var_export($fareAmountType, true), implode(', ', \EnumType\FareAmountType::getValidValues())), __LINE__);
        }
        $this->FareAmountType = $fareAmountType;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\BaseFare
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseFare
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
