<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Awards StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Award elements.
 * @subpackage Structs
 */
class Awards extends AbstractStructBase
{
    /**
     * The Award
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Award[]
     */
    public $Award;
    /**
     * Constructor method for Awards
     * @uses Awards::setAward()
     * @param \StructType\Award[] $award
     */
    public function __construct(array $award = array())
    {
        $this
            ->setAward($award);
    }
    /**
     * Get Award value
     * @return \StructType\Award[]|null
     */
    public function getAward()
    {
        return $this->Award;
    }
    /**
     * This method is responsible for validating the values passed to the setAward method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAward method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAwardForArrayConstraintsFromSetAward(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $awardsAwardItem) {
            // validation for constraint: itemType
            if (!$awardsAwardItem instanceof \StructType\Award) {
                $invalidValues[] = is_object($awardsAwardItem) ? get_class($awardsAwardItem) : sprintf('%s(%s)', gettype($awardsAwardItem), var_export($awardsAwardItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award[] $award
     * @return \StructType\Awards
     */
    public function setAward(array $award = array())
    {
        // validation for constraint: array
        if ('' !== ($awardArrayErrorMessage = self::validateAwardForArrayConstraintsFromSetAward($award))) {
            throw new \InvalidArgumentException($awardArrayErrorMessage, __LINE__);
        }
        $this->Award = $award;
        return $this;
    }
    /**
     * Add item to Award value
     * @throws \InvalidArgumentException
     * @param \StructType\Award $item
     * @return \StructType\Awards
     */
    public function addToAward(\StructType\Award $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Award) {
            throw new \InvalidArgumentException(sprintf('The Award property can only contain items of type \StructType\Award, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Award[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Awards
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
