<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Availability StructType
 * Meta information extracted from the WSDL
 * - documentation: Provides information on the availability of the room rate.
 * @subpackage Structs
 */
class Availability extends AbstractStructBase
{
    /**
     * The AvailabilityStatus
     * Meta information extracted from the WSDL
     * - documentation: Used to specify an availability status for the room rate.
     * - use: optional
     * @var string
     */
    public $AvailabilityStatus;
    /**
     * Constructor method for Availability
     * @uses Availability::setAvailabilityStatus()
     * @param string $availabilityStatus
     */
    public function __construct($availabilityStatus = null)
    {
        $this
            ->setAvailabilityStatus($availabilityStatus);
    }
    /**
     * Get AvailabilityStatus value
     * @return string|null
     */
    public function getAvailabilityStatus()
    {
        return $this->AvailabilityStatus;
    }
    /**
     * Set AvailabilityStatus value
     * @uses \EnumType\RateIndicatorType::valueIsValid()
     * @uses \EnumType\RateIndicatorType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $availabilityStatus
     * @return \StructType\Availability
     */
    public function setAvailabilityStatus($availabilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RateIndicatorType::valueIsValid($availabilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RateIndicatorType', is_array($availabilityStatus) ? implode(', ', $availabilityStatus) : var_export($availabilityStatus, true), implode(', ', \EnumType\RateIndicatorType::getValidValues())), __LINE__);
        }
        $this->AvailabilityStatus = $availabilityStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Availability
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
