<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AreasType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines an area determined by the reservation system.
 * @subpackage Structs
 */
class AreasType extends AbstractStructBase
{
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * @var \StructType\Area[]
     */
    public $Area;
    /**
     * Constructor method for AreasType
     * @uses AreasType::setArea()
     * @param \StructType\Area[] $area
     */
    public function __construct(array $area = array())
    {
        $this
            ->setArea($area);
    }
    /**
     * Get Area value
     * @return \StructType\Area[]|null
     */
    public function getArea()
    {
        return $this->Area;
    }
    /**
     * This method is responsible for validating the values passed to the setArea method
     * This method is willingly generated in order to preserve the one-line inline validation within the setArea method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAreaForArrayConstraintsFromSetArea(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $areasTypeAreaItem) {
            // validation for constraint: itemType
            if (!$areasTypeAreaItem instanceof \StructType\Area) {
                $invalidValues[] = is_object($areasTypeAreaItem) ? get_class($areasTypeAreaItem) : sprintf('%s(%s)', gettype($areasTypeAreaItem), var_export($areasTypeAreaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Area property can only contain items of type \StructType\Area, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Area value
     * @throws \InvalidArgumentException
     * @param \StructType\Area[] $area
     * @return \StructType\AreasType
     */
    public function setArea(array $area = array())
    {
        // validation for constraint: array
        if ('' !== ($areaArrayErrorMessage = self::validateAreaForArrayConstraintsFromSetArea($area))) {
            throw new \InvalidArgumentException($areaArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($area) && count($area) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($area)), __LINE__);
        }
        $this->Area = $area;
        return $this;
    }
    /**
     * Add item to Area value
     * @throws \InvalidArgumentException
     * @param \StructType\Area $item
     * @return \StructType\AreasType
     */
    public function addToArea(\StructType\Area $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Area) {
            throw new \InvalidArgumentException(sprintf('The Area property can only contain items of type \StructType\Area, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->Area) && count($this->Area) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->Area)), __LINE__);
        }
        $this->Area[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AreasType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
