<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AncillaryServicePref StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies preferences of any service or product offered in conjunction with a basic rail accommodation, such as vehicle transport, pet transport and restaurant car service. Refer to OpenTravel Code List Rail Ancillary Service (RAN).
 * @subpackage Structs
 */
class AncillaryServicePref extends AbstractStructBase
{
    /**
     * The AncillaryServiceCode
     * Meta information extracted from the WSDL
     * - documentation: An ancillary code list item from the OpenTravel Rail Ancillary Service Code(RAN) code list.
     * - use: optional
     * @var string
     */
    public $AncillaryServiceCode;
    /**
     * The FoodAllergies
     * Meta information extracted from the WSDL
     * - documentation: Food allergies of passenger.
     * - use: optional
     * @var string
     */
    public $FoodAllergies;
    /**
     * The PreferLevel
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate a level of preference for an associated item.
     * - use: optional
     * @var string
     */
    public $PreferLevel;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - documentation: Remarks about ancillary services and products.
     * - use: optional
     * @var string
     */
    public $Remark;
    /**
     * Constructor method for AncillaryServicePref
     * @uses AncillaryServicePref::setAncillaryServiceCode()
     * @uses AncillaryServicePref::setFoodAllergies()
     * @uses AncillaryServicePref::setPreferLevel()
     * @uses AncillaryServicePref::setRemark()
     * @param string $ancillaryServiceCode
     * @param string $foodAllergies
     * @param string $preferLevel
     * @param string $remark
     */
    public function __construct($ancillaryServiceCode = null, $foodAllergies = null, $preferLevel = null, $remark = null)
    {
        $this
            ->setAncillaryServiceCode($ancillaryServiceCode)
            ->setFoodAllergies($foodAllergies)
            ->setPreferLevel($preferLevel)
            ->setRemark($remark);
    }
    /**
     * Get AncillaryServiceCode value
     * @return string|null
     */
    public function getAncillaryServiceCode()
    {
        return $this->AncillaryServiceCode;
    }
    /**
     * Set AncillaryServiceCode value
     * @param string $ancillaryServiceCode
     * @return \StructType\AncillaryServicePref
     */
    public function setAncillaryServiceCode($ancillaryServiceCode = null)
    {
        // validation for constraint: string
        if (!is_null($ancillaryServiceCode) && !is_string($ancillaryServiceCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ancillaryServiceCode, true), gettype($ancillaryServiceCode)), __LINE__);
        }
        $this->AncillaryServiceCode = $ancillaryServiceCode;
        return $this;
    }
    /**
     * Get FoodAllergies value
     * @return string|null
     */
    public function getFoodAllergies()
    {
        return $this->FoodAllergies;
    }
    /**
     * Set FoodAllergies value
     * @param string $foodAllergies
     * @return \StructType\AncillaryServicePref
     */
    public function setFoodAllergies($foodAllergies = null)
    {
        // validation for constraint: string
        if (!is_null($foodAllergies) && !is_string($foodAllergies)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($foodAllergies, true), gettype($foodAllergies)), __LINE__);
        }
        $this->FoodAllergies = $foodAllergies;
        return $this;
    }
    /**
     * Get PreferLevel value
     * @return string|null
     */
    public function getPreferLevel()
    {
        return $this->PreferLevel;
    }
    /**
     * Set PreferLevel value
     * @uses \EnumType\PreferLevelType::valueIsValid()
     * @uses \EnumType\PreferLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $preferLevel
     * @return \StructType\AncillaryServicePref
     */
    public function setPreferLevel($preferLevel = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PreferLevelType::valueIsValid($preferLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PreferLevelType', is_array($preferLevel) ? implode(', ', $preferLevel) : var_export($preferLevel, true), implode(', ', \EnumType\PreferLevelType::getValidValues())), __LINE__);
        }
        $this->PreferLevel = $preferLevel;
        return $this;
    }
    /**
     * Get Remark value
     * @return string|null
     */
    public function getRemark()
    {
        return $this->Remark;
    }
    /**
     * Set Remark value
     * @param string $remark
     * @return \StructType\AncillaryServicePref
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        $this->Remark = $remark;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AncillaryServicePref
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
