<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Amenities StructType
 * Meta information extracted from the WSDL
 * - documentation: Collection of room amenity items available to the guest. | A collection of amenity information. | A collection of available amenities. | Collection of room level amenities.
 * @subpackage Structs
 */
class Amenities extends AbstractStructBase
{
    /**
     * The Amenity
     * Meta information extracted from the WSDL
     * - documentation: Used to provide room amenity information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Amenity[]
     */
    public $Amenity;
    /**
     * Constructor method for Amenities
     * @uses Amenities::setAmenity()
     * @param \StructType\Amenity[] $amenity
     */
    public function __construct(array $amenity = array())
    {
        $this
            ->setAmenity($amenity);
    }
    /**
     * Get Amenity value
     * @return \StructType\Amenity[]|null
     */
    public function getAmenity()
    {
        return $this->Amenity;
    }
    /**
     * This method is responsible for validating the values passed to the setAmenity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAmenity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAmenityForArrayConstraintsFromSetAmenity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $amenitiesAmenityItem) {
            // validation for constraint: itemType
            if (!$amenitiesAmenityItem instanceof \StructType\Amenity) {
                $invalidValues[] = is_object($amenitiesAmenityItem) ? get_class($amenitiesAmenityItem) : sprintf('%s(%s)', gettype($amenitiesAmenityItem), var_export($amenitiesAmenityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Amenity property can only contain items of type \StructType\Amenity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Amenity value
     * @throws \InvalidArgumentException
     * @param \StructType\Amenity[] $amenity
     * @return \StructType\Amenities
     */
    public function setAmenity(array $amenity = array())
    {
        // validation for constraint: array
        if ('' !== ($amenityArrayErrorMessage = self::validateAmenityForArrayConstraintsFromSetAmenity($amenity))) {
            throw new \InvalidArgumentException($amenityArrayErrorMessage, __LINE__);
        }
        $this->Amenity = $amenity;
        return $this;
    }
    /**
     * Add item to Amenity value
     * @throws \InvalidArgumentException
     * @param \StructType\Amenity $item
     * @return \StructType\Amenities
     */
    public function addToAmenity(\StructType\Amenity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Amenity) {
            throw new \InvalidArgumentException(sprintf('The Amenity property can only contain items of type \StructType\Amenity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Amenity[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Amenities
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
