<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateLocationInfo StructType
 * Meta information extracted from the WSDL
 * - documentation: Specifies alternate location(s) for the origin and/or destination.
 * @subpackage Structs
 */
class AlternateLocationInfo extends AbstractStructBase
{
    /**
     * The OriginLocation
     * Meta information extracted from the WSDL
     * - documentation: Specifies alternate airport/city codes for the origin location.
     * - use: optional
     * @var list
     */
    public $OriginLocation;
    /**
     * The DestinationLocation
     * Meta information extracted from the WSDL
     * - documentation: Specifies alternate airport/city codes for the destination location.
     * - use: optional
     * @var list
     */
    public $DestinationLocation;
    /**
     * Constructor method for AlternateLocationInfo
     * @uses AlternateLocationInfo::setOriginLocation()
     * @uses AlternateLocationInfo::setDestinationLocation()
     * @param list $originLocation
     * @param list $destinationLocation
     */
    public function __construct(list $originLocation = null, list $destinationLocation = null)
    {
        $this
            ->setOriginLocation($originLocation)
            ->setDestinationLocation($destinationLocation);
    }
    /**
     * Get OriginLocation value
     * @return list|null
     */
    public function getOriginLocation()
    {
        return $this->OriginLocation;
    }
    /**
     * Set OriginLocation value
     * @param list $originLocation
     * @return \StructType\AlternateLocationInfo
     */
    public function setOriginLocation(list $originLocation = null)
    {
        $this->OriginLocation = $originLocation;
        return $this;
    }
    /**
     * Get DestinationLocation value
     * @return list|null
     */
    public function getDestinationLocation()
    {
        return $this->DestinationLocation;
    }
    /**
     * Set DestinationLocation value
     * @param list $destinationLocation
     * @return \StructType\AlternateLocationInfo
     */
    public function setDestinationLocation(list $destinationLocation = null)
    {
        $this->DestinationLocation = $destinationLocation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlternateLocationInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
