<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateCurrencyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Alternate currency information for loyalty program currencies definition.
 * @subpackage Structs
 */
class AlternateCurrencyType extends AbstractStructBase
{
    /**
     * The CurrencyType
     * Meta information extracted from the WSDL
     * - documentation: Example: Miles | Unit of loyalty program currency.
     * - minOccurs: 0
     * @var mixed
     */
    public $CurrencyType;
    /**
     * The Conversion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Conversion
     */
    public $Conversion;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The AwardCode
     * Meta information extracted from the WSDL
     * - documentation: Note: This is an award code associated with the redemption amount. | Example: GUESTRWD12 | Award code.
     * - use: optional
     * @var string
     */
    public $AwardCode;
    /**
     * The DiscountPercentage
     * Meta information extracted from the WSDL
     * - documentation: Note: This is a percentage used for discount calculations. | Example: 6 | Discount percentage.
     * - use: optional
     * @var float
     */
    public $DiscountPercentage;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the quantity of the specified loyalty currency required or used to redeem this award. | Example: 50000 | Redemption quantity.
     * - use: optional
     * @var int
     */
    public $Quantity;
    /**
     * Constructor method for AlternateCurrencyType
     * @uses AlternateCurrencyType::setCurrencyType()
     * @uses AlternateCurrencyType::setConversion()
     * @uses AlternateCurrencyType::setTPA_Extensions()
     * @uses AlternateCurrencyType::setAwardCode()
     * @uses AlternateCurrencyType::setDiscountPercentage()
     * @uses AlternateCurrencyType::setQuantity()
     * @param mixed $currencyType
     * @param \StructType\Conversion $conversion
     * @param mixed $tPA_Extensions
     * @param string $awardCode
     * @param float $discountPercentage
     * @param int $quantity
     */
    public function __construct($currencyType = null, \StructType\Conversion $conversion = null, $tPA_Extensions = null, $awardCode = null, $discountPercentage = null, $quantity = null)
    {
        $this
            ->setCurrencyType($currencyType)
            ->setConversion($conversion)
            ->setTPA_Extensions($tPA_Extensions)
            ->setAwardCode($awardCode)
            ->setDiscountPercentage($discountPercentage)
            ->setQuantity($quantity);
    }
    /**
     * Get CurrencyType value
     * @return mixed|null
     */
    public function getCurrencyType()
    {
        return $this->CurrencyType;
    }
    /**
     * Set CurrencyType value
     * @param mixed $currencyType
     * @return \StructType\AlternateCurrencyType
     */
    public function setCurrencyType($currencyType = null)
    {
        $this->CurrencyType = $currencyType;
        return $this;
    }
    /**
     * Get Conversion value
     * @return \StructType\Conversion|null
     */
    public function getConversion()
    {
        return $this->Conversion;
    }
    /**
     * Set Conversion value
     * @param \StructType\Conversion $conversion
     * @return \StructType\AlternateCurrencyType
     */
    public function setConversion(\StructType\Conversion $conversion = null)
    {
        $this->Conversion = $conversion;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AlternateCurrencyType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get AwardCode value
     * @return string|null
     */
    public function getAwardCode()
    {
        return $this->AwardCode;
    }
    /**
     * Set AwardCode value
     * @param string $awardCode
     * @return \StructType\AlternateCurrencyType
     */
    public function setAwardCode($awardCode = null)
    {
        // validation for constraint: string
        if (!is_null($awardCode) && !is_string($awardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($awardCode, true), gettype($awardCode)), __LINE__);
        }
        $this->AwardCode = $awardCode;
        return $this;
    }
    /**
     * Get DiscountPercentage value
     * @return float|null
     */
    public function getDiscountPercentage()
    {
        return $this->DiscountPercentage;
    }
    /**
     * Set DiscountPercentage value
     * @param float $discountPercentage
     * @return \StructType\AlternateCurrencyType
     */
    public function setDiscountPercentage($discountPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercentage) && !(is_float($discountPercentage) || is_numeric($discountPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercentage, true), gettype($discountPercentage)), __LINE__);
        }
        $this->DiscountPercentage = $discountPercentage;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\AlternateCurrencyType
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlternateCurrencyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
