<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AlternateCurrency StructType
 * Meta information extracted from the WSDL
 * - documentation: Alternate currency information. | The rail fare in one or more alternate currency(s).
 * @subpackage Structs
 */
class AlternateCurrency extends List_LoyaltyPrgCurrency
{
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - documentation: Note: This is the quantity of the specified loyalty currency unit required for payment of this fee. | Example: 50000 | Redemption unit quantity.
     * - use: required
     * @var int
     */
    public $Quantity;
    /**
     * The BaseNUC_Amount
     * Meta information extracted from the WSDL
     * - documentation: The base neutral unit of construction amount.
     * - use: optional
     * @var float
     */
    public $BaseNUC_Amount;
    /**
     * Constructor method for AlternateCurrency
     * @uses AlternateCurrency::setQuantity()
     * @uses AlternateCurrency::setBaseNUC_Amount()
     * @param int $quantity
     * @param float $baseNUC_Amount
     */
    public function __construct($quantity = null, $baseNUC_Amount = null)
    {
        $this
            ->setQuantity($quantity)
            ->setBaseNUC_Amount($baseNUC_Amount);
    }
    /**
     * Get Quantity value
     * @return int
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\AlternateCurrency
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get BaseNUC_Amount value
     * @return float|null
     */
    public function getBaseNUC_Amount()
    {
        return $this->BaseNUC_Amount;
    }
    /**
     * Set BaseNUC_Amount value
     * @param float $baseNUC_Amount
     * @return \StructType\AlternateCurrency
     */
    public function setBaseNUC_Amount($baseNUC_Amount = null)
    {
        // validation for constraint: float
        if (!is_null($baseNUC_Amount) && !(is_float($baseNUC_Amount) || is_numeric($baseNUC_Amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($baseNUC_Amount, true), gettype($baseNUC_Amount)), __LINE__);
        }
        $this->BaseNUC_Amount = $baseNUC_Amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AlternateCurrency
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
