<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirlinePrefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Identifies a collection of preferences for airline travel.
 * @subpackage Structs
 */
class AirlinePrefType extends AbstractStructBase
{
    /**
     * The LoyaltyPref
     * Meta information extracted from the WSDL
     * - documentation: Identifies the preferred loyalty program(s).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $LoyaltyPref;
    /**
     * The VendorPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VendorPref[]
     */
    public $VendorPref;
    /**
     * The PaymentFormPref
     * Meta information extracted from the WSDL
     * - documentation: Preferred form(s) of payment.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PaymentFormPref;
    /**
     * The AirportOriginPref
     * Meta information extracted from the WSDL
     * - documentation: Identifies the preferred origination airport for travel (using IATA airport codes).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AirportOriginPref;
    /**
     * The AirportDestinationPref
     * Meta information extracted from the WSDL
     * - documentation: Identifies the preferred destination airport for travel (using IATA airport codes).
     * - minOccurs: 0
     * @var mixed
     */
    public $AirportDestinationPref;
    /**
     * The AirportRoutePref
     * Meta information extracted from the WSDL
     * - documentation: Indicates the preferred connection airport(s) (using IATA airport codes)..
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AirportRoutePref;
    /**
     * The FareRestrictPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareRestrictPref[]
     */
    public $FareRestrictPref;
    /**
     * The FarePref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\FarePref[]
     */
    public $FarePref;
    /**
     * The TourCodePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TourCodePref[]
     */
    public $TourCodePref;
    /**
     * The FlightTypePref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FlightTypePref[]
     */
    public $FlightTypePref;
    /**
     * The EquipPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates preferred equipment type(s) to be used in a search.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $EquipPref;
    /**
     * The CabinPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CabinPref[]
     */
    public $CabinPref;
    /**
     * The SeatPref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeatPref[]
     */
    public $SeatPref;
    /**
     * The TicketDistribPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates preferred ticket distribution method (e.g., fax, eMail, courier, mail, airport pickup)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TicketDistribPref;
    /**
     * The MealPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates preferred meal type (e.g., vegetarian, Kosher, low fat)
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MealPref;
    /**
     * The SpecRequestPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates preferred special request(s) to be used with this collection of preferences.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $SpecRequestPref;
    /**
     * The SSR_Pref
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SSR_Pref[]
     */
    public $SSR_Pref;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The MediaEntertainPref
     * Meta information extracted from the WSDL
     * - documentation: Media and entertainment preferences.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $MediaEntertainPref;
    /**
     * The PetInfoPref
     * Meta information extracted from the WSDL
     * - documentation: Indicates preferred information for pet accompanying traveler.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $PetInfoPref;
    /**
     * The AccountInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AccountInformation
     */
    public $AccountInformation;
    /**
     * The OSI_Pref
     * Meta information extracted from the WSDL
     * - documentation: Other Service Information of the airline.
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var mixed[]
     */
    public $OSI_Pref;
    /**
     * The KeywordPref
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\KeywordPref[]
     */
    public $KeywordPref;
    /**
     * The PassengerTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Category of airline passenger, using standard ATPCO codes.
     * - use: optional
     * @var string
     */
    public $PassengerTypeCode;
    /**
     * The AirTicketType
     * Meta information extracted from the WSDL
     * - documentation: Type of airline ticket preferred for this collection.
     * - use: optional
     * @var string
     */
    public $AirTicketType;
    /**
     * Constructor method for AirlinePrefType
     * @uses AirlinePrefType::setLoyaltyPref()
     * @uses AirlinePrefType::setVendorPref()
     * @uses AirlinePrefType::setPaymentFormPref()
     * @uses AirlinePrefType::setAirportOriginPref()
     * @uses AirlinePrefType::setAirportDestinationPref()
     * @uses AirlinePrefType::setAirportRoutePref()
     * @uses AirlinePrefType::setFareRestrictPref()
     * @uses AirlinePrefType::setFarePref()
     * @uses AirlinePrefType::setTourCodePref()
     * @uses AirlinePrefType::setFlightTypePref()
     * @uses AirlinePrefType::setEquipPref()
     * @uses AirlinePrefType::setCabinPref()
     * @uses AirlinePrefType::setSeatPref()
     * @uses AirlinePrefType::setTicketDistribPref()
     * @uses AirlinePrefType::setMealPref()
     * @uses AirlinePrefType::setSpecRequestPref()
     * @uses AirlinePrefType::setSSR_Pref()
     * @uses AirlinePrefType::setTPA_Extensions()
     * @uses AirlinePrefType::setMediaEntertainPref()
     * @uses AirlinePrefType::setPetInfoPref()
     * @uses AirlinePrefType::setAccountInformation()
     * @uses AirlinePrefType::setOSI_Pref()
     * @uses AirlinePrefType::setKeywordPref()
     * @uses AirlinePrefType::setPassengerTypeCode()
     * @uses AirlinePrefType::setAirTicketType()
     * @param mixed[] $loyaltyPref
     * @param \StructType\VendorPref[] $vendorPref
     * @param mixed[] $paymentFormPref
     * @param mixed[] $airportOriginPref
     * @param mixed $airportDestinationPref
     * @param mixed[] $airportRoutePref
     * @param \StructType\FareRestrictPref[] $fareRestrictPref
     * @param \StructType\FarePref[] $farePref
     * @param \StructType\TourCodePref[] $tourCodePref
     * @param \StructType\FlightTypePref[] $flightTypePref
     * @param mixed[] $equipPref
     * @param \StructType\CabinPref[] $cabinPref
     * @param \StructType\SeatPref[] $seatPref
     * @param mixed[] $ticketDistribPref
     * @param mixed[] $mealPref
     * @param mixed[] $specRequestPref
     * @param \StructType\SSR_Pref[] $sSR_Pref
     * @param mixed $tPA_Extensions
     * @param mixed[] $mediaEntertainPref
     * @param mixed[] $petInfoPref
     * @param \StructType\AccountInformation $accountInformation
     * @param mixed[] $oSI_Pref
     * @param \StructType\KeywordPref[] $keywordPref
     * @param string $passengerTypeCode
     * @param string $airTicketType
     */
    public function __construct(array $loyaltyPref = array(), array $vendorPref = array(), array $paymentFormPref = array(), array $airportOriginPref = array(), $airportDestinationPref = null, array $airportRoutePref = array(), array $fareRestrictPref = array(), array $farePref = array(), array $tourCodePref = array(), array $flightTypePref = array(), array $equipPref = array(), array $cabinPref = array(), array $seatPref = array(), array $ticketDistribPref = array(), array $mealPref = array(), array $specRequestPref = array(), array $sSR_Pref = array(), $tPA_Extensions = null, array $mediaEntertainPref = array(), array $petInfoPref = array(), \StructType\AccountInformation $accountInformation = null, array $oSI_Pref = array(), array $keywordPref = array(), $passengerTypeCode = null, $airTicketType = null)
    {
        $this
            ->setLoyaltyPref($loyaltyPref)
            ->setVendorPref($vendorPref)
            ->setPaymentFormPref($paymentFormPref)
            ->setAirportOriginPref($airportOriginPref)
            ->setAirportDestinationPref($airportDestinationPref)
            ->setAirportRoutePref($airportRoutePref)
            ->setFareRestrictPref($fareRestrictPref)
            ->setFarePref($farePref)
            ->setTourCodePref($tourCodePref)
            ->setFlightTypePref($flightTypePref)
            ->setEquipPref($equipPref)
            ->setCabinPref($cabinPref)
            ->setSeatPref($seatPref)
            ->setTicketDistribPref($ticketDistribPref)
            ->setMealPref($mealPref)
            ->setSpecRequestPref($specRequestPref)
            ->setSSR_Pref($sSR_Pref)
            ->setTPA_Extensions($tPA_Extensions)
            ->setMediaEntertainPref($mediaEntertainPref)
            ->setPetInfoPref($petInfoPref)
            ->setAccountInformation($accountInformation)
            ->setOSI_Pref($oSI_Pref)
            ->setKeywordPref($keywordPref)
            ->setPassengerTypeCode($passengerTypeCode)
            ->setAirTicketType($airTicketType);
    }
    /**
     * Get LoyaltyPref value
     * @return mixed[]|null
     */
    public function getLoyaltyPref()
    {
        return $this->LoyaltyPref;
    }
    /**
     * This method is responsible for validating the values passed to the setLoyaltyPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLoyaltyPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeLoyaltyPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeLoyaltyPrefItem) ? get_class($airlinePrefTypeLoyaltyPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeLoyaltyPrefItem), var_export($airlinePrefTypeLoyaltyPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $loyaltyPref
     * @return \StructType\AirlinePrefType
     */
    public function setLoyaltyPref(array $loyaltyPref = array())
    {
        // validation for constraint: array
        if ('' !== ($loyaltyPrefArrayErrorMessage = self::validateLoyaltyPrefForArrayConstraintsFromSetLoyaltyPref($loyaltyPref))) {
            throw new \InvalidArgumentException($loyaltyPrefArrayErrorMessage, __LINE__);
        }
        $this->LoyaltyPref = $loyaltyPref;
        return $this;
    }
    /**
     * Add item to LoyaltyPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToLoyaltyPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The LoyaltyPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LoyaltyPref[] = $item;
        return $this;
    }
    /**
     * Get VendorPref value
     * @return \StructType\VendorPref[]|null
     */
    public function getVendorPref()
    {
        return $this->VendorPref;
    }
    /**
     * This method is responsible for validating the values passed to the setVendorPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVendorPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVendorPrefForArrayConstraintsFromSetVendorPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeVendorPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeVendorPrefItem instanceof \StructType\VendorPref) {
                $invalidValues[] = is_object($airlinePrefTypeVendorPrefItem) ? get_class($airlinePrefTypeVendorPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeVendorPrefItem), var_export($airlinePrefTypeVendorPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The VendorPref property can only contain items of type \StructType\VendorPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPref[] $vendorPref
     * @return \StructType\AirlinePrefType
     */
    public function setVendorPref(array $vendorPref = array())
    {
        // validation for constraint: array
        if ('' !== ($vendorPrefArrayErrorMessage = self::validateVendorPrefForArrayConstraintsFromSetVendorPref($vendorPref))) {
            throw new \InvalidArgumentException($vendorPrefArrayErrorMessage, __LINE__);
        }
        $this->VendorPref = $vendorPref;
        return $this;
    }
    /**
     * Add item to VendorPref value
     * @throws \InvalidArgumentException
     * @param \StructType\VendorPref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToVendorPref(\StructType\VendorPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VendorPref) {
            throw new \InvalidArgumentException(sprintf('The VendorPref property can only contain items of type \StructType\VendorPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->VendorPref[] = $item;
        return $this;
    }
    /**
     * Get PaymentFormPref value
     * @return mixed[]|null
     */
    public function getPaymentFormPref()
    {
        return $this->PaymentFormPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFormPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFormPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypePaymentFormPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypePaymentFormPrefItem) ? get_class($airlinePrefTypePaymentFormPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypePaymentFormPrefItem), var_export($airlinePrefTypePaymentFormPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFormPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $paymentFormPref
     * @return \StructType\AirlinePrefType
     */
    public function setPaymentFormPref(array $paymentFormPref = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFormPrefArrayErrorMessage = self::validatePaymentFormPrefForArrayConstraintsFromSetPaymentFormPref($paymentFormPref))) {
            throw new \InvalidArgumentException($paymentFormPrefArrayErrorMessage, __LINE__);
        }
        $this->PaymentFormPref = $paymentFormPref;
        return $this;
    }
    /**
     * Add item to PaymentFormPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToPaymentFormPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PaymentFormPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFormPref[] = $item;
        return $this;
    }
    /**
     * Get AirportOriginPref value
     * @return mixed[]|null
     */
    public function getAirportOriginPref()
    {
        return $this->AirportOriginPref;
    }
    /**
     * This method is responsible for validating the values passed to the setAirportOriginPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirportOriginPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirportOriginPrefForArrayConstraintsFromSetAirportOriginPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeAirportOriginPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeAirportOriginPrefItem) ? get_class($airlinePrefTypeAirportOriginPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeAirportOriginPrefItem), var_export($airlinePrefTypeAirportOriginPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirportOriginPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $airportOriginPref
     * @return \StructType\AirlinePrefType
     */
    public function setAirportOriginPref(array $airportOriginPref = array())
    {
        // validation for constraint: array
        if ('' !== ($airportOriginPrefArrayErrorMessage = self::validateAirportOriginPrefForArrayConstraintsFromSetAirportOriginPref($airportOriginPref))) {
            throw new \InvalidArgumentException($airportOriginPrefArrayErrorMessage, __LINE__);
        }
        $this->AirportOriginPref = $airportOriginPref;
        return $this;
    }
    /**
     * Add item to AirportOriginPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToAirportOriginPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AirportOriginPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirportOriginPref[] = $item;
        return $this;
    }
    /**
     * Get AirportDestinationPref value
     * @return mixed|null
     */
    public function getAirportDestinationPref()
    {
        return $this->AirportDestinationPref;
    }
    /**
     * Set AirportDestinationPref value
     * @param mixed $airportDestinationPref
     * @return \StructType\AirlinePrefType
     */
    public function setAirportDestinationPref($airportDestinationPref = null)
    {
        $this->AirportDestinationPref = $airportDestinationPref;
        return $this;
    }
    /**
     * Get AirportRoutePref value
     * @return mixed[]|null
     */
    public function getAirportRoutePref()
    {
        return $this->AirportRoutePref;
    }
    /**
     * This method is responsible for validating the values passed to the setAirportRoutePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAirportRoutePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAirportRoutePrefForArrayConstraintsFromSetAirportRoutePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeAirportRoutePrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeAirportRoutePrefItem) ? get_class($airlinePrefTypeAirportRoutePrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeAirportRoutePrefItem), var_export($airlinePrefTypeAirportRoutePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AirportRoutePref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param mixed[] $airportRoutePref
     * @return \StructType\AirlinePrefType
     */
    public function setAirportRoutePref(array $airportRoutePref = array())
    {
        // validation for constraint: array
        if ('' !== ($airportRoutePrefArrayErrorMessage = self::validateAirportRoutePrefForArrayConstraintsFromSetAirportRoutePref($airportRoutePref))) {
            throw new \InvalidArgumentException($airportRoutePrefArrayErrorMessage, __LINE__);
        }
        $this->AirportRoutePref = $airportRoutePref;
        return $this;
    }
    /**
     * Add item to AirportRoutePref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToAirportRoutePref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AirportRoutePref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AirportRoutePref[] = $item;
        return $this;
    }
    /**
     * Get FareRestrictPref value
     * @return \StructType\FareRestrictPref[]|null
     */
    public function getFareRestrictPref()
    {
        return $this->FareRestrictPref;
    }
    /**
     * This method is responsible for validating the values passed to the setFareRestrictPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareRestrictPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareRestrictPrefForArrayConstraintsFromSetFareRestrictPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeFareRestrictPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFareRestrictPrefItem instanceof \StructType\FareRestrictPref) {
                $invalidValues[] = is_object($airlinePrefTypeFareRestrictPrefItem) ? get_class($airlinePrefTypeFareRestrictPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeFareRestrictPrefItem), var_export($airlinePrefTypeFareRestrictPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareRestrictPref property can only contain items of type \StructType\FareRestrictPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRestrictPref[] $fareRestrictPref
     * @return \StructType\AirlinePrefType
     */
    public function setFareRestrictPref(array $fareRestrictPref = array())
    {
        // validation for constraint: array
        if ('' !== ($fareRestrictPrefArrayErrorMessage = self::validateFareRestrictPrefForArrayConstraintsFromSetFareRestrictPref($fareRestrictPref))) {
            throw new \InvalidArgumentException($fareRestrictPrefArrayErrorMessage, __LINE__);
        }
        $this->FareRestrictPref = $fareRestrictPref;
        return $this;
    }
    /**
     * Add item to FareRestrictPref value
     * @throws \InvalidArgumentException
     * @param \StructType\FareRestrictPref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToFareRestrictPref(\StructType\FareRestrictPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareRestrictPref) {
            throw new \InvalidArgumentException(sprintf('The FareRestrictPref property can only contain items of type \StructType\FareRestrictPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareRestrictPref[] = $item;
        return $this;
    }
    /**
     * Get FarePref value
     * @return \StructType\FarePref[]|null
     */
    public function getFarePref()
    {
        return $this->FarePref;
    }
    /**
     * This method is responsible for validating the values passed to the setFarePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFarePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFarePrefForArrayConstraintsFromSetFarePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeFarePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFarePrefItem instanceof \StructType\FarePref) {
                $invalidValues[] = is_object($airlinePrefTypeFarePrefItem) ? get_class($airlinePrefTypeFarePrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeFarePrefItem), var_export($airlinePrefTypeFarePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FarePref property can only contain items of type \StructType\FarePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FarePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FarePref[] $farePref
     * @return \StructType\AirlinePrefType
     */
    public function setFarePref(array $farePref = array())
    {
        // validation for constraint: array
        if ('' !== ($farePrefArrayErrorMessage = self::validateFarePrefForArrayConstraintsFromSetFarePref($farePref))) {
            throw new \InvalidArgumentException($farePrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($farePref) && count($farePref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($farePref)), __LINE__);
        }
        $this->FarePref = $farePref;
        return $this;
    }
    /**
     * Add item to FarePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FarePref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToFarePref(\StructType\FarePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FarePref) {
            throw new \InvalidArgumentException(sprintf('The FarePref property can only contain items of type \StructType\FarePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->FarePref) && count($this->FarePref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->FarePref)), __LINE__);
        }
        $this->FarePref[] = $item;
        return $this;
    }
    /**
     * Get TourCodePref value
     * @return \StructType\TourCodePref[]|null
     */
    public function getTourCodePref()
    {
        return $this->TourCodePref;
    }
    /**
     * This method is responsible for validating the values passed to the setTourCodePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTourCodePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTourCodePrefForArrayConstraintsFromSetTourCodePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeTourCodePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeTourCodePrefItem instanceof \StructType\TourCodePref) {
                $invalidValues[] = is_object($airlinePrefTypeTourCodePrefItem) ? get_class($airlinePrefTypeTourCodePrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeTourCodePrefItem), var_export($airlinePrefTypeTourCodePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TourCodePref property can only contain items of type \StructType\TourCodePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TourCodePref value
     * @throws \InvalidArgumentException
     * @param \StructType\TourCodePref[] $tourCodePref
     * @return \StructType\AirlinePrefType
     */
    public function setTourCodePref(array $tourCodePref = array())
    {
        // validation for constraint: array
        if ('' !== ($tourCodePrefArrayErrorMessage = self::validateTourCodePrefForArrayConstraintsFromSetTourCodePref($tourCodePref))) {
            throw new \InvalidArgumentException($tourCodePrefArrayErrorMessage, __LINE__);
        }
        $this->TourCodePref = $tourCodePref;
        return $this;
    }
    /**
     * Add item to TourCodePref value
     * @throws \InvalidArgumentException
     * @param \StructType\TourCodePref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToTourCodePref(\StructType\TourCodePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TourCodePref) {
            throw new \InvalidArgumentException(sprintf('The TourCodePref property can only contain items of type \StructType\TourCodePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TourCodePref[] = $item;
        return $this;
    }
    /**
     * Get FlightTypePref value
     * @return \StructType\FlightTypePref[]|null
     */
    public function getFlightTypePref()
    {
        return $this->FlightTypePref;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightTypePref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightTypePref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightTypePrefForArrayConstraintsFromSetFlightTypePref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeFlightTypePrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeFlightTypePrefItem instanceof \StructType\FlightTypePref) {
                $invalidValues[] = is_object($airlinePrefTypeFlightTypePrefItem) ? get_class($airlinePrefTypeFlightTypePrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeFlightTypePrefItem), var_export($airlinePrefTypeFlightTypePrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightTypePref property can only contain items of type \StructType\FlightTypePref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightTypePref[] $flightTypePref
     * @return \StructType\AirlinePrefType
     */
    public function setFlightTypePref(array $flightTypePref = array())
    {
        // validation for constraint: array
        if ('' !== ($flightTypePrefArrayErrorMessage = self::validateFlightTypePrefForArrayConstraintsFromSetFlightTypePref($flightTypePref))) {
            throw new \InvalidArgumentException($flightTypePrefArrayErrorMessage, __LINE__);
        }
        $this->FlightTypePref = $flightTypePref;
        return $this;
    }
    /**
     * Add item to FlightTypePref value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightTypePref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToFlightTypePref(\StructType\FlightTypePref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightTypePref) {
            throw new \InvalidArgumentException(sprintf('The FlightTypePref property can only contain items of type \StructType\FlightTypePref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FlightTypePref[] = $item;
        return $this;
    }
    /**
     * Get EquipPref value
     * @return mixed[]|null
     */
    public function getEquipPref()
    {
        return $this->EquipPref;
    }
    /**
     * This method is responsible for validating the values passed to the setEquipPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEquipPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEquipPrefForArrayConstraintsFromSetEquipPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeEquipPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeEquipPrefItem) ? get_class($airlinePrefTypeEquipPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeEquipPrefItem), var_export($airlinePrefTypeEquipPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EquipPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EquipPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $equipPref
     * @return \StructType\AirlinePrefType
     */
    public function setEquipPref(array $equipPref = array())
    {
        // validation for constraint: array
        if ('' !== ($equipPrefArrayErrorMessage = self::validateEquipPrefForArrayConstraintsFromSetEquipPref($equipPref))) {
            throw new \InvalidArgumentException($equipPrefArrayErrorMessage, __LINE__);
        }
        $this->EquipPref = $equipPref;
        return $this;
    }
    /**
     * Add item to EquipPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToEquipPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The EquipPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EquipPref[] = $item;
        return $this;
    }
    /**
     * Get CabinPref value
     * @return \StructType\CabinPref[]|null
     */
    public function getCabinPref()
    {
        return $this->CabinPref;
    }
    /**
     * This method is responsible for validating the values passed to the setCabinPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabinPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinPrefForArrayConstraintsFromSetCabinPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeCabinPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeCabinPrefItem instanceof \StructType\CabinPref) {
                $invalidValues[] = is_object($airlinePrefTypeCabinPrefItem) ? get_class($airlinePrefTypeCabinPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeCabinPrefItem), var_export($airlinePrefTypeCabinPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CabinPref property can only contain items of type \StructType\CabinPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CabinPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinPref[] $cabinPref
     * @return \StructType\AirlinePrefType
     */
    public function setCabinPref(array $cabinPref = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinPrefArrayErrorMessage = self::validateCabinPrefForArrayConstraintsFromSetCabinPref($cabinPref))) {
            throw new \InvalidArgumentException($cabinPrefArrayErrorMessage, __LINE__);
        }
        $this->CabinPref = $cabinPref;
        return $this;
    }
    /**
     * Add item to CabinPref value
     * @throws \InvalidArgumentException
     * @param \StructType\CabinPref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToCabinPref(\StructType\CabinPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CabinPref) {
            throw new \InvalidArgumentException(sprintf('The CabinPref property can only contain items of type \StructType\CabinPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CabinPref[] = $item;
        return $this;
    }
    /**
     * Get SeatPref value
     * @return \StructType\SeatPref[]|null
     */
    public function getSeatPref()
    {
        return $this->SeatPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatPrefForArrayConstraintsFromSetSeatPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeSeatPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSeatPrefItem instanceof \StructType\SeatPref) {
                $invalidValues[] = is_object($airlinePrefTypeSeatPrefItem) ? get_class($airlinePrefTypeSeatPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeSeatPrefItem), var_export($airlinePrefTypeSeatPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatPref property can only contain items of type \StructType\SeatPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatPref[] $seatPref
     * @return \StructType\AirlinePrefType
     */
    public function setSeatPref(array $seatPref = array())
    {
        // validation for constraint: array
        if ('' !== ($seatPrefArrayErrorMessage = self::validateSeatPrefForArrayConstraintsFromSetSeatPref($seatPref))) {
            throw new \InvalidArgumentException($seatPrefArrayErrorMessage, __LINE__);
        }
        $this->SeatPref = $seatPref;
        return $this;
    }
    /**
     * Add item to SeatPref value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatPref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToSeatPref(\StructType\SeatPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatPref) {
            throw new \InvalidArgumentException(sprintf('The SeatPref property can only contain items of type \StructType\SeatPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatPref[] = $item;
        return $this;
    }
    /**
     * Get TicketDistribPref value
     * @return mixed[]|null
     */
    public function getTicketDistribPref()
    {
        return $this->TicketDistribPref;
    }
    /**
     * This method is responsible for validating the values passed to the setTicketDistribPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTicketDistribPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeTicketDistribPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeTicketDistribPrefItem) ? get_class($airlinePrefTypeTicketDistribPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeTicketDistribPrefItem), var_export($airlinePrefTypeTicketDistribPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TicketDistribPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $ticketDistribPref
     * @return \StructType\AirlinePrefType
     */
    public function setTicketDistribPref(array $ticketDistribPref = array())
    {
        // validation for constraint: array
        if ('' !== ($ticketDistribPrefArrayErrorMessage = self::validateTicketDistribPrefForArrayConstraintsFromSetTicketDistribPref($ticketDistribPref))) {
            throw new \InvalidArgumentException($ticketDistribPrefArrayErrorMessage, __LINE__);
        }
        $this->TicketDistribPref = $ticketDistribPref;
        return $this;
    }
    /**
     * Add item to TicketDistribPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToTicketDistribPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TicketDistribPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TicketDistribPref[] = $item;
        return $this;
    }
    /**
     * Get MealPref value
     * @return mixed[]|null
     */
    public function getMealPref()
    {
        return $this->MealPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMealPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMealPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMealPrefForArrayConstraintsFromSetMealPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeMealPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeMealPrefItem) ? get_class($airlinePrefTypeMealPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeMealPrefItem), var_export($airlinePrefTypeMealPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MealPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MealPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $mealPref
     * @return \StructType\AirlinePrefType
     */
    public function setMealPref(array $mealPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mealPrefArrayErrorMessage = self::validateMealPrefForArrayConstraintsFromSetMealPref($mealPref))) {
            throw new \InvalidArgumentException($mealPrefArrayErrorMessage, __LINE__);
        }
        $this->MealPref = $mealPref;
        return $this;
    }
    /**
     * Add item to MealPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToMealPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MealPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MealPref[] = $item;
        return $this;
    }
    /**
     * Get SpecRequestPref value
     * @return mixed[]|null
     */
    public function getSpecRequestPref()
    {
        return $this->SpecRequestPref;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecRequestPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecRequestPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeSpecRequestPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeSpecRequestPrefItem) ? get_class($airlinePrefTypeSpecRequestPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeSpecRequestPrefItem), var_export($airlinePrefTypeSpecRequestPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecRequestPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $specRequestPref
     * @return \StructType\AirlinePrefType
     */
    public function setSpecRequestPref(array $specRequestPref = array())
    {
        // validation for constraint: array
        if ('' !== ($specRequestPrefArrayErrorMessage = self::validateSpecRequestPrefForArrayConstraintsFromSetSpecRequestPref($specRequestPref))) {
            throw new \InvalidArgumentException($specRequestPrefArrayErrorMessage, __LINE__);
        }
        $this->SpecRequestPref = $specRequestPref;
        return $this;
    }
    /**
     * Add item to SpecRequestPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToSpecRequestPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The SpecRequestPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecRequestPref[] = $item;
        return $this;
    }
    /**
     * Get SSR_Pref value
     * @return \StructType\SSR_Pref[]|null
     */
    public function getSSR_Pref()
    {
        return $this->SSR_Pref;
    }
    /**
     * This method is responsible for validating the values passed to the setSSR_Pref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSSR_Pref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSSR_PrefForArrayConstraintsFromSetSSR_Pref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeSSR_PrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeSSR_PrefItem instanceof \StructType\SSR_Pref) {
                $invalidValues[] = is_object($airlinePrefTypeSSR_PrefItem) ? get_class($airlinePrefTypeSSR_PrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeSSR_PrefItem), var_export($airlinePrefTypeSSR_PrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SSR_Pref property can only contain items of type \StructType\SSR_Pref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \StructType\SSR_Pref[] $sSR_Pref
     * @return \StructType\AirlinePrefType
     */
    public function setSSR_Pref(array $sSR_Pref = array())
    {
        // validation for constraint: array
        if ('' !== ($sSR_PrefArrayErrorMessage = self::validateSSR_PrefForArrayConstraintsFromSetSSR_Pref($sSR_Pref))) {
            throw new \InvalidArgumentException($sSR_PrefArrayErrorMessage, __LINE__);
        }
        $this->SSR_Pref = $sSR_Pref;
        return $this;
    }
    /**
     * Add item to SSR_Pref value
     * @throws \InvalidArgumentException
     * @param \StructType\SSR_Pref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToSSR_Pref(\StructType\SSR_Pref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SSR_Pref) {
            throw new \InvalidArgumentException(sprintf('The SSR_Pref property can only contain items of type \StructType\SSR_Pref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SSR_Pref[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirlinePrefType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get MediaEntertainPref value
     * @return mixed[]|null
     */
    public function getMediaEntertainPref()
    {
        return $this->MediaEntertainPref;
    }
    /**
     * This method is responsible for validating the values passed to the setMediaEntertainPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMediaEntertainPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeMediaEntertainPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeMediaEntertainPrefItem) ? get_class($airlinePrefTypeMediaEntertainPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeMediaEntertainPrefItem), var_export($airlinePrefTypeMediaEntertainPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MediaEntertainPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $mediaEntertainPref
     * @return \StructType\AirlinePrefType
     */
    public function setMediaEntertainPref(array $mediaEntertainPref = array())
    {
        // validation for constraint: array
        if ('' !== ($mediaEntertainPrefArrayErrorMessage = self::validateMediaEntertainPrefForArrayConstraintsFromSetMediaEntertainPref($mediaEntertainPref))) {
            throw new \InvalidArgumentException($mediaEntertainPrefArrayErrorMessage, __LINE__);
        }
        $this->MediaEntertainPref = $mediaEntertainPref;
        return $this;
    }
    /**
     * Add item to MediaEntertainPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToMediaEntertainPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The MediaEntertainPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MediaEntertainPref[] = $item;
        return $this;
    }
    /**
     * Get PetInfoPref value
     * @return mixed[]|null
     */
    public function getPetInfoPref()
    {
        return $this->PetInfoPref;
    }
    /**
     * This method is responsible for validating the values passed to the setPetInfoPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPetInfoPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypePetInfoPrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypePetInfoPrefItem) ? get_class($airlinePrefTypePetInfoPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypePetInfoPrefItem), var_export($airlinePrefTypePetInfoPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PetInfoPref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PetInfoPref value
     * @throws \InvalidArgumentException
     * @param mixed[] $petInfoPref
     * @return \StructType\AirlinePrefType
     */
    public function setPetInfoPref(array $petInfoPref = array())
    {
        // validation for constraint: array
        if ('' !== ($petInfoPrefArrayErrorMessage = self::validatePetInfoPrefForArrayConstraintsFromSetPetInfoPref($petInfoPref))) {
            throw new \InvalidArgumentException($petInfoPrefArrayErrorMessage, __LINE__);
        }
        $this->PetInfoPref = $petInfoPref;
        return $this;
    }
    /**
     * Add item to PetInfoPref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToPetInfoPref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The PetInfoPref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PetInfoPref[] = $item;
        return $this;
    }
    /**
     * Get AccountInformation value
     * @return \StructType\AccountInformation|null
     */
    public function getAccountInformation()
    {
        return $this->AccountInformation;
    }
    /**
     * Set AccountInformation value
     * @param \StructType\AccountInformation $accountInformation
     * @return \StructType\AirlinePrefType
     */
    public function setAccountInformation(\StructType\AccountInformation $accountInformation = null)
    {
        $this->AccountInformation = $accountInformation;
        return $this;
    }
    /**
     * Get OSI_Pref value
     * @return mixed[]|null
     */
    public function getOSI_Pref()
    {
        return $this->OSI_Pref;
    }
    /**
     * This method is responsible for validating the values passed to the setOSI_Pref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOSI_Pref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOSI_PrefForArrayConstraintsFromSetOSI_Pref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeOSI_PrefItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airlinePrefTypeOSI_PrefItem) ? get_class($airlinePrefTypeOSI_PrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeOSI_PrefItem), var_export($airlinePrefTypeOSI_PrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OSI_Pref property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OSI_Pref value
     * @throws \InvalidArgumentException
     * @param mixed[] $oSI_Pref
     * @return \StructType\AirlinePrefType
     */
    public function setOSI_Pref(array $oSI_Pref = array())
    {
        // validation for constraint: array
        if ('' !== ($oSI_PrefArrayErrorMessage = self::validateOSI_PrefForArrayConstraintsFromSetOSI_Pref($oSI_Pref))) {
            throw new \InvalidArgumentException($oSI_PrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($oSI_Pref) && count($oSI_Pref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($oSI_Pref)), __LINE__);
        }
        $this->OSI_Pref = $oSI_Pref;
        return $this;
    }
    /**
     * Add item to OSI_Pref value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirlinePrefType
     */
    public function addToOSI_Pref($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The OSI_Pref property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->OSI_Pref) && count($this->OSI_Pref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->OSI_Pref)), __LINE__);
        }
        $this->OSI_Pref[] = $item;
        return $this;
    }
    /**
     * Get KeywordPref value
     * @return \StructType\KeywordPref[]|null
     */
    public function getKeywordPref()
    {
        return $this->KeywordPref;
    }
    /**
     * This method is responsible for validating the values passed to the setKeywordPref method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKeywordPref method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeywordPrefForArrayConstraintsFromSetKeywordPref(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airlinePrefTypeKeywordPrefItem) {
            // validation for constraint: itemType
            if (!$airlinePrefTypeKeywordPrefItem instanceof \StructType\KeywordPref) {
                $invalidValues[] = is_object($airlinePrefTypeKeywordPrefItem) ? get_class($airlinePrefTypeKeywordPrefItem) : sprintf('%s(%s)', gettype($airlinePrefTypeKeywordPrefItem), var_export($airlinePrefTypeKeywordPrefItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The KeywordPref property can only contain items of type \StructType\KeywordPref, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set KeywordPref value
     * @throws \InvalidArgumentException
     * @param \StructType\KeywordPref[] $keywordPref
     * @return \StructType\AirlinePrefType
     */
    public function setKeywordPref(array $keywordPref = array())
    {
        // validation for constraint: array
        if ('' !== ($keywordPrefArrayErrorMessage = self::validateKeywordPrefForArrayConstraintsFromSetKeywordPref($keywordPref))) {
            throw new \InvalidArgumentException($keywordPrefArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($keywordPref) && count($keywordPref) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($keywordPref)), __LINE__);
        }
        $this->KeywordPref = $keywordPref;
        return $this;
    }
    /**
     * Add item to KeywordPref value
     * @throws \InvalidArgumentException
     * @param \StructType\KeywordPref $item
     * @return \StructType\AirlinePrefType
     */
    public function addToKeywordPref(\StructType\KeywordPref $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeywordPref) {
            throw new \InvalidArgumentException(sprintf('The KeywordPref property can only contain items of type \StructType\KeywordPref, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->KeywordPref) && count($this->KeywordPref) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->KeywordPref)), __LINE__);
        }
        $this->KeywordPref[] = $item;
        return $this;
    }
    /**
     * Get PassengerTypeCode value
     * @return string|null
     */
    public function getPassengerTypeCode()
    {
        return $this->PassengerTypeCode;
    }
    /**
     * Set PassengerTypeCode value
     * @param string $passengerTypeCode
     * @return \StructType\AirlinePrefType
     */
    public function setPassengerTypeCode($passengerTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($passengerTypeCode) && !is_string($passengerTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passengerTypeCode, true), gettype($passengerTypeCode)), __LINE__);
        }
        $this->PassengerTypeCode = $passengerTypeCode;
        return $this;
    }
    /**
     * Get AirTicketType value
     * @return string|null
     */
    public function getAirTicketType()
    {
        return $this->AirTicketType;
    }
    /**
     * Set AirTicketType value
     * @uses \EnumType\TicketType::valueIsValid()
     * @uses \EnumType\TicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $airTicketType
     * @return \StructType\AirlinePrefType
     */
    public function setAirTicketType($airTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TicketType::valueIsValid($airTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TicketType', is_array($airTicketType) ? implode(', ', $airTicketType) : var_export($airTicketType, true), implode(', ', \EnumType\TicketType::getValidValues())), __LINE__);
        }
        $this->AirTicketType = $airTicketType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirlinePrefType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
