<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTaxType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines the data fields available for air tax. The element text of this type may contain a description of the tax. | A textual description.
 * - base: xs:string
 * - maxLength: 64
 * - minLength: 0
 * @subpackage Structs
 */
class AirTaxType extends AbstractStructBase
{
    /**
     * The TaxCode
     * Meta information extracted from the WSDL
     * - documentation: Identifies the code for the tax.
     * - use: optional
     * @var string
     */
    public $TaxCode;
    /**
     * The TaxCountry
     * Meta information extracted from the WSDL
     * - documentation: Used to identify the country imposing the tax.
     * - use: optional
     * @var string
     */
    public $TaxCountry;
    /**
     * The TaxName
     * Meta information extracted from the WSDL
     * - documentation: Identifies the tax code by name.
     * - use: optional
     * @var string
     */
    public $TaxName;
    /**
     * The TaxExemptInd
     * Meta information extracted from the WSDL
     * - documentation: When true, the fare is exempt from the tax specified by the tax code. | This attribute is a candidate for deprecation. Its use is not recommended. Please instead use the new TaxTransactionType attribute which has taken its place.
     * Deprecation warning added in 2009A.
     * - use: optional
     * @var bool
     */
    public $TaxExemptInd;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - documentation: Indicates the required modification to the element.
     * - use: optional
     * @var string
     */
    public $Operation;
    /**
     * The TaxTransactionType
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $TaxTransactionType;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique reference for the tax type (commonly used for modification.)
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * The RefundableInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this tax amount may be refunded on ticket cancellation.
     * - use: optional
     * @var bool
     */
    public $RefundableInd;
    /**
     * Constructor method for AirTaxType
     * @uses AirTaxType::setTaxCode()
     * @uses AirTaxType::setTaxCountry()
     * @uses AirTaxType::setTaxName()
     * @uses AirTaxType::setTaxExemptInd()
     * @uses AirTaxType::setOperation()
     * @uses AirTaxType::setTaxTransactionType()
     * @uses AirTaxType::setRPH()
     * @uses AirTaxType::setRefundableInd()
     * @param string $taxCode
     * @param string $taxCountry
     * @param string $taxName
     * @param bool $taxExemptInd
     * @param string $operation
     * @param string $taxTransactionType
     * @param string $rPH
     * @param bool $refundableInd
     */
    public function __construct($taxCode = null, $taxCountry = null, $taxName = null, $taxExemptInd = null, $operation = null, $taxTransactionType = null, $rPH = null, $refundableInd = null)
    {
        $this
            ->setTaxCode($taxCode)
            ->setTaxCountry($taxCountry)
            ->setTaxName($taxName)
            ->setTaxExemptInd($taxExemptInd)
            ->setOperation($operation)
            ->setTaxTransactionType($taxTransactionType)
            ->setRPH($rPH)
            ->setRefundableInd($refundableInd);
    }
    /**
     * Get TaxCode value
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->TaxCode;
    }
    /**
     * Set TaxCode value
     * @param string $taxCode
     * @return \StructType\AirTaxType
     */
    public function setTaxCode($taxCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCode) && !is_string($taxCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCode, true), gettype($taxCode)), __LINE__);
        }
        $this->TaxCode = $taxCode;
        return $this;
    }
    /**
     * Get TaxCountry value
     * @return string|null
     */
    public function getTaxCountry()
    {
        return $this->TaxCountry;
    }
    /**
     * Set TaxCountry value
     * @param string $taxCountry
     * @return \StructType\AirTaxType
     */
    public function setTaxCountry($taxCountry = null)
    {
        // validation for constraint: string
        if (!is_null($taxCountry) && !is_string($taxCountry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCountry, true), gettype($taxCountry)), __LINE__);
        }
        $this->TaxCountry = $taxCountry;
        return $this;
    }
    /**
     * Get TaxName value
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->TaxName;
    }
    /**
     * Set TaxName value
     * @param string $taxName
     * @return \StructType\AirTaxType
     */
    public function setTaxName($taxName = null)
    {
        // validation for constraint: string
        if (!is_null($taxName) && !is_string($taxName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxName, true), gettype($taxName)), __LINE__);
        }
        $this->TaxName = $taxName;
        return $this;
    }
    /**
     * Get TaxExemptInd value
     * @return bool|null
     */
    public function getTaxExemptInd()
    {
        return $this->TaxExemptInd;
    }
    /**
     * Set TaxExemptInd value
     * @param bool $taxExemptInd
     * @return \StructType\AirTaxType
     */
    public function setTaxExemptInd($taxExemptInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxExemptInd) && !is_bool($taxExemptInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxExemptInd, true), gettype($taxExemptInd)), __LINE__);
        }
        $this->TaxExemptInd = $taxExemptInd;
        return $this;
    }
    /**
     * Get Operation value
     * @return string|null
     */
    public function getOperation()
    {
        return $this->Operation;
    }
    /**
     * Set Operation value
     * @uses \EnumType\ActionType::valueIsValid()
     * @uses \EnumType\ActionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \StructType\AirTaxType
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ActionType::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ActionType', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \EnumType\ActionType::getValidValues())), __LINE__);
        }
        $this->Operation = $operation;
        return $this;
    }
    /**
     * Get TaxTransactionType value
     * @return string|null
     */
    public function getTaxTransactionType()
    {
        return $this->TaxTransactionType;
    }
    /**
     * Set TaxTransactionType value
     * @param string $taxTransactionType
     * @return \StructType\AirTaxType
     */
    public function setTaxTransactionType($taxTransactionType = null)
    {
        // validation for constraint: string
        if (!is_null($taxTransactionType) && !is_string($taxTransactionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxTransactionType, true), gettype($taxTransactionType)), __LINE__);
        }
        $this->TaxTransactionType = $taxTransactionType;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AirTaxType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Get RefundableInd value
     * @return bool|null
     */
    public function getRefundableInd()
    {
        return $this->RefundableInd;
    }
    /**
     * Set RefundableInd value
     * @param bool $refundableInd
     * @return \StructType\AirTaxType
     */
    public function setRefundableInd($refundableInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($refundableInd) && !is_bool($refundableInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($refundableInd, true), gettype($refundableInd)), __LINE__);
        }
        $this->RefundableInd = $refundableInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirTaxType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
