<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirReadRequest StructType
 * Meta information extracted from the WSDL
 * - documentation: To retrieve an airline reservation when the booking reference is not known or to search for a list of passengers meeting certain criteria.
 * @subpackage Structs
 */
class AirReadRequest extends AbstractStructBase
{
    /**
     * The POS
     * Meta information extracted from the WSDL
     * - documentation: To request a list of reservations made by specified travel agent, ERSP, booking channel, etc.
     * - minOccurs: 0
     * @var \StructType\POS_Type
     */
    public $POS;
    /**
     * The Airline
     * Meta information extracted from the WSDL
     * - documentation: Specify airline on which the person is booked.
     * - minOccurs: 0
     * @var \StructType\CompanyNameType
     */
    public $Airline;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - documentation: Specific flight number on which the passenger is booked.
     * - minOccurs: 0
     * @var string
     */
    public $FlightNumber;
    /**
     * The DepartureAirport
     * Meta information extracted from the WSDL
     * - documentation: Flight Origin - IATA 3 letter code.
     * - minOccurs: 0
     * @var \StructType\LocationType
     */
    public $DepartureAirport;
    /**
     * The DepartureDate
     * Meta information extracted from the WSDL
     * - documentation: Request a reservation with this departure date.
     * - minOccurs: 0
     * @var string
     */
    public $DepartureDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Request a reservation based on a passenger name.
     * - minOccurs: 0
     * @var \StructType\PersonNameType
     */
    public $Name;
    /**
     * The Telephone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Telephone
     */
    public $Telephone;
    /**
     * The CustLoyalty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\CustLoyalty
     */
    public $CustLoyalty;
    /**
     * The CreditCardInfo
     * Meta information extracted from the WSDL
     * - documentation: Request booking records by credit card information.
     * - minOccurs: 0
     * @var \StructType\PaymentCardType
     */
    public $CreditCardInfo;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: Request booking record by ticket number.
     * - minOccurs: 0
     * @var \StructType\TicketingInfoRS_Type
     */
    public $TicketNumber;
    /**
     * The QueueInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\QueueInfo
     */
    public $QueueInfo;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\Date
     */
    public $Date;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The SeatNumber
     * Meta information extracted from the WSDL
     * - documentation: To specify a seat number to be used as criteria for requesting a booking record.
     * - use: optional
     * @var string
     */
    public $SeatNumber;
    /**
     * The IncludeFF_EquivPartnerLev
     * Meta information extracted from the WSDL
     * - documentation: When requesting booking records by frequent flyer level, this is used to indicate that booking records with the codeshare equivalent partner level should also be returned.
     * - use: optional
     * @var bool
     */
    public $IncludeFF_EquivPartnerLev;
    /**
     * The ReturnFF_Number
     * Meta information extracted from the WSDL
     * - documentation: To specify that FF number should be returned for each booking record in the list. The default is do not return, set to true, the FF number should be returned.
     * - use: optional
     * @var bool
     */
    public $ReturnFF_Number;
    /**
     * The ReturnDownlineSeg
     * Meta information extracted from the WSDL
     * - documentation: To specify that downline segment info should be returned. The default is do not return, set to true, the information should be returned.
     * - use: optional
     * @var bool
     */
    public $ReturnDownlineSeg;
    /**
     * The InfoToReturn
     * Meta information extracted from the WSDL
     * - documentation: To specify the type of list requested. Refer to OpenTravel Code List Information To Return (ITR). | Used for codes in the OpenTravel Code tables. Possible values of this pattern are 1, 101, 101.EQP, or 101.EQP.X.
     * - base: xs:string
     * - pattern: [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}
     * - use: optional
     * @var string
     */
    public $InfoToReturn;
    /**
     * The FF_RequestCriteria
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $FF_RequestCriteria;
    /**
     * The No_SSR_Ind
     * Meta information extracted from the WSDL
     * - documentation: When true, do not send SSRs in the response. When false, SSRs would be included in the response.
     * - use: optional
     * @var bool
     */
    public $No_SSR_Ind;
    /**
     * The Start
     * @var string
     */
    public $Start;
    /**
     * The Duration
     * @var string
     */
    public $Duration;
    /**
     * The End
     * @var string
     */
    public $End;
    /**
     * Constructor method for AirReadRequest
     * @uses AirReadRequest::setPOS()
     * @uses AirReadRequest::setAirline()
     * @uses AirReadRequest::setFlightNumber()
     * @uses AirReadRequest::setDepartureAirport()
     * @uses AirReadRequest::setDepartureDate()
     * @uses AirReadRequest::setName()
     * @uses AirReadRequest::setTelephone()
     * @uses AirReadRequest::setCustLoyalty()
     * @uses AirReadRequest::setCreditCardInfo()
     * @uses AirReadRequest::setTicketNumber()
     * @uses AirReadRequest::setQueueInfo()
     * @uses AirReadRequest::setDate()
     * @uses AirReadRequest::setTPA_Extensions()
     * @uses AirReadRequest::setSeatNumber()
     * @uses AirReadRequest::setIncludeFF_EquivPartnerLev()
     * @uses AirReadRequest::setReturnFF_Number()
     * @uses AirReadRequest::setReturnDownlineSeg()
     * @uses AirReadRequest::setInfoToReturn()
     * @uses AirReadRequest::setFF_RequestCriteria()
     * @uses AirReadRequest::setNo_SSR_Ind()
     * @uses AirReadRequest::setStart()
     * @uses AirReadRequest::setDuration()
     * @uses AirReadRequest::setEnd()
     * @param \StructType\POS_Type $pOS
     * @param \StructType\CompanyNameType $airline
     * @param string $flightNumber
     * @param \StructType\LocationType $departureAirport
     * @param string $departureDate
     * @param \StructType\PersonNameType $name
     * @param \StructType\Telephone $telephone
     * @param \StructType\CustLoyalty $custLoyalty
     * @param \StructType\PaymentCardType $creditCardInfo
     * @param \StructType\TicketingInfoRS_Type $ticketNumber
     * @param \StructType\QueueInfo $queueInfo
     * @param \StructType\Date $date
     * @param mixed $tPA_Extensions
     * @param string $seatNumber
     * @param bool $includeFF_EquivPartnerLev
     * @param bool $returnFF_Number
     * @param bool $returnDownlineSeg
     * @param string $infoToReturn
     * @param string $fF_RequestCriteria
     * @param bool $no_SSR_Ind
     * @param string $start
     * @param string $duration
     * @param string $end
     */
    public function __construct(\StructType\POS_Type $pOS = null, \StructType\CompanyNameType $airline = null, $flightNumber = null, \StructType\LocationType $departureAirport = null, $departureDate = null, \StructType\PersonNameType $name = null, \StructType\Telephone $telephone = null, \StructType\CustLoyalty $custLoyalty = null, \StructType\PaymentCardType $creditCardInfo = null, \StructType\TicketingInfoRS_Type $ticketNumber = null, \StructType\QueueInfo $queueInfo = null, \StructType\Date $date = null, $tPA_Extensions = null, $seatNumber = null, $includeFF_EquivPartnerLev = null, $returnFF_Number = null, $returnDownlineSeg = null, $infoToReturn = null, $fF_RequestCriteria = null, $no_SSR_Ind = null, $start = null, $duration = null, $end = null)
    {
        $this
            ->setPOS($pOS)
            ->setAirline($airline)
            ->setFlightNumber($flightNumber)
            ->setDepartureAirport($departureAirport)
            ->setDepartureDate($departureDate)
            ->setName($name)
            ->setTelephone($telephone)
            ->setCustLoyalty($custLoyalty)
            ->setCreditCardInfo($creditCardInfo)
            ->setTicketNumber($ticketNumber)
            ->setQueueInfo($queueInfo)
            ->setDate($date)
            ->setTPA_Extensions($tPA_Extensions)
            ->setSeatNumber($seatNumber)
            ->setIncludeFF_EquivPartnerLev($includeFF_EquivPartnerLev)
            ->setReturnFF_Number($returnFF_Number)
            ->setReturnDownlineSeg($returnDownlineSeg)
            ->setInfoToReturn($infoToReturn)
            ->setFF_RequestCriteria($fF_RequestCriteria)
            ->setNo_SSR_Ind($no_SSR_Ind)
            ->setStart($start)
            ->setDuration($duration)
            ->setEnd($end);
    }
    /**
     * Get POS value
     * @return \StructType\POS_Type|null
     */
    public function getPOS()
    {
        return $this->POS;
    }
    /**
     * Set POS value
     * @param \StructType\POS_Type $pOS
     * @return \StructType\AirReadRequest
     */
    public function setPOS(\StructType\POS_Type $pOS = null)
    {
        $this->POS = $pOS;
        return $this;
    }
    /**
     * Get Airline value
     * @return \StructType\CompanyNameType|null
     */
    public function getAirline()
    {
        return $this->Airline;
    }
    /**
     * Set Airline value
     * @param \StructType\CompanyNameType $airline
     * @return \StructType\AirReadRequest
     */
    public function setAirline(\StructType\CompanyNameType $airline = null)
    {
        $this->Airline = $airline;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return string|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @uses \EnumType\FlightNumberType::valueIsValid()
     * @uses \EnumType\FlightNumberType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $flightNumber
     * @return \StructType\AirReadRequest
     */
    public function setFlightNumber($flightNumber = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FlightNumberType::valueIsValid($flightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FlightNumberType', is_array($flightNumber) ? implode(', ', $flightNumber) : var_export($flightNumber, true), implode(', ', \EnumType\FlightNumberType::getValidValues())), __LINE__);
        }
        $this->FlightNumber = $flightNumber;
        return $this;
    }
    /**
     * Get DepartureAirport value
     * @return \StructType\LocationType|null
     */
    public function getDepartureAirport()
    {
        return $this->DepartureAirport;
    }
    /**
     * Set DepartureAirport value
     * @param \StructType\LocationType $departureAirport
     * @return \StructType\AirReadRequest
     */
    public function setDepartureAirport(\StructType\LocationType $departureAirport = null)
    {
        $this->DepartureAirport = $departureAirport;
        return $this;
    }
    /**
     * Get DepartureDate value
     * @return string|null
     */
    public function getDepartureDate()
    {
        return $this->DepartureDate;
    }
    /**
     * Set DepartureDate value
     * @param string $departureDate
     * @return \StructType\AirReadRequest
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departureDate, true), gettype($departureDate)), __LINE__);
        }
        $this->DepartureDate = $departureDate;
        return $this;
    }
    /**
     * Get Name value
     * @return \StructType\PersonNameType|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param \StructType\PersonNameType $name
     * @return \StructType\AirReadRequest
     */
    public function setName(\StructType\PersonNameType $name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Telephone value
     * @return \StructType\Telephone|null
     */
    public function getTelephone()
    {
        return $this->Telephone;
    }
    /**
     * Set Telephone value
     * @param \StructType\Telephone $telephone
     * @return \StructType\AirReadRequest
     */
    public function setTelephone(\StructType\Telephone $telephone = null)
    {
        $this->Telephone = $telephone;
        return $this;
    }
    /**
     * Get CustLoyalty value
     * @return \StructType\CustLoyalty|null
     */
    public function getCustLoyalty()
    {
        return $this->CustLoyalty;
    }
    /**
     * Set CustLoyalty value
     * @param \StructType\CustLoyalty $custLoyalty
     * @return \StructType\AirReadRequest
     */
    public function setCustLoyalty(\StructType\CustLoyalty $custLoyalty = null)
    {
        $this->CustLoyalty = $custLoyalty;
        return $this;
    }
    /**
     * Get CreditCardInfo value
     * @return \StructType\PaymentCardType|null
     */
    public function getCreditCardInfo()
    {
        return $this->CreditCardInfo;
    }
    /**
     * Set CreditCardInfo value
     * @param \StructType\PaymentCardType $creditCardInfo
     * @return \StructType\AirReadRequest
     */
    public function setCreditCardInfo(\StructType\PaymentCardType $creditCardInfo = null)
    {
        $this->CreditCardInfo = $creditCardInfo;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return \StructType\TicketingInfoRS_Type|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param \StructType\TicketingInfoRS_Type $ticketNumber
     * @return \StructType\AirReadRequest
     */
    public function setTicketNumber(\StructType\TicketingInfoRS_Type $ticketNumber = null)
    {
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get QueueInfo value
     * @return \StructType\QueueInfo|null
     */
    public function getQueueInfo()
    {
        return $this->QueueInfo;
    }
    /**
     * Set QueueInfo value
     * @param \StructType\QueueInfo $queueInfo
     * @return \StructType\AirReadRequest
     */
    public function setQueueInfo(\StructType\QueueInfo $queueInfo = null)
    {
        $this->QueueInfo = $queueInfo;
        return $this;
    }
    /**
     * Get Date value
     * @return \StructType\Date|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param \StructType\Date $date
     * @return \StructType\AirReadRequest
     */
    public function setDate(\StructType\Date $date = null)
    {
        $this->Date = $date;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirReadRequest
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get SeatNumber value
     * @return string|null
     */
    public function getSeatNumber()
    {
        return $this->SeatNumber;
    }
    /**
     * Set SeatNumber value
     * @param string $seatNumber
     * @return \StructType\AirReadRequest
     */
    public function setSeatNumber($seatNumber = null)
    {
        // validation for constraint: string
        if (!is_null($seatNumber) && !is_string($seatNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNumber, true), gettype($seatNumber)), __LINE__);
        }
        $this->SeatNumber = $seatNumber;
        return $this;
    }
    /**
     * Get IncludeFF_EquivPartnerLev value
     * @return bool|null
     */
    public function getIncludeFF_EquivPartnerLev()
    {
        return $this->IncludeFF_EquivPartnerLev;
    }
    /**
     * Set IncludeFF_EquivPartnerLev value
     * @param bool $includeFF_EquivPartnerLev
     * @return \StructType\AirReadRequest
     */
    public function setIncludeFF_EquivPartnerLev($includeFF_EquivPartnerLev = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFF_EquivPartnerLev) && !is_bool($includeFF_EquivPartnerLev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFF_EquivPartnerLev, true), gettype($includeFF_EquivPartnerLev)), __LINE__);
        }
        $this->IncludeFF_EquivPartnerLev = $includeFF_EquivPartnerLev;
        return $this;
    }
    /**
     * Get ReturnFF_Number value
     * @return bool|null
     */
    public function getReturnFF_Number()
    {
        return $this->ReturnFF_Number;
    }
    /**
     * Set ReturnFF_Number value
     * @param bool $returnFF_Number
     * @return \StructType\AirReadRequest
     */
    public function setReturnFF_Number($returnFF_Number = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnFF_Number) && !is_bool($returnFF_Number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnFF_Number, true), gettype($returnFF_Number)), __LINE__);
        }
        $this->ReturnFF_Number = $returnFF_Number;
        return $this;
    }
    /**
     * Get ReturnDownlineSeg value
     * @return bool|null
     */
    public function getReturnDownlineSeg()
    {
        return $this->ReturnDownlineSeg;
    }
    /**
     * Set ReturnDownlineSeg value
     * @param bool $returnDownlineSeg
     * @return \StructType\AirReadRequest
     */
    public function setReturnDownlineSeg($returnDownlineSeg = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnDownlineSeg) && !is_bool($returnDownlineSeg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnDownlineSeg, true), gettype($returnDownlineSeg)), __LINE__);
        }
        $this->ReturnDownlineSeg = $returnDownlineSeg;
        return $this;
    }
    /**
     * Get InfoToReturn value
     * @return string|null
     */
    public function getInfoToReturn()
    {
        return $this->InfoToReturn;
    }
    /**
     * Set InfoToReturn value
     * @param string $infoToReturn
     * @return \StructType\AirReadRequest
     */
    public function setInfoToReturn($infoToReturn = null)
    {
        // validation for constraint: string
        if (!is_null($infoToReturn) && !is_string($infoToReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoToReturn, true), gettype($infoToReturn)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1})
        if (!is_null($infoToReturn) && !preg_match('/[0-9A-Z]{1,3}(\\.[A-Z]{3}(\\.X){0,1}){0,1}/', $infoToReturn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{1,3}(\.[A-Z]{3}(\.X){0,1}){0,1}', var_export($infoToReturn, true)), __LINE__);
        }
        $this->InfoToReturn = $infoToReturn;
        return $this;
    }
    /**
     * Get FF_RequestCriteria value
     * @return string|null
     */
    public function getFF_RequestCriteria()
    {
        return $this->FF_RequestCriteria;
    }
    /**
     * Set FF_RequestCriteria value
     * @param string $fF_RequestCriteria
     * @return \StructType\AirReadRequest
     */
    public function setFF_RequestCriteria($fF_RequestCriteria = null)
    {
        // validation for constraint: string
        if (!is_null($fF_RequestCriteria) && !is_string($fF_RequestCriteria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fF_RequestCriteria, true), gettype($fF_RequestCriteria)), __LINE__);
        }
        $this->FF_RequestCriteria = $fF_RequestCriteria;
        return $this;
    }
    /**
     * Get No_SSR_Ind value
     * @return bool|null
     */
    public function getNo_SSR_Ind()
    {
        return $this->No_SSR_Ind;
    }
    /**
     * Set No_SSR_Ind value
     * @param bool $no_SSR_Ind
     * @return \StructType\AirReadRequest
     */
    public function setNo_SSR_Ind($no_SSR_Ind = null)
    {
        // validation for constraint: boolean
        if (!is_null($no_SSR_Ind) && !is_bool($no_SSR_Ind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($no_SSR_Ind, true), gettype($no_SSR_Ind)), __LINE__);
        }
        $this->No_SSR_Ind = $no_SSR_Ind;
        return $this;
    }
    /**
     * Get Start value
     * @return string|null
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\AirReadRequest
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get Duration value
     * @return string|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param string $duration
     * @return \StructType\AirReadRequest
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: string
        if (!is_null($duration) && !is_string($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duration, true), gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Get End value
     * @return string|null
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\AirReadRequest
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirReadRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
