<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary ancillary offer information without pricing.
 * @subpackage Structs
 */
class AirOfferType extends AbstractStructBase
{
    /**
     * The ServiceFamily
     * Meta information extracted from the WSDL
     * - documentation: Airline or ATPCO encoded service family(s).
     * - minOccurs: 0
     * @var mixed
     */
    public $ServiceFamily;
    /**
     * The Restriction
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Restriction[]
     */
    public $Restriction;
    /**
     * The ShortDescription
     * Meta information extracted from the WSDL
     * - documentation: A detailed description of the ancillary item.
     * - minOccurs: 0
     * @var mixed
     */
    public $ShortDescription;
    /**
     * The TermsAndConditions
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TermsAndConditions[]
     */
    public $TermsAndConditions;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - documentation: The unique ID of this priced offer.
     * - use: optional
     * @var string
     */
    public $ID;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: The name of the ancillary item or offer.
     * - use: optional
     * @var string
     */
    public $Name;
    /**
     * The BundleInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this offer is associated with another offer and may not be sold individually.
     * - use: optional
     * @var bool
     */
    public $BundleInd;
    /**
     * The BundleID
     * Meta information extracted from the WSDL
     * - documentation: The unique ID of a priced offer that this offer is associated with.
     * - use: optional
     * @var string
     */
    public $BundleID;
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this is an offer that must be shown to the customer.
     * - use: optional
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The AcceptInd
     * Meta information extracted from the WSDL
     * - documentation: If true, this is an offer that must be accepted by the customer.
     * - use: optional
     * @var bool
     */
    public $AcceptInd;
    /**
     * Constructor method for AirOfferType
     * @uses AirOfferType::setServiceFamily()
     * @uses AirOfferType::setRestriction()
     * @uses AirOfferType::setShortDescription()
     * @uses AirOfferType::setTermsAndConditions()
     * @uses AirOfferType::setTPA_Extensions()
     * @uses AirOfferType::setID()
     * @uses AirOfferType::setName()
     * @uses AirOfferType::setBundleInd()
     * @uses AirOfferType::setBundleID()
     * @uses AirOfferType::setMandatoryInd()
     * @uses AirOfferType::setAcceptInd()
     * @param mixed $serviceFamily
     * @param \StructType\Restriction[] $restriction
     * @param mixed $shortDescription
     * @param \StructType\TermsAndConditions[] $termsAndConditions
     * @param mixed $tPA_Extensions
     * @param string $iD
     * @param string $name
     * @param bool $bundleInd
     * @param string $bundleID
     * @param bool $mandatoryInd
     * @param bool $acceptInd
     */
    public function __construct($serviceFamily = null, array $restriction = array(), $shortDescription = null, array $termsAndConditions = array(), $tPA_Extensions = null, $iD = null, $name = null, $bundleInd = null, $bundleID = null, $mandatoryInd = null, $acceptInd = null)
    {
        $this
            ->setServiceFamily($serviceFamily)
            ->setRestriction($restriction)
            ->setShortDescription($shortDescription)
            ->setTermsAndConditions($termsAndConditions)
            ->setTPA_Extensions($tPA_Extensions)
            ->setID($iD)
            ->setName($name)
            ->setBundleInd($bundleInd)
            ->setBundleID($bundleID)
            ->setMandatoryInd($mandatoryInd)
            ->setAcceptInd($acceptInd);
    }
    /**
     * Get ServiceFamily value
     * @return mixed|null
     */
    public function getServiceFamily()
    {
        return $this->ServiceFamily;
    }
    /**
     * Set ServiceFamily value
     * @param mixed $serviceFamily
     * @return \StructType\AirOfferType
     */
    public function setServiceFamily($serviceFamily = null)
    {
        $this->ServiceFamily = $serviceFamily;
        return $this;
    }
    /**
     * Get Restriction value
     * @return \StructType\Restriction[]|null
     */
    public function getRestriction()
    {
        return $this->Restriction;
    }
    /**
     * This method is responsible for validating the values passed to the setRestriction method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRestriction method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRestrictionForArrayConstraintsFromSetRestriction(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airOfferTypeRestrictionItem) {
            // validation for constraint: itemType
            if (!$airOfferTypeRestrictionItem instanceof \StructType\Restriction) {
                $invalidValues[] = is_object($airOfferTypeRestrictionItem) ? get_class($airOfferTypeRestrictionItem) : sprintf('%s(%s)', gettype($airOfferTypeRestrictionItem), var_export($airOfferTypeRestrictionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Restriction property can only contain items of type \StructType\Restriction, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Restriction value
     * @throws \InvalidArgumentException
     * @param \StructType\Restriction[] $restriction
     * @return \StructType\AirOfferType
     */
    public function setRestriction(array $restriction = array())
    {
        // validation for constraint: array
        if ('' !== ($restrictionArrayErrorMessage = self::validateRestrictionForArrayConstraintsFromSetRestriction($restriction))) {
            throw new \InvalidArgumentException($restrictionArrayErrorMessage, __LINE__);
        }
        $this->Restriction = $restriction;
        return $this;
    }
    /**
     * Add item to Restriction value
     * @throws \InvalidArgumentException
     * @param \StructType\Restriction $item
     * @return \StructType\AirOfferType
     */
    public function addToRestriction(\StructType\Restriction $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Restriction) {
            throw new \InvalidArgumentException(sprintf('The Restriction property can only contain items of type \StructType\Restriction, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Restriction[] = $item;
        return $this;
    }
    /**
     * Get ShortDescription value
     * @return mixed|null
     */
    public function getShortDescription()
    {
        return $this->ShortDescription;
    }
    /**
     * Set ShortDescription value
     * @param mixed $shortDescription
     * @return \StructType\AirOfferType
     */
    public function setShortDescription($shortDescription = null)
    {
        $this->ShortDescription = $shortDescription;
        return $this;
    }
    /**
     * Get TermsAndConditions value
     * @return \StructType\TermsAndConditions[]|null
     */
    public function getTermsAndConditions()
    {
        return $this->TermsAndConditions;
    }
    /**
     * This method is responsible for validating the values passed to the setTermsAndConditions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTermsAndConditions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTermsAndConditionsForArrayConstraintsFromSetTermsAndConditions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airOfferTypeTermsAndConditionsItem) {
            // validation for constraint: itemType
            if (!$airOfferTypeTermsAndConditionsItem instanceof \StructType\TermsAndConditions) {
                $invalidValues[] = is_object($airOfferTypeTermsAndConditionsItem) ? get_class($airOfferTypeTermsAndConditionsItem) : sprintf('%s(%s)', gettype($airOfferTypeTermsAndConditionsItem), var_export($airOfferTypeTermsAndConditionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TermsAndConditions property can only contain items of type \StructType\TermsAndConditions, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TermsAndConditions value
     * @throws \InvalidArgumentException
     * @param \StructType\TermsAndConditions[] $termsAndConditions
     * @return \StructType\AirOfferType
     */
    public function setTermsAndConditions(array $termsAndConditions = array())
    {
        // validation for constraint: array
        if ('' !== ($termsAndConditionsArrayErrorMessage = self::validateTermsAndConditionsForArrayConstraintsFromSetTermsAndConditions($termsAndConditions))) {
            throw new \InvalidArgumentException($termsAndConditionsArrayErrorMessage, __LINE__);
        }
        $this->TermsAndConditions = $termsAndConditions;
        return $this;
    }
    /**
     * Add item to TermsAndConditions value
     * @throws \InvalidArgumentException
     * @param \StructType\TermsAndConditions $item
     * @return \StructType\AirOfferType
     */
    public function addToTermsAndConditions(\StructType\TermsAndConditions $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TermsAndConditions) {
            throw new \InvalidArgumentException(sprintf('The TermsAndConditions property can only contain items of type \StructType\TermsAndConditions, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TermsAndConditions[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirOfferType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\AirOfferType
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\AirOfferType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get BundleInd value
     * @return bool|null
     */
    public function getBundleInd()
    {
        return $this->BundleInd;
    }
    /**
     * Set BundleInd value
     * @param bool $bundleInd
     * @return \StructType\AirOfferType
     */
    public function setBundleInd($bundleInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($bundleInd) && !is_bool($bundleInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bundleInd, true), gettype($bundleInd)), __LINE__);
        }
        $this->BundleInd = $bundleInd;
        return $this;
    }
    /**
     * Get BundleID value
     * @return string|null
     */
    public function getBundleID()
    {
        return $this->BundleID;
    }
    /**
     * Set BundleID value
     * @param string $bundleID
     * @return \StructType\AirOfferType
     */
    public function setBundleID($bundleID = null)
    {
        // validation for constraint: string
        if (!is_null($bundleID) && !is_string($bundleID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleID, true), gettype($bundleID)), __LINE__);
        }
        $this->BundleID = $bundleID;
        return $this;
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\AirOfferType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get AcceptInd value
     * @return bool|null
     */
    public function getAcceptInd()
    {
        return $this->AcceptInd;
    }
    /**
     * Set AcceptInd value
     * @param bool $acceptInd
     * @return \StructType\AirOfferType
     */
    public function setAcceptInd($acceptInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptInd) && !is_bool($acceptInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptInd, true), gettype($acceptInd)), __LINE__);
        }
        $this->AcceptInd = $acceptInd;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirOfferType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
