<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirItineraryPricingInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Pricing Information for an Air Itinerary.
 * @subpackage Structs
 */
class AirItineraryPricingInfoType extends AbstractStructBase
{
    /**
     * The ItinTotalFare
     * Meta information extracted from the WSDL
     * - maxOccurs: 2
     * - minOccurs: 0
     * @var \StructType\ItinTotalFare[]
     */
    public $ItinTotalFare;
    /**
     * The PTC_FareBreakdowns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\PTC_FareBreakdowns
     */
    public $PTC_FareBreakdowns;
    /**
     * The FareInfos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\FareInfos
     */
    public $FareInfos;
    /**
     * The PriceRequestInformation
     * Meta information extracted from the WSDL
     * - documentation: Identifies pricing source, if negotiated fares are requested and if it is a reprice request.
     * - minOccurs: 0
     * @var mixed
     */
    public $PriceRequestInformation;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * The PricingSource
     * Meta information extracted from the WSDL
     * - documentation: Used to indicate whether the pricing is public or private
     * - use: optional
     * @var string
     */
    public $PricingSource;
    /**
     * The ValidatingAirlineCode
     * Meta information extracted from the WSDL
     * - documentation: The code of the validating airline.
     * - use: optional
     * @var string
     */
    public $ValidatingAirlineCode;
    /**
     * The QuoteID
     * Meta information extracted from the WSDL
     * - documentation: A text field used to provide a special ID code that is associated with the priced itinerary that may be used in the reservation request in order to obtain the quoted rate.
     * - use: optional
     * @var string
     */
    public $QuoteID;
    /**
     * Constructor method for AirItineraryPricingInfoType
     * @uses AirItineraryPricingInfoType::setItinTotalFare()
     * @uses AirItineraryPricingInfoType::setPTC_FareBreakdowns()
     * @uses AirItineraryPricingInfoType::setFareInfos()
     * @uses AirItineraryPricingInfoType::setPriceRequestInformation()
     * @uses AirItineraryPricingInfoType::setTPA_Extensions()
     * @uses AirItineraryPricingInfoType::setPricingSource()
     * @uses AirItineraryPricingInfoType::setValidatingAirlineCode()
     * @uses AirItineraryPricingInfoType::setQuoteID()
     * @param \StructType\ItinTotalFare[] $itinTotalFare
     * @param \StructType\PTC_FareBreakdowns $pTC_FareBreakdowns
     * @param \StructType\FareInfos $fareInfos
     * @param mixed $priceRequestInformation
     * @param mixed $tPA_Extensions
     * @param string $pricingSource
     * @param string $validatingAirlineCode
     * @param string $quoteID
     */
    public function __construct(array $itinTotalFare = array(), \StructType\PTC_FareBreakdowns $pTC_FareBreakdowns = null, \StructType\FareInfos $fareInfos = null, $priceRequestInformation = null, $tPA_Extensions = null, $pricingSource = null, $validatingAirlineCode = null, $quoteID = null)
    {
        $this
            ->setItinTotalFare($itinTotalFare)
            ->setPTC_FareBreakdowns($pTC_FareBreakdowns)
            ->setFareInfos($fareInfos)
            ->setPriceRequestInformation($priceRequestInformation)
            ->setTPA_Extensions($tPA_Extensions)
            ->setPricingSource($pricingSource)
            ->setValidatingAirlineCode($validatingAirlineCode)
            ->setQuoteID($quoteID);
    }
    /**
     * Get ItinTotalFare value
     * @return \StructType\ItinTotalFare[]|null
     */
    public function getItinTotalFare()
    {
        return $this->ItinTotalFare;
    }
    /**
     * This method is responsible for validating the values passed to the setItinTotalFare method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItinTotalFare method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItinTotalFareForArrayConstraintsFromSetItinTotalFare(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airItineraryPricingInfoTypeItinTotalFareItem) {
            // validation for constraint: itemType
            if (!$airItineraryPricingInfoTypeItinTotalFareItem instanceof \StructType\ItinTotalFare) {
                $invalidValues[] = is_object($airItineraryPricingInfoTypeItinTotalFareItem) ? get_class($airItineraryPricingInfoTypeItinTotalFareItem) : sprintf('%s(%s)', gettype($airItineraryPricingInfoTypeItinTotalFareItem), var_export($airItineraryPricingInfoTypeItinTotalFareItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItinTotalFare property can only contain items of type \StructType\ItinTotalFare, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItinTotalFare value
     * @throws \InvalidArgumentException
     * @param \StructType\ItinTotalFare[] $itinTotalFare
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setItinTotalFare(array $itinTotalFare = array())
    {
        // validation for constraint: array
        if ('' !== ($itinTotalFareArrayErrorMessage = self::validateItinTotalFareForArrayConstraintsFromSetItinTotalFare($itinTotalFare))) {
            throw new \InvalidArgumentException($itinTotalFareArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($itinTotalFare) && count($itinTotalFare) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 2', count($itinTotalFare)), __LINE__);
        }
        $this->ItinTotalFare = $itinTotalFare;
        return $this;
    }
    /**
     * Add item to ItinTotalFare value
     * @throws \InvalidArgumentException
     * @param \StructType\ItinTotalFare $item
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function addToItinTotalFare(\StructType\ItinTotalFare $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItinTotalFare) {
            throw new \InvalidArgumentException(sprintf('The ItinTotalFare property can only contain items of type \StructType\ItinTotalFare, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(2)
        if (is_array($this->ItinTotalFare) && count($this->ItinTotalFare) >= 2) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 2', count($this->ItinTotalFare)), __LINE__);
        }
        $this->ItinTotalFare[] = $item;
        return $this;
    }
    /**
     * Get PTC_FareBreakdowns value
     * @return \StructType\PTC_FareBreakdowns|null
     */
    public function getPTC_FareBreakdowns()
    {
        return $this->PTC_FareBreakdowns;
    }
    /**
     * Set PTC_FareBreakdowns value
     * @param \StructType\PTC_FareBreakdowns $pTC_FareBreakdowns
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setPTC_FareBreakdowns(\StructType\PTC_FareBreakdowns $pTC_FareBreakdowns = null)
    {
        $this->PTC_FareBreakdowns = $pTC_FareBreakdowns;
        return $this;
    }
    /**
     * Get FareInfos value
     * @return \StructType\FareInfos|null
     */
    public function getFareInfos()
    {
        return $this->FareInfos;
    }
    /**
     * Set FareInfos value
     * @param \StructType\FareInfos $fareInfos
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setFareInfos(\StructType\FareInfos $fareInfos = null)
    {
        $this->FareInfos = $fareInfos;
        return $this;
    }
    /**
     * Get PriceRequestInformation value
     * @return mixed|null
     */
    public function getPriceRequestInformation()
    {
        return $this->PriceRequestInformation;
    }
    /**
     * Set PriceRequestInformation value
     * @param mixed $priceRequestInformation
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setPriceRequestInformation($priceRequestInformation = null)
    {
        $this->PriceRequestInformation = $priceRequestInformation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Get PricingSource value
     * @return string|null
     */
    public function getPricingSource()
    {
        return $this->PricingSource;
    }
    /**
     * Set PricingSource value
     * @uses \EnumType\PricingSourceType::valueIsValid()
     * @uses \EnumType\PricingSourceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricingSource
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setPricingSource($pricingSource = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PricingSourceType::valueIsValid($pricingSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\PricingSourceType', is_array($pricingSource) ? implode(', ', $pricingSource) : var_export($pricingSource, true), implode(', ', \EnumType\PricingSourceType::getValidValues())), __LINE__);
        }
        $this->PricingSource = $pricingSource;
        return $this;
    }
    /**
     * Get ValidatingAirlineCode value
     * @return string|null
     */
    public function getValidatingAirlineCode()
    {
        return $this->ValidatingAirlineCode;
    }
    /**
     * Set ValidatingAirlineCode value
     * @param string $validatingAirlineCode
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setValidatingAirlineCode($validatingAirlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($validatingAirlineCode) && !is_string($validatingAirlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validatingAirlineCode, true), gettype($validatingAirlineCode)), __LINE__);
        }
        $this->ValidatingAirlineCode = $validatingAirlineCode;
        return $this;
    }
    /**
     * Get QuoteID value
     * @return string|null
     */
    public function getQuoteID()
    {
        return $this->QuoteID;
    }
    /**
     * Set QuoteID value
     * @param string $quoteID
     * @return \StructType\AirItineraryPricingInfoType
     */
    public function setQuoteID($quoteID = null)
    {
        // validation for constraint: string
        if (!is_null($quoteID) && !is_string($quoteID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($quoteID, true), gettype($quoteID)), __LINE__);
        }
        $this->QuoteID = $quoteID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirItineraryPricingInfoType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
