<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirInsuranceOfferType StructType
 * Meta information extracted from the WSDL
 * - documentation: The starting and ending date and time for the insurance coverage. | Information required to request third party trip insurance.
 * @subpackage Structs
 */
class AirInsuranceOfferType extends AbstractStructBase
{
    /**
     * The ProviderCompany
     * Meta information extracted from the WSDL
     * - documentation: Identifies the company providing the insurance product.
     * - minOccurs: 0
     * @var mixed
     */
    public $ProviderCompany;
    /**
     * The TotalTripCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\TotalTripCost
     */
    public $TotalTripCost;
    /**
     * The CoveredTraveler
     * Meta information extracted from the WSDL
     * - documentation: Traveler information with individual insurance coverage details.
     * - maxOccurs: 9
     * - minOccurs: 0
     * @var mixed[]
     */
    public $CoveredTraveler;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The third-party insurance product code.
     * - use: optional
     * @var string
     */
    public $Code;
    /**
     * The SellingComponentCode
     * Meta information extracted from the WSDL
     * - documentation: The internal airline selling component code.
     * - use: optional
     * @var string
     */
    public $SellingComponentCode;
    /**
     * The RPH
     * Meta information extracted from the WSDL
     * - documentation: A unique ID for this trip insurance product that may be referenced elsewhere in this message.
     * - use: optional
     * @var string
     */
    public $RPH;
    /**
     * Constructor method for AirInsuranceOfferType
     * @uses AirInsuranceOfferType::setProviderCompany()
     * @uses AirInsuranceOfferType::setTotalTripCost()
     * @uses AirInsuranceOfferType::setCoveredTraveler()
     * @uses AirInsuranceOfferType::setCode()
     * @uses AirInsuranceOfferType::setSellingComponentCode()
     * @uses AirInsuranceOfferType::setRPH()
     * @param mixed $providerCompany
     * @param \StructType\TotalTripCost $totalTripCost
     * @param mixed[] $coveredTraveler
     * @param string $code
     * @param string $sellingComponentCode
     * @param string $rPH
     */
    public function __construct($providerCompany = null, \StructType\TotalTripCost $totalTripCost = null, array $coveredTraveler = array(), $code = null, $sellingComponentCode = null, $rPH = null)
    {
        $this
            ->setProviderCompany($providerCompany)
            ->setTotalTripCost($totalTripCost)
            ->setCoveredTraveler($coveredTraveler)
            ->setCode($code)
            ->setSellingComponentCode($sellingComponentCode)
            ->setRPH($rPH);
    }
    /**
     * Get ProviderCompany value
     * @return mixed|null
     */
    public function getProviderCompany()
    {
        return $this->ProviderCompany;
    }
    /**
     * Set ProviderCompany value
     * @param mixed $providerCompany
     * @return \StructType\AirInsuranceOfferType
     */
    public function setProviderCompany($providerCompany = null)
    {
        $this->ProviderCompany = $providerCompany;
        return $this;
    }
    /**
     * Get TotalTripCost value
     * @return \StructType\TotalTripCost|null
     */
    public function getTotalTripCost()
    {
        return $this->TotalTripCost;
    }
    /**
     * Set TotalTripCost value
     * @param \StructType\TotalTripCost $totalTripCost
     * @return \StructType\AirInsuranceOfferType
     */
    public function setTotalTripCost(\StructType\TotalTripCost $totalTripCost = null)
    {
        $this->TotalTripCost = $totalTripCost;
        return $this;
    }
    /**
     * Get CoveredTraveler value
     * @return mixed[]|null
     */
    public function getCoveredTraveler()
    {
        return $this->CoveredTraveler;
    }
    /**
     * This method is responsible for validating the values passed to the setCoveredTraveler method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoveredTraveler method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCoveredTravelerForArrayConstraintsFromSetCoveredTraveler(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $airInsuranceOfferTypeCoveredTravelerItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($airInsuranceOfferTypeCoveredTravelerItem) ? get_class($airInsuranceOfferTypeCoveredTravelerItem) : sprintf('%s(%s)', gettype($airInsuranceOfferTypeCoveredTravelerItem), var_export($airInsuranceOfferTypeCoveredTravelerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CoveredTraveler property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CoveredTraveler value
     * @throws \InvalidArgumentException
     * @param mixed[] $coveredTraveler
     * @return \StructType\AirInsuranceOfferType
     */
    public function setCoveredTraveler(array $coveredTraveler = array())
    {
        // validation for constraint: array
        if ('' !== ($coveredTravelerArrayErrorMessage = self::validateCoveredTravelerForArrayConstraintsFromSetCoveredTraveler($coveredTraveler))) {
            throw new \InvalidArgumentException($coveredTravelerArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($coveredTraveler) && count($coveredTraveler) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 9', count($coveredTraveler)), __LINE__);
        }
        $this->CoveredTraveler = $coveredTraveler;
        return $this;
    }
    /**
     * Add item to CoveredTraveler value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AirInsuranceOfferType
     */
    public function addToCoveredTraveler($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The CoveredTraveler property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(9)
        if (is_array($this->CoveredTraveler) && count($this->CoveredTraveler) >= 9) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 9', count($this->CoveredTraveler)), __LINE__);
        }
        $this->CoveredTraveler[] = $item;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\AirInsuranceOfferType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get SellingComponentCode value
     * @return string|null
     */
    public function getSellingComponentCode()
    {
        return $this->SellingComponentCode;
    }
    /**
     * Set SellingComponentCode value
     * @param string $sellingComponentCode
     * @return \StructType\AirInsuranceOfferType
     */
    public function setSellingComponentCode($sellingComponentCode = null)
    {
        // validation for constraint: string
        if (!is_null($sellingComponentCode) && !is_string($sellingComponentCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellingComponentCode, true), gettype($sellingComponentCode)), __LINE__);
        }
        $this->SellingComponentCode = $sellingComponentCode;
        return $this;
    }
    /**
     * Get RPH value
     * @return string|null
     */
    public function getRPH()
    {
        return $this->RPH;
    }
    /**
     * Set RPH value
     * @param string $rPH
     * @return \StructType\AirInsuranceOfferType
     */
    public function setRPH($rPH = null)
    {
        // validation for constraint: string
        if (!is_null($rPH) && !is_string($rPH)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rPH, true), gettype($rPH)), __LINE__);
        }
        $this->RPH = $rPH;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirInsuranceOfferType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
