<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgreementsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of agreements data between parties. | Section of a business profile that contains information about trading partner agreements.
 * @subpackage Structs
 */
class AgreementsType extends AbstractStructBase
{
    /**
     * The Certification
     * Meta information extracted from the WSDL
     * - documentation: Information about certifications or accreditations.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Certification;
    /**
     * The AllianceConsortium
     * Meta information extracted from the WSDL
     * - documentation: Information about alliance partnerships and consortiums.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $AllianceConsortium;
    /**
     * The CommissionInfo
     * Meta information extracted from the WSDL
     * - documentation: Information about an agreement for a commission arrangement.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $CommissionInfo;
    /**
     * The ProfileSecurity
     * Meta information extracted from the WSDL
     * - maxOccurs: 99
     * - minOccurs: 0
     * @var \StructType\ProfileSecurity[]
     */
    public $ProfileSecurity;
    /**
     * The ContractInformation
     * Meta information extracted from the WSDL
     * - documentation: Used to reflect contract details linked to a profile.
     * - minOccurs: 0
     * @var mixed
     */
    public $ContractInformation;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for AgreementsType
     * @uses AgreementsType::setCertification()
     * @uses AgreementsType::setAllianceConsortium()
     * @uses AgreementsType::setCommissionInfo()
     * @uses AgreementsType::setProfileSecurity()
     * @uses AgreementsType::setContractInformation()
     * @uses AgreementsType::setTPA_Extensions()
     * @param mixed[] $certification
     * @param mixed[] $allianceConsortium
     * @param mixed[] $commissionInfo
     * @param \StructType\ProfileSecurity[] $profileSecurity
     * @param mixed $contractInformation
     * @param mixed $tPA_Extensions
     */
    public function __construct(array $certification = array(), array $allianceConsortium = array(), array $commissionInfo = array(), array $profileSecurity = array(), $contractInformation = null, $tPA_Extensions = null)
    {
        $this
            ->setCertification($certification)
            ->setAllianceConsortium($allianceConsortium)
            ->setCommissionInfo($commissionInfo)
            ->setProfileSecurity($profileSecurity)
            ->setContractInformation($contractInformation)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get Certification value
     * @return mixed[]|null
     */
    public function getCertification()
    {
        return $this->Certification;
    }
    /**
     * This method is responsible for validating the values passed to the setCertification method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertification method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertificationForArrayConstraintsFromSetCertification(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agreementsTypeCertificationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($agreementsTypeCertificationItem) ? get_class($agreementsTypeCertificationItem) : sprintf('%s(%s)', gettype($agreementsTypeCertificationItem), var_export($agreementsTypeCertificationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Certification property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Certification value
     * @throws \InvalidArgumentException
     * @param mixed[] $certification
     * @return \StructType\AgreementsType
     */
    public function setCertification(array $certification = array())
    {
        // validation for constraint: array
        if ('' !== ($certificationArrayErrorMessage = self::validateCertificationForArrayConstraintsFromSetCertification($certification))) {
            throw new \InvalidArgumentException($certificationArrayErrorMessage, __LINE__);
        }
        $this->Certification = $certification;
        return $this;
    }
    /**
     * Add item to Certification value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AgreementsType
     */
    public function addToCertification($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Certification property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Certification[] = $item;
        return $this;
    }
    /**
     * Get AllianceConsortium value
     * @return mixed[]|null
     */
    public function getAllianceConsortium()
    {
        return $this->AllianceConsortium;
    }
    /**
     * This method is responsible for validating the values passed to the setAllianceConsortium method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllianceConsortium method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllianceConsortiumForArrayConstraintsFromSetAllianceConsortium(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agreementsTypeAllianceConsortiumItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($agreementsTypeAllianceConsortiumItem) ? get_class($agreementsTypeAllianceConsortiumItem) : sprintf('%s(%s)', gettype($agreementsTypeAllianceConsortiumItem), var_export($agreementsTypeAllianceConsortiumItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllianceConsortium property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllianceConsortium value
     * @throws \InvalidArgumentException
     * @param mixed[] $allianceConsortium
     * @return \StructType\AgreementsType
     */
    public function setAllianceConsortium(array $allianceConsortium = array())
    {
        // validation for constraint: array
        if ('' !== ($allianceConsortiumArrayErrorMessage = self::validateAllianceConsortiumForArrayConstraintsFromSetAllianceConsortium($allianceConsortium))) {
            throw new \InvalidArgumentException($allianceConsortiumArrayErrorMessage, __LINE__);
        }
        $this->AllianceConsortium = $allianceConsortium;
        return $this;
    }
    /**
     * Add item to AllianceConsortium value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AgreementsType
     */
    public function addToAllianceConsortium($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The AllianceConsortium property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllianceConsortium[] = $item;
        return $this;
    }
    /**
     * Get CommissionInfo value
     * @return mixed[]|null
     */
    public function getCommissionInfo()
    {
        return $this->CommissionInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setCommissionInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCommissionInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCommissionInfoForArrayConstraintsFromSetCommissionInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agreementsTypeCommissionInfoItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($agreementsTypeCommissionInfoItem) ? get_class($agreementsTypeCommissionInfoItem) : sprintf('%s(%s)', gettype($agreementsTypeCommissionInfoItem), var_export($agreementsTypeCommissionInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CommissionInfo property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CommissionInfo value
     * @throws \InvalidArgumentException
     * @param mixed[] $commissionInfo
     * @return \StructType\AgreementsType
     */
    public function setCommissionInfo(array $commissionInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($commissionInfoArrayErrorMessage = self::validateCommissionInfoForArrayConstraintsFromSetCommissionInfo($commissionInfo))) {
            throw new \InvalidArgumentException($commissionInfoArrayErrorMessage, __LINE__);
        }
        $this->CommissionInfo = $commissionInfo;
        return $this;
    }
    /**
     * Add item to CommissionInfo value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AgreementsType
     */
    public function addToCommissionInfo($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The CommissionInfo property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CommissionInfo[] = $item;
        return $this;
    }
    /**
     * Get ProfileSecurity value
     * @return \StructType\ProfileSecurity[]|null
     */
    public function getProfileSecurity()
    {
        return $this->ProfileSecurity;
    }
    /**
     * This method is responsible for validating the values passed to the setProfileSecurity method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProfileSecurity method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProfileSecurityForArrayConstraintsFromSetProfileSecurity(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $agreementsTypeProfileSecurityItem) {
            // validation for constraint: itemType
            if (!$agreementsTypeProfileSecurityItem instanceof \StructType\ProfileSecurity) {
                $invalidValues[] = is_object($agreementsTypeProfileSecurityItem) ? get_class($agreementsTypeProfileSecurityItem) : sprintf('%s(%s)', gettype($agreementsTypeProfileSecurityItem), var_export($agreementsTypeProfileSecurityItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProfileSecurity property can only contain items of type \StructType\ProfileSecurity, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProfileSecurity value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileSecurity[] $profileSecurity
     * @return \StructType\AgreementsType
     */
    public function setProfileSecurity(array $profileSecurity = array())
    {
        // validation for constraint: array
        if ('' !== ($profileSecurityArrayErrorMessage = self::validateProfileSecurityForArrayConstraintsFromSetProfileSecurity($profileSecurity))) {
            throw new \InvalidArgumentException($profileSecurityArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($profileSecurity) && count($profileSecurity) > 99) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 99', count($profileSecurity)), __LINE__);
        }
        $this->ProfileSecurity = $profileSecurity;
        return $this;
    }
    /**
     * Add item to ProfileSecurity value
     * @throws \InvalidArgumentException
     * @param \StructType\ProfileSecurity $item
     * @return \StructType\AgreementsType
     */
    public function addToProfileSecurity(\StructType\ProfileSecurity $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProfileSecurity) {
            throw new \InvalidArgumentException(sprintf('The ProfileSecurity property can only contain items of type \StructType\ProfileSecurity, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(99)
        if (is_array($this->ProfileSecurity) && count($this->ProfileSecurity) >= 99) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 99', count($this->ProfileSecurity)), __LINE__);
        }
        $this->ProfileSecurity[] = $item;
        return $this;
    }
    /**
     * Get ContractInformation value
     * @return mixed|null
     */
    public function getContractInformation()
    {
        return $this->ContractInformation;
    }
    /**
     * Set ContractInformation value
     * @param mixed $contractInformation
     * @return \StructType\AgreementsType
     */
    public function setContractInformation($contractInformation = null)
    {
        $this->ContractInformation = $contractInformation;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AgreementsType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AgreementsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
