<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AffiliationsType StructType
 * Meta information extracted from the WSDL
 * - documentation: Allows for control of the sharing of affiliation data between parties. | Defines an entity that provides travel services or benefits to a customer or company.
 * @subpackage Structs
 */
class AffiliationsType extends AbstractStructBase
{
    /**
     * The Organization
     * Meta information extracted from the WSDL
     * - documentation: Detailed information for a membership organization that has travel benefits, programs or discounts.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Organization;
    /**
     * The Employer
     * Meta information extracted from the WSDL
     * - documentation: Employer information associated to this affiliation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Employer;
    /**
     * The TravelArranger
     * Meta information extracted from the WSDL
     * - documentation: Information on the organization responsible for arranging travel.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TravelArranger;
    /**
     * The TravelClub
     * Meta information extracted from the WSDL
     * - documentation: A club that offers special privileges and related services for this affiliation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $TravelClub;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - documentation: Travel insurance associated to this affiliation.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var mixed[]
     */
    public $Insurance;
    /**
     * The TPA_Extensions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: TPA_Extensions
     * @var mixed
     */
    public $TPA_Extensions;
    /**
     * Constructor method for AffiliationsType
     * @uses AffiliationsType::setOrganization()
     * @uses AffiliationsType::setEmployer()
     * @uses AffiliationsType::setTravelArranger()
     * @uses AffiliationsType::setTravelClub()
     * @uses AffiliationsType::setInsurance()
     * @uses AffiliationsType::setTPA_Extensions()
     * @param mixed[] $organization
     * @param mixed[] $employer
     * @param mixed[] $travelArranger
     * @param mixed[] $travelClub
     * @param mixed[] $insurance
     * @param mixed $tPA_Extensions
     */
    public function __construct(array $organization = array(), array $employer = array(), array $travelArranger = array(), array $travelClub = array(), array $insurance = array(), $tPA_Extensions = null)
    {
        $this
            ->setOrganization($organization)
            ->setEmployer($employer)
            ->setTravelArranger($travelArranger)
            ->setTravelClub($travelClub)
            ->setInsurance($insurance)
            ->setTPA_Extensions($tPA_Extensions);
    }
    /**
     * Get Organization value
     * @return mixed[]|null
     */
    public function getOrganization()
    {
        return $this->Organization;
    }
    /**
     * This method is responsible for validating the values passed to the setOrganization method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrganization method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrganizationForArrayConstraintsFromSetOrganization(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeOrganizationItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($affiliationsTypeOrganizationItem) ? get_class($affiliationsTypeOrganizationItem) : sprintf('%s(%s)', gettype($affiliationsTypeOrganizationItem), var_export($affiliationsTypeOrganizationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Organization property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Organization value
     * @throws \InvalidArgumentException
     * @param mixed[] $organization
     * @return \StructType\AffiliationsType
     */
    public function setOrganization(array $organization = array())
    {
        // validation for constraint: array
        if ('' !== ($organizationArrayErrorMessage = self::validateOrganizationForArrayConstraintsFromSetOrganization($organization))) {
            throw new \InvalidArgumentException($organizationArrayErrorMessage, __LINE__);
        }
        $this->Organization = $organization;
        return $this;
    }
    /**
     * Add item to Organization value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AffiliationsType
     */
    public function addToOrganization($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Organization property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Organization[] = $item;
        return $this;
    }
    /**
     * Get Employer value
     * @return mixed[]|null
     */
    public function getEmployer()
    {
        return $this->Employer;
    }
    /**
     * This method is responsible for validating the values passed to the setEmployer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEmployer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEmployerForArrayConstraintsFromSetEmployer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeEmployerItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($affiliationsTypeEmployerItem) ? get_class($affiliationsTypeEmployerItem) : sprintf('%s(%s)', gettype($affiliationsTypeEmployerItem), var_export($affiliationsTypeEmployerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Employer property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Employer value
     * @throws \InvalidArgumentException
     * @param mixed[] $employer
     * @return \StructType\AffiliationsType
     */
    public function setEmployer(array $employer = array())
    {
        // validation for constraint: array
        if ('' !== ($employerArrayErrorMessage = self::validateEmployerForArrayConstraintsFromSetEmployer($employer))) {
            throw new \InvalidArgumentException($employerArrayErrorMessage, __LINE__);
        }
        $this->Employer = $employer;
        return $this;
    }
    /**
     * Add item to Employer value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AffiliationsType
     */
    public function addToEmployer($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Employer property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Employer[] = $item;
        return $this;
    }
    /**
     * Get TravelArranger value
     * @return mixed[]|null
     */
    public function getTravelArranger()
    {
        return $this->TravelArranger;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelArranger method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelArranger method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelArrangerForArrayConstraintsFromSetTravelArranger(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeTravelArrangerItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($affiliationsTypeTravelArrangerItem) ? get_class($affiliationsTypeTravelArrangerItem) : sprintf('%s(%s)', gettype($affiliationsTypeTravelArrangerItem), var_export($affiliationsTypeTravelArrangerItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelArranger property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelArranger value
     * @throws \InvalidArgumentException
     * @param mixed[] $travelArranger
     * @return \StructType\AffiliationsType
     */
    public function setTravelArranger(array $travelArranger = array())
    {
        // validation for constraint: array
        if ('' !== ($travelArrangerArrayErrorMessage = self::validateTravelArrangerForArrayConstraintsFromSetTravelArranger($travelArranger))) {
            throw new \InvalidArgumentException($travelArrangerArrayErrorMessage, __LINE__);
        }
        $this->TravelArranger = $travelArranger;
        return $this;
    }
    /**
     * Add item to TravelArranger value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AffiliationsType
     */
    public function addToTravelArranger($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TravelArranger property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelArranger[] = $item;
        return $this;
    }
    /**
     * Get TravelClub value
     * @return mixed[]|null
     */
    public function getTravelClub()
    {
        return $this->TravelClub;
    }
    /**
     * This method is responsible for validating the values passed to the setTravelClub method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelClub method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTravelClubForArrayConstraintsFromSetTravelClub(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeTravelClubItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($affiliationsTypeTravelClubItem) ? get_class($affiliationsTypeTravelClubItem) : sprintf('%s(%s)', gettype($affiliationsTypeTravelClubItem), var_export($affiliationsTypeTravelClubItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TravelClub property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TravelClub value
     * @throws \InvalidArgumentException
     * @param mixed[] $travelClub
     * @return \StructType\AffiliationsType
     */
    public function setTravelClub(array $travelClub = array())
    {
        // validation for constraint: array
        if ('' !== ($travelClubArrayErrorMessage = self::validateTravelClubForArrayConstraintsFromSetTravelClub($travelClub))) {
            throw new \InvalidArgumentException($travelClubArrayErrorMessage, __LINE__);
        }
        $this->TravelClub = $travelClub;
        return $this;
    }
    /**
     * Add item to TravelClub value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AffiliationsType
     */
    public function addToTravelClub($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The TravelClub property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TravelClub[] = $item;
        return $this;
    }
    /**
     * Get Insurance value
     * @return mixed[]|null
     */
    public function getInsurance()
    {
        return $this->Insurance;
    }
    /**
     * This method is responsible for validating the values passed to the setInsurance method
     * This method is willingly generated in order to preserve the one-line inline validation within the setInsurance method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateInsuranceForArrayConstraintsFromSetInsurance(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $affiliationsTypeInsuranceItem) {
            // validation for constraint: itemType
            if (false) {
                $invalidValues[] = is_object($affiliationsTypeInsuranceItem) ? get_class($affiliationsTypeInsuranceItem) : sprintf('%s(%s)', gettype($affiliationsTypeInsuranceItem), var_export($affiliationsTypeInsuranceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Insurance property can only contain items of type anyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Insurance value
     * @throws \InvalidArgumentException
     * @param mixed[] $insurance
     * @return \StructType\AffiliationsType
     */
    public function setInsurance(array $insurance = array())
    {
        // validation for constraint: array
        if ('' !== ($insuranceArrayErrorMessage = self::validateInsuranceForArrayConstraintsFromSetInsurance($insurance))) {
            throw new \InvalidArgumentException($insuranceArrayErrorMessage, __LINE__);
        }
        $this->Insurance = $insurance;
        return $this;
    }
    /**
     * Add item to Insurance value
     * @throws \InvalidArgumentException
     * @param mixed $item
     * @return \StructType\AffiliationsType
     */
    public function addToInsurance($item)
    {
        // validation for constraint: itemType
        if (false) {
            throw new \InvalidArgumentException(sprintf('The Insurance property can only contain items of type anyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Insurance[] = $item;
        return $this;
    }
    /**
     * Get TPA_Extensions value
     * @return mixed|null
     */
    public function getTPA_Extensions()
    {
        return $this->TPA_Extensions;
    }
    /**
     * Set TPA_Extensions value
     * @param mixed $tPA_Extensions
     * @return \StructType\AffiliationsType
     */
    public function setTPA_Extensions($tPA_Extensions = null)
    {
        $this->TPA_Extensions = $tPA_Extensions;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AffiliationsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
