<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdjustmentsType StructType
 * Meta information extracted from the WSDL
 * - documentation: AdjustmentsType.
 * @subpackage Structs
 */
class AdjustmentsType extends AbstractStructBase
{
    /**
     * The Adjustment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\Adjustment[]
     */
    public $Adjustment;
    /**
     * The RequestID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $RequestID;
    /**
     * Constructor method for AdjustmentsType
     * @uses AdjustmentsType::setAdjustment()
     * @uses AdjustmentsType::setRequestID()
     * @param \StructType\Adjustment[] $adjustment
     * @param string $requestID
     */
    public function __construct(array $adjustment = array(), $requestID = null)
    {
        $this
            ->setAdjustment($adjustment)
            ->setRequestID($requestID);
    }
    /**
     * Get Adjustment value
     * @return \StructType\Adjustment[]|null
     */
    public function getAdjustment()
    {
        return $this->Adjustment;
    }
    /**
     * This method is responsible for validating the values passed to the setAdjustment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdjustment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdjustmentForArrayConstraintsFromSetAdjustment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $adjustmentsTypeAdjustmentItem) {
            // validation for constraint: itemType
            if (!$adjustmentsTypeAdjustmentItem instanceof \StructType\Adjustment) {
                $invalidValues[] = is_object($adjustmentsTypeAdjustmentItem) ? get_class($adjustmentsTypeAdjustmentItem) : sprintf('%s(%s)', gettype($adjustmentsTypeAdjustmentItem), var_export($adjustmentsTypeAdjustmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Adjustment property can only contain items of type \StructType\Adjustment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Adjustment value
     * @throws \InvalidArgumentException
     * @param \StructType\Adjustment[] $adjustment
     * @return \StructType\AdjustmentsType
     */
    public function setAdjustment(array $adjustment = array())
    {
        // validation for constraint: array
        if ('' !== ($adjustmentArrayErrorMessage = self::validateAdjustmentForArrayConstraintsFromSetAdjustment($adjustment))) {
            throw new \InvalidArgumentException($adjustmentArrayErrorMessage, __LINE__);
        }
        $this->Adjustment = $adjustment;
        return $this;
    }
    /**
     * Add item to Adjustment value
     * @throws \InvalidArgumentException
     * @param \StructType\Adjustment $item
     * @return \StructType\AdjustmentsType
     */
    public function addToAdjustment(\StructType\Adjustment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Adjustment) {
            throw new \InvalidArgumentException(sprintf('The Adjustment property can only contain items of type \StructType\Adjustment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Adjustment[] = $item;
        return $this;
    }
    /**
     * Get RequestID value
     * @return string|null
     */
    public function getRequestID()
    {
        return $this->RequestID;
    }
    /**
     * Set RequestID value
     * @param string $requestID
     * @return \StructType\AdjustmentsType
     */
    public function setRequestID($requestID = null)
    {
        // validation for constraint: string
        if (!is_null($requestID) && !is_string($requestID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestID, true), gettype($requestID)), __LINE__);
        }
        $this->RequestID = $requestID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdjustmentsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
