<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddtionalRules StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Additional rules.
 * @subpackage Structs
 */
class AddtionalRules extends AbstractStructBase
{
    /**
     * The AdditionalRule
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AdditionalRule[]
     */
    public $AdditionalRule;
    /**
     * Constructor method for AddtionalRules
     * @uses AddtionalRules::setAdditionalRule()
     * @param \StructType\AdditionalRule[] $additionalRule
     */
    public function __construct(array $additionalRule = array())
    {
        $this
            ->setAdditionalRule($additionalRule);
    }
    /**
     * Get AdditionalRule value
     * @return \StructType\AdditionalRule[]|null
     */
    public function getAdditionalRule()
    {
        return $this->AdditionalRule;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalRule method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalRule method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalRuleForArrayConstraintsFromSetAdditionalRule(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $addtionalRulesAdditionalRuleItem) {
            // validation for constraint: itemType
            if (!$addtionalRulesAdditionalRuleItem instanceof \StructType\AdditionalRule) {
                $invalidValues[] = is_object($addtionalRulesAdditionalRuleItem) ? get_class($addtionalRulesAdditionalRuleItem) : sprintf('%s(%s)', gettype($addtionalRulesAdditionalRuleItem), var_export($addtionalRulesAdditionalRuleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalRule property can only contain items of type \StructType\AdditionalRule, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalRule value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalRule[] $additionalRule
     * @return \StructType\AddtionalRules
     */
    public function setAdditionalRule(array $additionalRule = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalRuleArrayErrorMessage = self::validateAdditionalRuleForArrayConstraintsFromSetAdditionalRule($additionalRule))) {
            throw new \InvalidArgumentException($additionalRuleArrayErrorMessage, __LINE__);
        }
        $this->AdditionalRule = $additionalRule;
        return $this;
    }
    /**
     * Add item to AdditionalRule value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalRule $item
     * @return \StructType\AddtionalRules
     */
    public function addToAdditionalRule(\StructType\AdditionalRule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalRule) {
            throw new \InvalidArgumentException(sprintf('The AdditionalRule property can only contain items of type \StructType\AdditionalRule, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalRule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddtionalRules
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
