<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalReward StructType
 * Meta information extracted from the WSDL
 * - documentation: Additional programs that are honored by the primary loyalty account.
 * @subpackage Structs
 */
class AdditionalReward extends AbstractStructBase
{
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $CompanyName;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var mixed
     */
    public $Name;
    /**
     * The MemberID
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $MemberID;
    /**
     * Constructor method for AdditionalReward
     * @uses AdditionalReward::setCompanyName()
     * @uses AdditionalReward::setName()
     * @uses AdditionalReward::setMemberID()
     * @param mixed $companyName
     * @param mixed $name
     * @param string $memberID
     */
    public function __construct($companyName = null, $name = null, $memberID = null)
    {
        $this
            ->setCompanyName($companyName)
            ->setName($name)
            ->setMemberID($memberID);
    }
    /**
     * Get CompanyName value
     * @return mixed|null
     */
    public function getCompanyName()
    {
        return $this->CompanyName;
    }
    /**
     * Set CompanyName value
     * @param mixed $companyName
     * @return \StructType\AdditionalReward
     */
    public function setCompanyName($companyName = null)
    {
        $this->CompanyName = $companyName;
        return $this;
    }
    /**
     * Get Name value
     * @return mixed|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param mixed $name
     * @return \StructType\AdditionalReward
     */
    public function setName($name = null)
    {
        $this->Name = $name;
        return $this;
    }
    /**
     * Get MemberID value
     * @return string|null
     */
    public function getMemberID()
    {
        return $this->MemberID;
    }
    /**
     * Set MemberID value
     * @param string $memberID
     * @return \StructType\AdditionalReward
     */
    public function setMemberID($memberID = null)
    {
        // validation for constraint: string
        if (!is_null($memberID) && !is_string($memberID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberID, true), gettype($memberID)), __LINE__);
        }
        $this->MemberID = $memberID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalReward
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
