<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionalContents StructType
 * Meta information extracted from the WSDL
 * - documentation: A collection of Additional Content elements.
 * @subpackage Structs
 */
class AdditionalContents extends AbstractStructBase
{
    /**
     * The AdditionalContent
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * @var \StructType\AdditionalContent[]
     */
    public $AdditionalContent;
    /**
     * Constructor method for AdditionalContents
     * @uses AdditionalContents::setAdditionalContent()
     * @param \StructType\AdditionalContent[] $additionalContent
     */
    public function __construct(array $additionalContent = array())
    {
        $this
            ->setAdditionalContent($additionalContent);
    }
    /**
     * Get AdditionalContent value
     * @return \StructType\AdditionalContent[]|null
     */
    public function getAdditionalContent()
    {
        return $this->AdditionalContent;
    }
    /**
     * This method is responsible for validating the values passed to the setAdditionalContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAdditionalContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAdditionalContentForArrayConstraintsFromSetAdditionalContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $additionalContentsAdditionalContentItem) {
            // validation for constraint: itemType
            if (!$additionalContentsAdditionalContentItem instanceof \StructType\AdditionalContent) {
                $invalidValues[] = is_object($additionalContentsAdditionalContentItem) ? get_class($additionalContentsAdditionalContentItem) : sprintf('%s(%s)', gettype($additionalContentsAdditionalContentItem), var_export($additionalContentsAdditionalContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AdditionalContent property can only contain items of type \StructType\AdditionalContent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AdditionalContent value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalContent[] $additionalContent
     * @return \StructType\AdditionalContents
     */
    public function setAdditionalContent(array $additionalContent = array())
    {
        // validation for constraint: array
        if ('' !== ($additionalContentArrayErrorMessage = self::validateAdditionalContentForArrayConstraintsFromSetAdditionalContent($additionalContent))) {
            throw new \InvalidArgumentException($additionalContentArrayErrorMessage, __LINE__);
        }
        $this->AdditionalContent = $additionalContent;
        return $this;
    }
    /**
     * Add item to AdditionalContent value
     * @throws \InvalidArgumentException
     * @param \StructType\AdditionalContent $item
     * @return \StructType\AdditionalContents
     */
    public function addToAdditionalContent(\StructType\AdditionalContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AdditionalContent) {
            throw new \InvalidArgumentException(sprintf('The AdditionalContent property can only contain items of type \StructType\AdditionalContent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AdditionalContent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AdditionalContents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
